/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.basepom.mojo.duplicatefinder.classpath.PackageNameHolder;
import org.junit.Assert;
import org.junit.Test;

public class TestPackageNameHolder {
    @Test
    public void testEmpty() {
        PackageNameHolder p1 = new PackageNameHolder();
        Assert.assertEquals((Object)"foo", (Object)p1.getQualifiedName("foo"));
        Assert.assertEquals((Object)"foo", (Object)p1.getQualifiedPath("foo"));
        PackageNameHolder p2 = p1.getChildPackage("bar");
        Assert.assertEquals((Object)"bar.foo", (Object)p2.getQualifiedName("foo"));
        Assert.assertEquals((Object)"bar/foo", (Object)p2.getQualifiedPath("foo"));
    }

    @Test
    public void testPrefilled() {
        PackageNameHolder p1 = new PackageNameHolder((List)ImmutableList.of((Object)"hello", (Object)"world"));
        Assert.assertEquals((Object)"hello.world.foo", (Object)p1.getQualifiedName("foo"));
        Assert.assertEquals((Object)"hello/world/foo", (Object)p1.getQualifiedPath("foo"));
        PackageNameHolder p2 = p1.getChildPackage("bar");
        Assert.assertEquals((Object)"hello.world.bar.foo", (Object)p2.getQualifiedName("foo"));
        Assert.assertEquals((Object)"hello/world/bar/foo", (Object)p2.getQualifiedPath("foo"));
    }
}

