/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.duplicatefinder.ClasspathElement;
import org.basepom.mojo.duplicatefinder.ConflictType;
import org.basepom.mojo.duplicatefinder.ConflictingDependency;
import org.basepom.mojo.duplicatefinder.ResultCollector;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;
import org.basepom.mojo.duplicatefinder.classpath.ClasspathDescriptor;
import org.codehaus.staxmate.out.SMOutputElement;

public final class XMLWriterUtils {
    private XMLWriterUtils() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static SMOutputElement addElement(SMOutputElement document, String name, Object value) throws XMLStreamException {
        SMOutputElement element = document.addElement(name);
        if (value != null) {
            element.addCharacters(value.toString());
        }
        return element;
    }

    public static void addAttribute(SMOutputElement document, String name, Object value) throws XMLStreamException {
        if (value != null) {
            document.addAttribute(name, value.toString());
        }
    }

    public static void addProjectInformation(SMOutputElement rootElement, MavenProject project) throws XMLStreamException {
        SMOutputElement projectElement = rootElement.addElement("project");
        XMLWriterUtils.addAttribute(projectElement, "artifactId", project.getArtifact().getArtifactId());
        XMLWriterUtils.addAttribute(projectElement, "groupId", project.getArtifact().getGroupId());
        XMLWriterUtils.addAttribute(projectElement, "version", project.getArtifact().getVersion());
        XMLWriterUtils.addAttribute(projectElement, "classifier", project.getArtifact().getClassifier());
        XMLWriterUtils.addAttribute(projectElement, "type", project.getArtifact().getType());
    }

    public static void addConflictingDependency(SMOutputElement conflictingDependenciesElement, String name, ConflictingDependency conflictingDependency) throws XMLStreamException {
        SMOutputElement conflictingDependencyElement = conflictingDependenciesElement.addElement(name);
        XMLWriterUtils.addAttribute(conflictingDependencyElement, "currentProject", conflictingDependency.hasCurrentProject());
        XMLWriterUtils.addAttribute(conflictingDependencyElement, "currentProjectIncluded", conflictingDependency.isCurrentProjectIncluded());
        XMLWriterUtils.addAttribute(conflictingDependencyElement, "wildcard", conflictingDependency.isWildcard());
        XMLWriterUtils.addAttribute(conflictingDependencyElement, "bootClasspath", conflictingDependency.hasBootClasspath());
        SMOutputElement dependenciesElement = conflictingDependencyElement.addElement("dependencies");
        for (MavenCoordinates mavenCoordinates : conflictingDependency.getDependencies()) {
            XMLWriterUtils.addMavenCoordinate(dependenciesElement, "dependency", mavenCoordinates);
        }
        SMOutputElement packagesElement = conflictingDependencyElement.addElement("packages");
        for (String packageName : conflictingDependency.getPackages()) {
            XMLWriterUtils.addElement(packagesElement, "package", packageName);
        }
        SMOutputElement sMOutputElement = conflictingDependencyElement.addElement("classes");
        for (String className : conflictingDependency.getClasses()) {
            XMLWriterUtils.addElement(sMOutputElement, "class", className);
        }
        SMOutputElement resourcesElement = conflictingDependencyElement.addElement("resources");
        for (String resourceName : conflictingDependency.getResources()) {
            XMLWriterUtils.addElement(resourcesElement, "resource", resourceName);
        }
        SMOutputElement resourcePatternsElement = conflictingDependencyElement.addElement("resourcePatterns");
        for (Pattern resourcePattern : conflictingDependency.getResourcePatterns()) {
            XMLWriterUtils.addElement(resourcePatternsElement, "resourcePattern", resourcePattern.toString());
        }
    }

    public static void addMavenCoordinate(SMOutputElement dependenciesElement, String name, MavenCoordinates dependency) throws XMLStreamException {
        SMOutputElement dependencyElement = dependenciesElement.addElement(name);
        XMLWriterUtils.addAttribute(dependencyElement, "artifactId", dependency.getArtifactId());
        XMLWriterUtils.addAttribute(dependencyElement, "groupId", dependency.getGroupId());
        if (dependency.getVersion().isPresent()) {
            XMLWriterUtils.addAttribute(dependencyElement, "version", dependency.getVersion().get());
        }
        if (dependency.getVersionRange().isPresent()) {
            XMLWriterUtils.addAttribute(dependencyElement, "versionRange", dependency.getVersionRange().get());
        }
        if (dependency.getClassifier().isPresent()) {
            XMLWriterUtils.addAttribute(dependencyElement, "classifier", dependency.getClassifier().get());
        }
        XMLWriterUtils.addAttribute(dependencyElement, "type", dependency.getType());
    }

    public static void addArtifact(SMOutputElement artifactElement, String name, Artifact artifact) throws XMLStreamException, OverConstrainedVersionException {
        MavenCoordinates coordinates = new MavenCoordinates(artifact);
        XMLWriterUtils.addMavenCoordinate(artifactElement, name, coordinates);
    }

    public static void addResultCollector(SMOutputElement resultElement, ResultCollector resultCollector) throws XMLStreamException, OverConstrainedVersionException {
        XMLWriterUtils.addAttribute(resultElement, "conflictState", (Object)resultCollector.getConflictState());
        XMLWriterUtils.addAttribute(resultElement, "failed", resultCollector.isFailed());
        SMOutputElement conflictsElement = resultElement.addElement("conflicts");
        for (Map.Entry<String, Collection<ResultCollector.ConflictResult>> entry : resultCollector.getAllResults().entrySet()) {
            SMOutputElement conflictElement = conflictsElement.addElement("conflict");
            XMLWriterUtils.addAttribute(conflictElement, "name", entry.getKey());
            SMOutputElement conflictResultsElement = conflictElement.addElement("conflictResults");
            for (ResultCollector.ConflictResult conflictResult : entry.getValue()) {
                XMLWriterUtils.addConflictResult(conflictResultsElement, conflictResult);
            }
        }
    }

    private static void addConflictResult(SMOutputElement conflictResultsElement, ResultCollector.ConflictResult conflictResult) throws XMLStreamException, OverConstrainedVersionException {
        SMOutputElement conflictResultElement = conflictResultsElement.addElement("conflictResult");
        XMLWriterUtils.addAttribute(conflictResultElement, "name", conflictResult.getName());
        XMLWriterUtils.addAttribute(conflictResultElement, "type", (Object)conflictResult.getType());
        XMLWriterUtils.addAttribute(conflictResultElement, "excepted", conflictResult.isExcepted());
        XMLWriterUtils.addAttribute(conflictResultElement, "failed", conflictResult.isFailed());
        XMLWriterUtils.addAttribute(conflictResultElement, "printed", conflictResult.isPrinted());
        XMLWriterUtils.addAttribute(conflictResultElement, "conflictState", (Object)conflictResult.getConflictState());
        SMOutputElement conflictNames = conflictResultElement.addElement("conflictNames");
        for (ClasspathElement entry : conflictResult.getClasspathElements()) {
            SMOutputElement conflictName = conflictNames.addElement("conflictName");
            XMLWriterUtils.addAttribute(conflictName, "name", entry.getName());
            XMLWriterUtils.addAttribute(conflictName, "artifact", entry.hasArtifact());
            XMLWriterUtils.addAttribute(conflictName, "localFolder", entry.isLocalFolder());
            XMLWriterUtils.addAttribute(conflictName, "bootClasspathElement", entry.isBootClasspathElement());
            if (entry.hasArtifact()) {
                XMLWriterUtils.addArtifact(conflictName, "artifact", entry.getArtifact());
                continue;
            }
            File file = entry.getFile();
            if (file.isDirectory()) {
                XMLWriterUtils.addElement(conflictName, "directory", file);
                continue;
            }
            XMLWriterUtils.addElement(conflictName, "file", file);
        }
    }

    public static void addClasspathDescriptor(SMOutputElement resultElement, int resultFileMinClasspathCount, ClasspathDescriptor classpathDescriptor) throws XMLStreamException {
        SMOutputElement resourceExclusionPatternsElement = resultElement.addElement("ignoredResourcePatterns");
        for (Pattern resourceExclusionPattern : classpathDescriptor.getIgnoredResourcePatterns()) {
            XMLWriterUtils.addElement(resourceExclusionPatternsElement, "ignoredResourcePattern", resourceExclusionPattern.toString());
        }
        SMOutputElement ignoredDirectoriesPatternsElement = resultElement.addElement("ignoredDirectoryPatterns");
        for (Pattern ignoredDirectoriesPattern : classpathDescriptor.getIgnoredDirectoryPatterns()) {
            XMLWriterUtils.addElement(ignoredDirectoriesPatternsElement, "ignoredDirectoryPattern", ignoredDirectoriesPattern.toString());
        }
        for (ConflictType type : ConflictType.values()) {
            SMOutputElement classpathElementsElement = resultElement.addElement("classpathElements");
            XMLWriterUtils.addAttribute(classpathElementsElement, "type", (Object)type);
            for (Map.Entry entry : classpathDescriptor.getClasspathElementLocations(type).entrySet()) {
                if (((Collection)entry.getValue()).size() < resultFileMinClasspathCount) continue;
                SMOutputElement classpathElementElement = classpathElementsElement.addElement("classpathElement");
                XMLWriterUtils.addAttribute(classpathElementElement, "name", entry.getKey());
                for (File file : (Collection)entry.getValue()) {
                    XMLWriterUtils.addElement(classpathElementElement, "file", file.getPath());
                }
            }
        }
    }
}

