/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.artifact;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.duplicatefinder.ClasspathElement;
import org.basepom.mojo.duplicatefinder.PluginLog;
import org.basepom.mojo.duplicatefinder.artifact.ArtifactHelper;

public class ArtifactFileResolver {
    private static final PluginLog LOG = new PluginLog(ArtifactFileResolver.class);
    private final BiMap<Artifact, File> localArtifactCache;
    private final BiMap<Artifact, File> repoArtifactCache;
    private final ImmutableSet<File> bootClasspath;
    private final boolean preferLocal;

    public ArtifactFileResolver(MavenProject project, ImmutableSet<File> bootClasspath, boolean preferLocal) throws DependencyResolutionRequiredException {
        Preconditions.checkNotNull((Object)project, (Object)"project is null");
        this.preferLocal = preferLocal;
        this.localArtifactCache = HashBiMap.create((int)project.getArtifacts().size());
        this.repoArtifactCache = HashBiMap.create((int)project.getArtifacts().size());
        this.bootClasspath = bootClasspath;
        for (Artifact artifact : project.getArtifacts()) {
            File repoPath = artifact.getFile();
            DefaultArtifact canonicalizedArtifact = ArtifactFileResolver.canonicalizeArtifact(artifact);
            Preconditions.checkState((repoPath != null && repoPath.exists() ? 1 : 0) != 0, (String)"Repository Path '%s' does not exist.", (Object[])new Object[]{repoPath});
            File oldFile = (File)this.repoArtifactCache.put((Object)canonicalizedArtifact, (Object)repoPath);
            Preconditions.checkState((oldFile == null || oldFile.equals(repoPath) ? 1 : 0) != 0, (String)"Already encountered a file for %s: %s", (Object[])new Object[]{canonicalizedArtifact, oldFile});
        }
        for (MavenProject referencedProject : project.getProjectReferences().values()) {
            Set<Artifact> repoArtifacts = ArtifactFileResolver.findRepoArtifacts(referencedProject, this.repoArtifactCache);
            if (repoArtifacts.isEmpty()) {
                LOG.debug("Found project reference to %s but no repo reference, probably used in a plugin dependency.", referencedProject.getArtifact());
            }
            for (Artifact artifact : repoArtifacts) {
                File outputDir = ArtifactHelper.isTestArtifact(artifact) ? ArtifactHelper.getTestOutputDirectory(referencedProject) : ArtifactHelper.getOutputDirectory(referencedProject);
                if (outputDir == null || !outputDir.exists()) continue;
                File oldFile = (File)this.localArtifactCache.put((Object)artifact, (Object)outputDir);
                Preconditions.checkState((oldFile == null || oldFile.equals(outputDir) ? 1 : 0) != 0, (String)"Already encountered a file for %s: %s", (Object[])new Object[]{artifact, oldFile});
            }
        }
    }

    public ImmutableMap<File, Artifact> resolveArtifactsForScopes(Set<String> scopes) throws InvalidVersionSpecificationException, DependencyResolutionRequiredException {
        Preconditions.checkNotNull(scopes, (Object)"scopes is null");
        ImmutableMap.Builder inScopeBuilder = ImmutableMap.builder();
        for (Artifact artifact : this.listArtifacts()) {
            if (!artifact.getArtifactHandler().isAddedToClasspath() || !scopes.isEmpty() && !scopes.contains(artifact.getScope())) continue;
            File file = this.resolveFileForArtifact(artifact);
            Preconditions.checkState((file != null ? 1 : 0) != 0, (String)"No file for artifact '%s' found!", (Object[])new Object[]{artifact});
            inScopeBuilder.put((Object)file, (Object)artifact);
        }
        return inScopeBuilder.build();
    }

    public ImmutableSortedSet<ClasspathElement> getClasspathElementsForElements(Collection<File> elements) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (File element : elements) {
            builder.add((Object)this.resolveClasspathElementForFile(element));
        }
        return builder.build();
    }

    private ClasspathElement resolveClasspathElementForFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        if (this.preferLocal && this.localArtifactCache.inverse().containsKey((Object)file)) {
            return new ClasspathElement.ClasspathArtifact((Artifact)this.localArtifactCache.inverse().get((Object)file));
        }
        if (this.repoArtifactCache.inverse().containsKey((Object)file)) {
            return new ClasspathElement.ClasspathArtifact((Artifact)this.repoArtifactCache.inverse().get((Object)file));
        }
        if (this.bootClasspath.contains((Object)file)) {
            return new ClasspathElement.ClasspathBootClasspathElement(file);
        }
        if (this.localArtifactCache.inverse().containsKey((Object)file)) {
            return new ClasspathElement.ClasspathArtifact((Artifact)this.localArtifactCache.inverse().get((Object)file));
        }
        return new ClasspathElement.ClasspathLocalFolder(file);
    }

    private File resolveFileForArtifact(Artifact artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        if (this.preferLocal && this.localArtifactCache.containsKey((Object)artifact)) {
            return (File)this.localArtifactCache.get((Object)artifact);
        }
        if (this.repoArtifactCache.containsKey((Object)artifact)) {
            return (File)this.repoArtifactCache.get((Object)artifact);
        }
        return (File)this.localArtifactCache.get((Object)artifact);
    }

    @VisibleForTesting
    static DefaultArtifact canonicalizeArtifact(Artifact artifact) {
        VersionRange versionRange = artifact.getVersionRange() == null ? VersionRange.createFromVersion((String)artifact.getVersion()) : artifact.getVersionRange();
        String type = (String)MoreObjects.firstNonNull((Object)artifact.getType(), (Object)"jar");
        String classifier = artifact.getClassifier();
        if ("test-jar".equals(type) && (classifier == null || "tests".equals(classifier))) {
            type = "jar";
            classifier = "tests";
        }
        DefaultArtifact canonicalizedArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), versionRange, artifact.getScope(), type, classifier, artifact.getArtifactHandler(), artifact.isOptional());
        return canonicalizedArtifact;
    }

    private Set<Artifact> listArtifacts() {
        return ImmutableSet.builder().addAll((Iterable)this.localArtifactCache.keySet()).addAll((Iterable)this.repoArtifactCache.keySet()).build();
    }

    private static Set<Artifact> findRepoArtifacts(MavenProject project, Map<Artifact, File> repoArtifactCache) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Artifact artifact : repoArtifactCache.keySet()) {
            if (!Objects.equal((Object)project.getArtifact().getGroupId(), (Object)artifact.getGroupId()) || !Objects.equal((Object)project.getArtifact().getArtifactId(), (Object)artifact.getArtifactId()) || !Objects.equal((Object)project.getArtifact().getBaseVersion(), (Object)artifact.getBaseVersion())) continue;
            builder.add((Object)artifact);
        }
        return builder.build();
    }

    private static File getLocalProjectPath(MavenProject project, Artifact artifact) throws DependencyResolutionRequiredException {
        String refId = Joiner.on((char)':').join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getVersion()});
        MavenProject owningProject = (MavenProject)project.getProjectReferences().get(refId);
        if (owningProject != null) {
            File outputDir;
            File file = outputDir = ArtifactHelper.isTestArtifact(artifact) ? ArtifactHelper.getTestOutputDirectory(owningProject) : ArtifactHelper.getOutputDirectory(owningProject);
            if (outputDir.exists()) {
                return outputDir;
            }
        }
        return null;
    }
}

