/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;

public class ConflictingDependency {
    private final Set<MavenCoordinates> conflictingDependencies = Sets.newLinkedHashSet();
    private final Set<String> classes = Sets.newHashSet();
    private final Set<String> packages = Sets.newHashSet();
    private final Set<String> resources = Sets.newHashSet();
    private Pattern[] matchingResources = new Pattern[0];
    private boolean currentProject = false;
    private boolean currentProjectIncluded = false;
    private boolean bootClasspath = false;

    public void setConflictingDependencies(Dependency[] conflictingDependencies) throws InvalidVersionSpecificationException {
        for (int idx = 0; idx < conflictingDependencies.length; ++idx) {
            this.conflictingDependencies.add(new MavenCoordinates(conflictingDependencies[idx]));
        }
    }

    public void setResourcePatterns(String[] resourcePatterns) {
        this.matchingResources = new Pattern[resourcePatterns.length];
        for (int i = 0; i < resourcePatterns.length; ++i) {
            this.matchingResources[i] = Pattern.compile(resourcePatterns[i], 66);
        }
    }

    public String[] getClasses() {
        return this.classes.toArray(new String[this.classes.size()]);
    }

    public void setClasses(String[] classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public String[] getPackages() {
        return this.packages.toArray(new String[this.packages.size()]);
    }

    public void setPackages(String[] packages) {
        this.packages.addAll(Arrays.asList(packages));
    }

    public String[] getResources() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void setResources(String[] resources) {
        this.resources.addAll(Arrays.asList(resources));
    }

    public void setCurrentProject(boolean currentProject) {
        this.currentProject = currentProject;
    }

    boolean hasCurrentProject() {
        return this.currentProject;
    }

    public void setBootClasspath(boolean bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    boolean hasBootClasspath() {
        return this.bootClasspath;
    }

    boolean isCurrentProjectIncluded() {
        return this.currentProjectIncluded;
    }

    void addProjectMavenCoordinates(MavenCoordinates projectMavenCoordinates) {
        this.currentProjectIncluded = this.conflictingDependencies.contains(projectMavenCoordinates);
        if (this.currentProject) {
            this.conflictingDependencies.add(projectMavenCoordinates);
        }
    }

    List<MavenCoordinates> getDependencies() {
        return ImmutableList.copyOf(this.conflictingDependencies);
    }

    Pattern[] getResourcePatterns() {
        return this.matchingResources;
    }

    public List<String> getDependencyNames() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.conflictingDependencies.size());
        for (MavenCoordinates conflictingDependency : this.conflictingDependencies) {
            result.add(conflictingDependency.toString());
        }
        Collections.sort(result);
        return result;
    }

    public boolean isForArtifacts(boolean bootClasspathConflict, Set<Artifact> artifacts) throws OverConstrainedVersionException {
        Preconditions.checkNotNull(artifacts, (Object)"artifacts is null");
        if (bootClasspathConflict && !this.bootClasspath) {
            return false;
        }
        if (artifacts.size() > this.conflictingDependencies.size()) {
            return false;
        }
        int numMatches = artifacts.size();
        block0: for (Artifact artifact : artifacts) {
            for (MavenCoordinates conflictingDependency : this.conflictingDependencies) {
                if (!conflictingDependency.matches(artifact)) continue;
                if (--numMatches != 0) continue block0;
                return true;
            }
        }
        return false;
    }

    boolean isWildcard() {
        return this.classes.isEmpty() && this.packages.isEmpty() && this.resources.isEmpty() && this.matchingResources.length == 0;
    }

    public boolean containsClass(String className) {
        if (this.isWildcard()) {
            return true;
        }
        if (this.classes.contains(className)) {
            return true;
        }
        for (String packageName : this.packages) {
            String pkgName = packageName.endsWith(".") ? packageName : packageName + ".";
            if (!className.startsWith(pkgName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsResource(String resource) {
        String resourceAsRelative;
        if (this.isWildcard()) {
            return true;
        }
        String string = resourceAsRelative = resource.startsWith("/") || resource.startsWith("\\") ? resource.substring(1) : resource;
        if (this.resources.contains(resourceAsRelative) || this.resources.contains("/" + resourceAsRelative) || this.resources.contains("\\" + resourceAsRelative)) {
            return true;
        }
        for (int i = 0; i < this.matchingResources.length; ++i) {
            if (!this.matchingResources[i].matcher(resourceAsRelative).matches()) continue;
            return true;
        }
        return false;
    }
}

