/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.basepom.mojo.duplicatefinder.ConflictType;
import org.basepom.mojo.duplicatefinder.PluginLog;
import org.basepom.mojo.duplicatefinder.artifact.MavenCoordinates;
import org.basepom.mojo.duplicatefinder.classpath.ClasspathCacheElement;
import org.basepom.mojo.duplicatefinder.classpath.MatchArtifactPredicate;
import org.basepom.mojo.duplicatefinder.classpath.MatchInnerClassesPredicate;
import org.basepom.mojo.duplicatefinder.classpath.MatchPatternPredicate;
import org.basepom.mojo.duplicatefinder.classpath.PackageNameHolder;

public class ClasspathDescriptor {
    private static final PluginLog LOG = new PluginLog(ClasspathDescriptor.class);
    private static final MatchPatternPredicate DEFAULT_IGNORED_RESOURCES_PREDICATE = new MatchPatternPredicate(Arrays.asList("^META-INF/.*", "^OSGI-INF/.*", "^licenses/.*", ".*license(\\.txt)?$", ".*notice(\\.txt)?$", ".*readme(\\.txt)?$", ".*third-party(\\.txt)?$", ".*package\\.html$", ".*overview\\.html$"));
    private static final MatchPatternPredicate DEFAULT_IGNORED_LOCAL_DIRECTORIES = new MatchPatternPredicate(Arrays.asList("^.git$", "^.svn$", "^.hg$", "^.bzr$"));
    private static final ConcurrentMap<File, ClasspathCacheElement> CACHED_BY_FILE = Maps.newConcurrentMap();
    private final Multimap<String, File> classesWithElements = MultimapBuilder.treeKeys().hashSetValues().build();
    private final Multimap<String, File> resourcesWithElements = MultimapBuilder.treeKeys().hashSetValues().build();
    private final Predicate<String> resourcesPredicate;
    private final Predicate<String> classPredicate = new MatchInnerClassesPredicate();
    private final ImmutableList<Pattern> ignoredResourcePatterns;

    public static ClasspathDescriptor createClasspathDescriptor(MavenProject project, Map<File, Artifact> fileToArtifactMap, Collection<String> ignoredResourcePatterns, Collection<MavenCoordinates> ignoredDependencies, boolean useDefaultResourceIgnoreList, Set<File> bootClasspath, File[] projectFolders) throws MojoExecutionException, InvalidVersionSpecificationException {
        Preconditions.checkNotNull((Object)project, (Object)"project is null");
        Preconditions.checkNotNull(fileToArtifactMap, (Object)"fileToArtifactMap is null");
        Preconditions.checkNotNull(ignoredResourcePatterns, (Object)"ignoredResourcePatterns is null");
        Preconditions.checkNotNull(ignoredDependencies, (Object)"ignoredDependencies is null");
        Preconditions.checkNotNull((Object)projectFolders, (Object)"projectFolders is null");
        ClasspathDescriptor classpathDescriptor = new ClasspathDescriptor(useDefaultResourceIgnoreList, ignoredResourcePatterns);
        File file = null;
        try {
            for (File bootClasspathElement : bootClasspath) {
                file = bootClasspathElement;
                if (file.exists()) {
                    LOG.debug("Adding '%s' as a boot classpath element", file);
                    classpathDescriptor.addClasspathElement(file);
                    continue;
                }
                LOG.debug("Ignoring '%s', does not exist.", file);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(String.format("Error trying to access file '%s' from boot classpath", file), (Exception)ex);
        }
        MatchArtifactPredicate matchArtifactPredicate = new MatchArtifactPredicate(ignoredDependencies);
        Artifact artifact = null;
        try {
            for (Map.Entry<File, Artifact> entry : fileToArtifactMap.entrySet()) {
                artifact = entry.getValue();
                file = entry.getKey();
                if (file.exists()) {
                    if (matchArtifactPredicate.apply(artifact)) continue;
                    classpathDescriptor.addClasspathElement(file);
                    continue;
                }
                LOG.debug("Classpath element '%s' does not exist.", file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(String.format("Error trying to access file '%s' for artifact '%s'", file, artifact), (Exception)ex);
        }
        try {
            File[] arr$ = projectFolders;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File projectFile;
                file = projectFile = arr$[i$];
                if (projectFile.exists()) {
                    classpathDescriptor.addClasspathElement(file);
                    continue;
                }
                LOG.debug("Project folder '%s' does not exist.", file.getAbsolutePath());
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(String.format("Error trying to access project folder '%s'", file), (Exception)ex);
        }
        return classpathDescriptor;
    }

    private ClasspathDescriptor(boolean useDefaultResourceIgnoreList, Collection<String> ignoredResourcePatterns) throws MojoExecutionException {
        ImmutableList.Builder ignoredResourcePatternsBuilder = ImmutableList.builder();
        Predicate resourcesPredicate = Predicates.alwaysFalse();
        if (useDefaultResourceIgnoreList) {
            resourcesPredicate = Predicates.or((Predicate)resourcesPredicate, (Predicate)DEFAULT_IGNORED_RESOURCES_PREDICATE);
            ignoredResourcePatternsBuilder.addAll(DEFAULT_IGNORED_RESOURCES_PREDICATE.getPatterns());
        }
        if (!ignoredResourcePatterns.isEmpty()) {
            try {
                MatchPatternPredicate ignoredResourcesPredicate = new MatchPatternPredicate(ignoredResourcePatterns);
                resourcesPredicate = Predicates.or((Predicate)resourcesPredicate, (Predicate)ignoredResourcesPredicate);
                ignoredResourcePatternsBuilder.addAll(ignoredResourcesPredicate.getPatterns());
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Error compiling resourceIgnore pattern: " + pse.getMessage());
            }
        }
        this.resourcesPredicate = resourcesPredicate;
        this.ignoredResourcePatterns = ignoredResourcePatternsBuilder.build();
    }

    public ImmutableMap<String, Collection<File>> getClasspathElementLocations(ConflictType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        switch (type) {
            case CLASS: {
                return ImmutableMultimap.copyOf(this.classesWithElements).asMap();
            }
            case RESOURCE: {
                return ImmutableMultimap.copyOf(this.resourcesWithElements).asMap();
            }
        }
        throw new IllegalStateException("Type '" + (Object)((Object)type) + "' unknown!");
    }

    public ImmutableList<Pattern> getIgnoredResourcePatterns() {
        return this.ignoredResourcePatterns;
    }

    public ImmutableList<Pattern> getIgnoredDirectoryPatterns() {
        return DEFAULT_IGNORED_LOCAL_DIRECTORIES.getPatterns();
    }

    private void addClasspathElement(File element) throws IOException {
        Preconditions.checkState((boolean)element.exists(), (String)"Path '%s' does not exist!", (Object[])new Object[]{element.getAbsolutePath()});
        ClasspathCacheElement cached = (ClasspathCacheElement)CACHED_BY_FILE.get(element);
        if (cached == null) {
            ClasspathCacheElement.Builder cacheBuilder = ClasspathCacheElement.builder(element);
            if (element.isDirectory()) {
                this.addDirectory(cacheBuilder, element, new PackageNameHolder());
            } else {
                this.addArchive(cacheBuilder, element);
            }
            ClasspathCacheElement newCached = cacheBuilder.build();
            ClasspathCacheElement oldCached = CACHED_BY_FILE.putIfAbsent(element, newCached);
            cached = (ClasspathCacheElement)MoreObjects.firstNonNull((Object)oldCached, (Object)newCached);
        } else {
            LOG.debug("Cache hit for '%s'", element.getAbsolutePath());
        }
        cached.putResources(this.resourcesWithElements, this.resourcesPredicate);
        cached.putClasses(this.classesWithElements, this.classPredicate);
    }

    private void addDirectory(ClasspathCacheElement.Builder cacheBuilder, File workDir, PackageNameHolder packageName) {
        File[] files = workDir.listFiles();
        if (files != null) {
            for (File file : Arrays.asList(files)) {
                if (file.isDirectory()) {
                    if (DEFAULT_IGNORED_LOCAL_DIRECTORIES.apply(file.getName())) {
                        LOG.debug("Ignoring local directory '%s'", file.getAbsolutePath());
                        continue;
                    }
                    this.addDirectory(cacheBuilder, file, packageName.getChildPackage(file.getName()));
                    continue;
                }
                if (file.isFile()) {
                    if ("class".equals(Files.getFileExtension((String)file.getName()))) {
                        String className = packageName.getQualifiedName(Files.getNameWithoutExtension((String)file.getName()));
                        cacheBuilder.addClass(className);
                        continue;
                    }
                    String resourcePath = packageName.getQualifiedPath(file.getName());
                    cacheBuilder.addResource(resourcePath);
                    continue;
                }
                LOG.warn("Ignoring unknown file type for '%s'", file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArchive(ClasspathCacheElement.Builder cacheBuilder, File element) throws IOException {
        Closer closer = Closer.create();
        try {
            ZipEntry entry;
            InputStream input = (InputStream)closer.register((Closeable)element.toURI().toURL().openStream());
            ZipInputStream zipInput = (ZipInputStream)closer.register((Closeable)new ZipInputStream(input));
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if ("class".equals(Files.getFileExtension((String)name))) {
                    List nameElements = Splitter.on((String)"/").splitToList((CharSequence)name);
                    if (nameElements.isEmpty()) {
                        LOG.warn("ZIP entry '%s' split into empty list!", entry);
                        continue;
                    }
                    PackageNameHolder packageName = new PackageNameHolder(nameElements.subList(0, nameElements.size() - 1));
                    String className = packageName.getQualifiedName(Files.getNameWithoutExtension((String)name));
                    cacheBuilder.addClass(className);
                    continue;
                }
                String resourcePath = name.replace('\\', File.separatorChar);
                cacheBuilder.addResource(resourcePath);
            }
        }
        finally {
            closer.close();
        }
    }
}

