/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.Embeddable;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.MappedSuperclass;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.runtime.EnumProviderBuilder;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ReaderManager;
import org.jetbrains.annotations.NotNull;

public abstract class ScalarProvider<T, S> {
    private final Type scalarType;
    private final Class<S> sqlType;
    public static final ScalarProvider<UUID, byte[]> UUID_BY_BYTE_ARRAY = new ScalarProvider<UUID, byte[]>(){

        @Override
        public UUID toScalar(byte[] sqlValue) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(sqlValue);
            long high = byteBuffer.getLong();
            long low = byteBuffer.getLong();
            return new UUID(high, low);
        }

        @Override
        public byte[] toSql(UUID scalarValue) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(scalarValue.getMostSignificantBits());
            byteBuffer.putLong(scalarValue.getLeastSignificantBits());
            return byteBuffer.array();
        }
    };
    public static final ScalarProvider<UUID, String> UUID_BY_STRING = new ScalarProvider<UUID, String>(){

        @Override
        public UUID toScalar(String sqlValue) {
            return UUID.fromString(sqlValue);
        }

        @Override
        public String toSql(UUID scalarValue) {
            return scalarValue.toString();
        }
    };

    public ScalarProvider(Class<T> scalarType, Class<S> sqlType) {
        this.validateScalarType(scalarType);
        this.scalarType = scalarType;
        this.sqlType = sqlType;
    }

    protected ScalarProvider() {
        Map argMap = TypeUtils.getTypeArguments(this.getClass(), ScalarProvider.class);
        if (argMap.isEmpty()) {
            throw new IllegalStateException("Illegal type \"" + this.getClass().getName() + "\", it does not specify generic arguments for \"" + ScalarProvider.class.getName() + "\"");
        }
        TypeVariable<Class<T>>[] params = ScalarProvider.class.getTypeParameters();
        this.scalarType = (Type)argMap.get(params[0]);
        this.sqlType = (Class)argMap.get(params[1]);
        this.validateScalarType(this.scalarType);
    }

    @NotNull
    public final Type getScalarType() {
        return this.scalarType;
    }

    @NotNull
    public final Class<S> getSqlType() {
        return this.sqlType;
    }

    public abstract T toScalar(@NotNull S var1) throws Exception;

    public abstract S toSql(@NotNull T var1) throws Exception;

    public Collection<ImmutableProp> getHandledProps() {
        return null;
    }

    public Reader<S> reader() {
        return null;
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType) {
        return ScalarProvider.enumProviderByString(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType, Consumer<EnumProviderBuilder<E, String>> block) {
        EnumProviderBuilder<Enum, String> builder = EnumProviderBuilder.of(enumType, String.class, Enum::name);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType) {
        return ScalarProvider.enumProviderByInt(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType, Consumer<EnumProviderBuilder<E, Integer>> block) {
        EnumProviderBuilder<Enum, Integer> builder = EnumProviderBuilder.of(enumType, Integer.class, Enum::ordinal);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    private void validateScalarType(Type scalarType) {
        if (scalarType == UUID.class) {
            return;
        }
        if (!(scalarType instanceof Class)) {
            return;
        }
        Class scalarClass = (Class)scalarType;
        if (scalarType == Void.TYPE) {
            throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", it cannot be void");
        }
        if (scalarType == Object.class) {
            throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support object type which means any");
        }
        if (TupleImplementor.class.isAssignableFrom(scalarClass)) {
            throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support tuple type");
        }
        if (ReaderManager.isStandardScalarType(scalarClass)) {
            throw new IllegalArgumentException("Illegal scalar type \"" + ((Class)scalarType).getName() + "\", scalar provider does not support standard scalar type");
        }
        Class<?> annotationType = this.getOrmAnnotationType(scalarClass);
        if (annotationType != null) {
            throw new IllegalArgumentException("Illegal scalar type \"" + scalarClass.getName() + "\", scalar provider does not support scalar type which is decorated by \"@" + annotationType.getName() + "\"");
        }
    }

    private Class<?> getOrmAnnotationType(Class<?> type) {
        Class<?> annoType;
        if (type == null) {
            return null;
        }
        if (type != Object.class) {
            if (type.isAnnotationPresent(Entity.class)) {
                return Entity.class;
            }
            if (type.isAssignableFrom(MappedSuperclass.class)) {
                return MappedSuperclass.class;
            }
            if (type.isAssignableFrom(Embeddable.class)) {
                return Embeddable.class;
            }
        }
        if ((annoType = this.getOrmAnnotationType(type.getSuperclass())) != null) {
            return annoType;
        }
        for (Class<?> interfaceType : type.getInterfaces()) {
            annoType = this.getOrmAnnotationType(interfaceType);
            if (annoType == null) continue;
            return annoType;
        }
        return null;
    }
}

