/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.DataLoader;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetchingCache;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

class FetcherTask {
    private final FetchingCache cache;
    private final JSqlClientImplementor sqlClient;
    private final Field field;
    private final int batchSize;
    private final DataLoader dataLoader;
    private Map<Object, TaskData> pendingMap = new LinkedHashMap<Object, TaskData>();

    public FetcherTask(FetchingCache cache, JSqlClientImplementor sqlClient, Connection con, FetchPath path, Field field) {
        this.cache = cache;
        this.sqlClient = sqlClient;
        this.field = field;
        this.batchSize = this.determineBatchSize();
        this.dataLoader = new DataLoader(sqlClient, con, path, field);
    }

    public void add(DraftSpi draft) {
        this.add(draft, 1);
    }

    private void add(DraftSpi draft, int depth) {
        if (this.isLoaded(draft)) {
            return;
        }
        Object key = this.cache.createKey(this.field, (ImmutableSpi)draft);
        if (key == null) {
            return;
        }
        Object value = this.cache.get(this.field, key);
        if (value != null) {
            this.setDraftProp(draft, FetchingCache.unwrap(value), this.field.isImplicit());
            return;
        }
        this.pendingMap.computeIfAbsent(key, it -> new TaskData(key, depth)).getDrafts().add(draft);
    }

    public boolean execute() {
        TaskData taskData;
        Map<Object, TaskData> handledMap;
        Map.Entry<Object, TaskData> e;
        if (this.pendingMap.isEmpty()) {
            return true;
        }
        if (this.pendingMap.size() > this.batchSize) {
            Iterator<Map.Entry<Object, TaskData>> itr = this.pendingMap.entrySet().iterator();
            if (this.batchSize == 1) {
                e = itr.next();
                handledMap = Collections.singletonMap(e.getKey(), e.getValue());
                itr.remove();
            } else {
                handledMap = new LinkedHashMap<Object, TaskData>((this.batchSize * 4 + 2) / 3);
                for (int i = this.batchSize; i > 0; --i) {
                    Map.Entry<Object, TaskData> e2 = itr.next();
                    handledMap.put(e2.getKey(), e2.getValue());
                    itr.remove();
                }
            }
        } else {
            handledMap = this.pendingMap;
            this.pendingMap = new LinkedHashMap<Object, TaskData>();
        }
        Iterator<Map.Entry<Object, TaskData>> handledEntryItr = handledMap.entrySet().iterator();
        while (handledEntryItr.hasNext()) {
            e = handledEntryItr.next();
            Object key = e.getKey();
            Object value = this.cache.get(this.field, key);
            if (value == null) continue;
            value = FetchingCache.unwrap(value);
            taskData = e.getValue();
            this.afterLoad(taskData, value, false);
            handledEntryItr.remove();
        }
        if (!handledMap.isEmpty()) {
            Map<ImmutableSpi, Object> loadedMap = this.dataLoader.load(handledMap.values().stream().map(it -> it.getDrafts().get(0)).collect(Collectors.toList()));
            for (Map.Entry<Object, TaskData> e3 : handledMap.entrySet()) {
                taskData = e3.getValue();
                Object value = loadedMap.get(taskData.getDrafts().get(0));
                this.afterLoad(taskData, value, true);
            }
        }
        return this.pendingMap.isEmpty();
    }

    private boolean isLoaded(DraftSpi draft) {
        if (!FetcherTask.isLoaded(draft, this.field)) {
            return false;
        }
        if (this.sqlClient.getFilters().getFilter(this.field.getProp().getTargetType()) != null) {
            return false;
        }
        Fetcher<?> childFetcher = this.field.getChildFetcher();
        Object childValue = draft.__get(this.field.getProp().getId());
        if (childFetcher != null && childValue != null) {
            for (Field childField : childFetcher.getFieldMap().values()) {
                if (FetcherTask.isLoaded(childValue, childField)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isLoaded(Object obj, Field field) {
        if (obj instanceof List) {
            List drafts = (List)obj;
            for (DraftSpi draft : drafts) {
                if (FetcherTask.isLoaded(draft, field)) continue;
                return false;
            }
            return true;
        }
        return ((DraftSpi)obj).__isLoaded(field.getProp().getId());
    }

    private void afterLoad(TaskData taskData, Object value, boolean updateCache) {
        if (updateCache) {
            this.cache.put(this.field, taskData.getKey(), value);
        }
        for (DraftSpi draft : taskData.getDrafts()) {
            this.setDraftProp(draft, value, this.field.isImplicit());
        }
        RecursionStrategy<?> recursionStrategy = this.field.getRecursionStrategy();
        if (value instanceof List) {
            List targets = (List)value;
            for (ImmutableSpi target : targets) {
                DraftContext draftContext = Internal.currentDraftContext();
                if (recursionStrategy == null || !recursionStrategy.isRecursive(new RecursionStrategy.Args<ImmutableSpi>(target, taskData.depth))) continue;
                this.add((DraftSpi)draftContext.toDraftObject((Object)target), taskData.getDepth() + 1);
            }
        } else if (value != null && recursionStrategy != null && recursionStrategy.isRecursive(new RecursionStrategy.Args<Object>(value, taskData.depth))) {
            DraftContext draftContext = Internal.currentDraftContext();
            this.add((DraftSpi)draftContext.toDraftObject(value), taskData.getDepth() + 1);
        }
    }

    private int determineBatchSize() {
        if (this.field.getLimit() != Integer.MAX_VALUE) {
            return 1;
        }
        int size = this.field.getBatchSize();
        if (size == 0) {
            if (this.field.getProp().isReferenceList(TargetLevel.PERSISTENT)) {
                return this.sqlClient.getDefaultListBatchSize();
            }
            return this.sqlClient.getDefaultBatchSize();
        }
        return size;
    }

    private void setDraftProp(DraftSpi draft, Object value, boolean isImplicit) {
        PropId propId = this.field.getProp().getId();
        if (value == null && this.field.getProp().isReferenceList(TargetLevel.ENTITY)) {
            draft.__set(propId, Collections.emptyList());
        } else {
            draft.__set(propId, value);
        }
        if (!isImplicit) {
            draft.__show(propId, true);
        }
    }

    private static class TaskData {
        private final Object key;
        private final int depth;
        private final List<DraftSpi> drafts = new ArrayList<DraftSpi>();

        public TaskData(Object key, int depth) {
            this.key = key;
            this.depth = depth;
        }

        public Object getKey() {
            return this.key;
        }

        public int getDepth() {
            return this.depth;
        }

        public List<DraftSpi> getDrafts() {
            return this.drafts;
        }

        public String toString() {
            return "TaskData{depth=" + this.depth + ", drafts=" + this.drafts + '}';
        }
    }
}

