/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NativePredicates;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.JoinTableFilters;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class MiddleTableOperator {
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final boolean isActive;
    private final boolean hasFilter;
    private final boolean isBackProp;
    private final MiddleTable middleTable;
    private final Expression<?> sourceIdExpression;
    private final Expression<?> targetIdExpression;
    private final MutationTrigger trigger;

    private MiddleTableOperator(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, boolean isBackProp, MiddleTable middleTable, MutationTrigger trigger) {
        boolean hasMiddleTableFilter = middleTable.getLogicalDeletedInfo() != null && sqlClient.getFilters().getBehavior() != LogicalDeletedBehavior.IGNORED || middleTable.getFilterInfo() != null;
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.isActive = sqlClient.getEntityManager().isActiveMiddleTableProp(prop);
        this.isBackProp = isBackProp;
        this.middleTable = middleTable;
        if (isBackProp) {
            this.sourceIdExpression = Expression.any().nullValue(prop.getTargetType().getIdProp().getElementClass());
            this.targetIdExpression = Expression.any().nullValue(prop.getDeclaringType().getIdProp().getElementClass());
            this.hasFilter = sqlClient.getFilters().getFilter(prop.getDeclaringType()) != null || hasMiddleTableFilter;
        } else {
            this.sourceIdExpression = Expression.any().nullValue(prop.getDeclaringType().getIdProp().getElementClass());
            this.targetIdExpression = Expression.any().nullValue(prop.getTargetType().getIdProp().getElementClass());
            this.hasFilter = sqlClient.getFilters().getFilter(prop.getTargetType()) != null || hasMiddleTableFilter;
        }
        this.trigger = trigger;
    }

    public static MiddleTableOperator tryGet(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, MutationTrigger trigger) {
        return MiddleTableOperator.tryGetImpl(sqlClient, con, prop, false, trigger);
    }

    static MiddleTableOperator tryGetByBackProp(JSqlClientImplementor sqlClient, Connection con, ImmutableProp backProp, MutationTrigger trigger) {
        return MiddleTableOperator.tryGetImpl(sqlClient, con, backProp, true, trigger);
    }

    private static MiddleTableOperator tryGetImpl(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, boolean isPropBack, MutationTrigger trigger) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null && prop.isRemote()) {
            return null;
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        if (mappedBy != null) {
            Storage storage = mappedBy.getStorage(strategy);
            if (storage instanceof MiddleTable) {
                MiddleTable middleTable = isPropBack ? (MiddleTable)storage : ((MiddleTable)storage).getInverse();
                return new MiddleTableOperator(sqlClient, con, prop, isPropBack, middleTable, trigger);
            }
        } else {
            Storage storage = prop.getStorage(strategy);
            if (storage instanceof MiddleTable) {
                MiddleTable middleTable = isPropBack ? ((MiddleTable)storage).getInverse() : (MiddleTable)storage;
                return new MiddleTableOperator(sqlClient, con, prop, isPropBack, middleTable, trigger);
            }
        }
        return null;
    }

    boolean isActive() {
        return this.isActive;
    }

    boolean isLogicalDeletionSupported() {
        return this.middleTable.getLogicalDeletedInfo() != null;
    }

    boolean isDeletedWhenEndpointIsLogicallyDeleted() {
        return this.middleTable.isDeletedWhenEndpointIsLogicallyDeleted();
    }

    List<Object> getTargetIds(Object id) {
        if (this.hasFilter) {
            return this.getTargetIdsByDsl(id);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, this.middleTable.getColumnDefinition(), Collections.singleton(id), builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Collections.singletonList(this.targetIdExpression), ExecutionPurpose.MUTATE);
    }

    private List<Object> getTargetIdsByDsl(Object id) {
        ImmutableType targetType = this.prop.getTargetType();
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, targetType, ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        TableImplementor<?> table = query.getTableImplementor();
        query.where(new Predicate[]{table.inverseGetAssociatedId(this.prop).eq(id)});
        return (List)query.select(table.get(targetType.getIdProp())).execute(this.con);
    }

    private Collection<Tuple2<?, ?>> filterTuples(Collection<Tuple2<?, ?>> tuples) {
        if (tuples.isEmpty()) {
            return tuples;
        }
        if (this.hasFilter) {
            return this.filterTuplesByDsl(tuples);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderTuplePredicates(false, this.middleTable.getColumnDefinition(), this.middleTable.getTargetColumnDefinition(), tuples, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
    }

    private List<Tuple2<?, ?>> filterTuplesByDsl(Collection<Tuple2<?, ?>> tuples) {
        ImmutableType targetType = this.prop.getTargetType();
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, targetType, ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        TableImplementor<?> table = query.getTableImplementor();
        ImmutableProp sourceIdProp = this.prop.getDeclaringType().getIdProp();
        query.where(new Predicate[]{Expression.tuple(table.inverseJoinImplementor(this.prop).get(sourceIdProp), table.get(targetType.getIdProp())).in((List)tuples)});
        return (List)query.select(table.inverseJoinImplementor(this.prop).get(sourceIdProp), table.get(targetType.getIdProp())).execute(this.con);
    }

    private List<Tuple2<?, ?>> getTuples(Collection<Object> sourceIds, boolean skipLogicalDeletedRows) {
        JoinTableFilterInfo filterInfo;
        LogicalDeletedInfo deletedInfo;
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, this.middleTable.getColumnDefinition(), sourceIds, builder);
        if (skipLogicalDeletedRows && (deletedInfo = this.middleTable.getLogicalDeletedInfo()) != null) {
            builder.separator();
            JoinTableFilters.render(deletedInfo, null, builder);
        }
        if ((filterInfo = this.middleTable.getFilterInfo()) != null) {
            builder.separator();
            JoinTableFilters.render(filterInfo, null, builder);
        }
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
    }

    int addTargetIds(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        LinkedHashSet tuples = new LinkedHashSet((targetIds.size() * 4 + 2) / 3);
        for (Object targetId : targetIds) {
            tuples.add(new Tuple2<Object, Object>(sourceId, targetId));
        }
        return this.add(tuples);
    }

    int add(Collection<Tuple2<?, ?>> tuples) {
        if (this.middleTable.isReadonly()) {
            throw new ExecutionException("The association \"" + this.prop + "\" cannot be changed because its \"@JoinTable\" is readonly");
        }
        if (tuples.isEmpty()) {
            return 0;
        }
        this.tryPrepareEvent(true, tuples);
        LogicalDeletedInfo deletedInfo = this.middleTable.getLogicalDeletedInfo();
        JoinTableFilterInfo filterInfo = this.middleTable.getFilterInfo();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("insert into ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.TUPLE).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition());
        if (deletedInfo != null) {
            builder.separator().sql(deletedInfo.getColumnName());
        }
        if (filterInfo != null) {
            builder.separator().sql(filterInfo.getColumnName());
        }
        builder.leave();
        if (this.sqlClient.getDialect().isMultiInsertionSupported()) {
            builder.enter(SqlBuilder.ScopeType.VALUES);
            for (Tuple2<?, ?> tuple : tuples) {
                builder.separator().enter(SqlBuilder.ScopeType.TUPLE).variable(tuple.get_1()).separator().variable(tuple.get_2());
                if (deletedInfo != null) {
                    builder.separator().variable(deletedInfo.allocateInitializedValue());
                }
                if (filterInfo != null) {
                    builder.separator().variable(filterInfo.getValues().get(0));
                }
                builder.leave();
            }
            builder.leave();
        } else {
            builder.sql(" ");
            String fromConstant = this.sqlClient.getDialect().getConstantTableName();
            if (fromConstant != null) {
                fromConstant = " from " + fromConstant;
            }
            builder.enter("?union all?");
            for (Tuple2<?, ?> tuple : tuples) {
                builder.separator().enter(SqlBuilder.ScopeType.SELECT).variable(tuple.get_1()).separator().variable(tuple.get_2());
                if (deletedInfo != null) {
                    builder.separator().variable(deletedInfo.allocateInitializedValue());
                }
                if (filterInfo != null) {
                    builder.separator().variable(filterInfo.getValues().get(0));
                }
                builder.leave();
                if (fromConstant == null) continue;
                builder.sql(fromConstant);
            }
            builder.leave();
        }
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    int remove(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        LinkedHashSet tuples = new LinkedHashSet((targetIds.size() * 4 + 2) / 3);
        for (Object targetId : targetIds) {
            tuples.add(new Tuple2<Object, Object>(sourceId, targetId));
        }
        return this.remove(tuples);
    }

    int remove(Collection<Tuple2<?, ?>> tuples) {
        return this.remove(tuples, false);
    }

    int remove(Collection<Tuple2<?, ?>> tuples, boolean checkExistence) {
        if (tuples.isEmpty()) {
            return 0;
        }
        if (checkExistence && (tuples = this.filterTuples(tuples)).isEmpty()) {
            return 0;
        }
        this.tryPrepareEvent(false, tuples);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderTuplePredicates(false, this.middleTable.getColumnDefinition(), this.middleTable.getTargetColumnDefinition(), tuples, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    int hide(Collection<Tuple2<?, ?>> tuples) {
        return this.hide(tuples, false);
    }

    int hide(Collection<Tuple2<?, ?>> tuples, boolean checkExistence) {
        if (tuples.isEmpty()) {
            return 0;
        }
        if (checkExistence && (tuples = this.filterTuples(tuples)).isEmpty()) {
            return 0;
        }
        this.tryPrepareEvent(false, tuples);
        LogicalDeletedInfo deletedInfo = this.middleTable.getLogicalDeletedInfo();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("update ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.SET).sql(deletedInfo.getColumnName()).sql(" = ");
        Object deletedValue = this.prop.getLogicalDeletedValueGenerator((SqlContext)this.sqlClient).generate();
        if (deletedValue != null) {
            builder.variable(deletedValue);
        } else {
            builder.nullVariable(deletedInfo.getType());
        }
        builder.leave().enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderTuplePredicates(false, this.middleTable.getColumnDefinition(), this.middleTable.getTargetColumnDefinition(), tuples, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    int setTargetIds(Object sourceId, Collection<Object> targetIds) {
        LinkedHashSet<Object> oldTargetIds = new LinkedHashSet<Object>(this.getTargetIds(sourceId));
        LinkedHashSet<Object> addingTargetIds = new LinkedHashSet<Object>(targetIds);
        addingTargetIds.removeAll(oldTargetIds);
        LinkedHashSet<Object> removingTargetIds = new LinkedHashSet<Object>(oldTargetIds);
        removingTargetIds.removeAll(targetIds);
        return this.remove(sourceId, removingTargetIds) + this.addTargetIds(sourceId, addingTargetIds);
    }

    public int logicallyDeleteBySourceIds(Collection<Object> sourceIds) throws DeletionPreventedException {
        boolean deletionBySourcePrevented = this.middleTable.isDeletionBySourcePrevented();
        if (this.trigger != null || deletionBySourcePrevented) {
            List<Tuple2<?, ?>> tuples = this.getTuples(sourceIds, true);
            if (deletionBySourcePrevented && !tuples.isEmpty()) {
                throw new DeletionPreventedException(this.middleTable, tuples);
            }
            return this.hide(tuples);
        }
        LogicalDeletedInfo deletedInfo = this.middleTable.getLogicalDeletedInfo();
        JoinTableFilterInfo filterInfo = this.middleTable.getFilterInfo();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("update ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.SET).sql(deletedInfo.getColumnName()).sql(" = ");
        Object deletedValue = this.prop.getLogicalDeletedValueGenerator((SqlContext)this.sqlClient).generate();
        if (deletedValue != null) {
            builder.variable(deletedValue);
        } else {
            builder.nullVariable(deletedInfo.getType());
        }
        builder.leave().enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, this.middleTable.getColumnDefinition(), sourceIds, builder);
        builder.separator();
        JoinTableFilters.render(deletedInfo, null, builder);
        if (filterInfo != null) {
            builder.separator();
            JoinTableFilters.render(filterInfo, null, builder);
        }
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate));
    }

    public int physicallyDeleteBySourceIds(Collection<Object> sourceIds) throws DeletionPreventedException {
        boolean deletionBySourcePrevented = this.middleTable.isDeletionBySourcePrevented();
        if (this.trigger != null || deletionBySourcePrevented) {
            List<Tuple2<?, ?>> tuples = this.getTuples(sourceIds, false);
            if (deletionBySourcePrevented && !tuples.isEmpty()) {
                throw new DeletionPreventedException(this.middleTable, tuples);
            }
            return this.remove(tuples);
        }
        JoinTableFilterInfo filterInfo = this.middleTable.getFilterInfo();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, this.middleTable.getColumnDefinition(), sourceIds, builder);
        if (filterInfo != null) {
            builder.separator();
            JoinTableFilters.render(filterInfo, null, builder);
        }
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate));
    }

    private void tryPrepareEvent(boolean insert, Collection<Tuple2<?, ?>> tuples) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return;
        }
        for (Tuple2<?, ?> tuple : tuples) {
            Object sourceId = tuple.get_1();
            Object targetId = tuple.get_2();
            if (this.isBackProp) {
                if (insert) {
                    trigger.insertMiddleTable(this.prop, targetId, sourceId);
                    continue;
                }
                trigger.deleteMiddleTable(this.prop, targetId, sourceId);
                continue;
            }
            if (insert) {
                trigger.insertMiddleTable(this.prop, sourceId, targetId);
                continue;
            }
            trigger.deleteMiddleTable(this.prop, sourceId, targetId);
        }
    }

    static class DeletionPreventedException
    extends Exception {
        final MiddleTable middleTable;
        final List<Tuple2<?, ?>> tuples;

        DeletionPreventedException(MiddleTable middleTable, List<Tuple2<?, ?>> tuples) {
            this.middleTable = middleTable;
            this.tuples = Collections.unmodifiableList(tuples);
        }
    }
}

