/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.babyfish.jimmer.meta.ImmutableProp;

public final class DissociationInfo {
    @NotNull
    private final List<ImmutableProp> props;
    @NotNull
    private final List<ImmutableProp> backProps;

    public DissociationInfo(List<ImmutableProp> props, List<ImmutableProp> backProps) {
        this.props = Objects.requireNonNull(props, "`props` cannot be null");
        this.backProps = Objects.requireNonNull(backProps, "`backProps` cannot be null");
    }

    public List<ImmutableProp> getProps() {
        return this.props;
    }

    public List<ImmutableProp> getBackProps() {
        return this.backProps;
    }

    public int hashCode() {
        return Objects.hash(this.props, this.backProps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DissociationInfo that = (DissociationInfo)o;
        return Objects.equals(this.props, that.props) && Objects.equals(this.backProps, that.backProps);
    }

    public String toString() {
        return "DissociationInfo{props=" + this.props + ", backProps=" + this.backProps + '}';
    }
}

