/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogParser;
import org.babyfish.jimmer.sql.event.binlog.impl.ValueParser;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;

class BinLogDeserializer
extends StdDeserializer<Object> {
    private final BinLogParser parser;
    private final ImmutableType immutableType;

    public BinLogDeserializer(BinLogParser parser, ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.parser = parser;
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        MetadataStrategy strategy = this.parser.sqlClient().getMetadataStrategy();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce((ImmutableType)this.immutableType, null, draft -> {
            Iterator itr = node.fields();
            while (itr.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)itr.next();
                String columnName = (String)fieldEntry.getKey();
                JsonNode childNode = (JsonNode)fieldEntry.getValue();
                List chain = this.immutableType.getPropChain(columnName, strategy);
                ValueParser.addEntityProp((DraftSpi)draft, chain, childNode, this.parser);
            }
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (!prop.isMutable() || !prop.isEmbedded(EmbeddedLevel.BOTH) || EmbeddableObjects.isCompleted(((DraftSpi)draft).__get(prop.getId()))) continue;
                if (!prop.isNullable()) {
                    throw new IllegalArgumentException("Illegal binlog data, the property \"" + prop + "\" is not nullable");
                }
                ((DraftSpi)draft).__set(prop.getId(), null);
            }
        });
    }
}

