/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.AssociationEvent;
import org.babyfish.jimmer.sql.event.AssociationListener;
import org.babyfish.jimmer.sql.event.ChangedRef;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.EntityListener;
import org.babyfish.jimmer.sql.event.Triggers;

public class TriggersImpl
implements Triggers {
    private final boolean transaction;
    private final CopyOnWriteArrayList<EntityListener<ImmutableSpi>> globalEntityListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<AssociationListener> globalAssociationListeners = new CopyOnWriteArrayList();
    private final ConcurrentMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>> entityTableListenerMultiMap = new ConcurrentHashMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>>();
    private final ConcurrentMap<ImmutableProp, CopyOnWriteArrayList<AssociationListener>> associationListenerMultiMap = new ConcurrentHashMap<ImmutableProp, CopyOnWriteArrayList<AssociationListener>>();

    public TriggersImpl(boolean transaction) {
        this.transaction = transaction;
    }

    @Override
    public void addEntityListener(EntityListener<?> listener) {
        this.addEntityListener((ImmutableType)null, listener);
    }

    @Override
    public void addEntityListener(ImmutableType immutableType, EntityListener<?> listener) {
        if (listener != null) {
            if (immutableType == null) {
                this.globalEntityListeners.add(listener);
            } else {
                this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).add(listener);
            }
        }
    }

    @Override
    public void removeEntityListener(EntityListener<?> listener) {
        this.removeEntityListener((ImmutableType)null, listener);
    }

    @Override
    public void removeEntityListener(ImmutableType immutableType, EntityListener<?> listener) {
        if (listener != null) {
            if (immutableType == null) {
                this.globalEntityListeners.remove(listener);
            } else {
                this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).remove(listener);
            }
        }
    }

    @Override
    public void addAssociationListener(AssociationListener listener) {
        this.addAssociationListener((ImmutableProp)null, listener);
    }

    @Override
    public void addAssociationListener(ImmutableProp prop, AssociationListener listener) {
        if (prop != null && !prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (listener != null) {
            if (prop == null) {
                this.globalAssociationListeners.add(listener);
            } else {
                this.associationListenerMultiMap.computeIfAbsent(prop, it -> new CopyOnWriteArrayList()).add(listener);
            }
        }
    }

    @Override
    public void removeAssociationListener(AssociationListener listener) {
        this.removeAssociationListener((ImmutableProp)null, listener);
    }

    @Override
    public void removeAssociationListener(ImmutableProp prop, AssociationListener listener) {
        if (prop != null && !prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (listener != null) {
            if (prop == null) {
                this.globalAssociationListeners.remove(listener);
            } else {
                this.associationListenerMultiMap.computeIfAbsent(prop, it -> new CopyOnWriteArrayList()).remove(listener);
            }
        }
    }

    @Override
    public void fireEntityTableChange(Object oldRow, Object newRow, Connection con, Object reason) {
        if (oldRow == null && newRow == null) {
            return;
        }
        if (oldRow != null && !(oldRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldRow must be immutable");
        }
        if (newRow != null && !(newRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newRow must be immutable");
        }
        EntityEvent<ImmutableSpi> event = new EntityEvent<ImmutableSpi>((ImmutableSpi)oldRow, (ImmutableSpi)newRow, con, reason);
        List<EntityListener<ImmutableSpi>> listeners = this.entityListeners(event.getImmutableType());
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            for (EntityListener<ImmutableSpi> listener : listeners) {
                try {
                    listener.onChange(event);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        ImmutableType type = event.getImmutableType();
        for (ImmutableProp prop : type.getProps().values()) {
            ChangedRef changedRef;
            if (!prop.isColumnDefinition() || !prop.isAssociation(TargetLevel.PERSISTENT) || (changedRef = event.getChangedRef(prop)) == null) continue;
            ChangedRef fkRef = changedRef.toIdRef();
            throwable = this.fireForeignKeyChange(prop, event.getId(), fkRef.getOldValue(), fkRef.getNewValue(), con, reason, throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    private Throwable fireForeignKeyChange(ImmutableProp prop, Object childId, Object oldFk, Object newFk, Connection con, Object reason, Throwable throwable) {
        AssociationEvent e;
        ImmutableProp inverseProp = prop.getOpposite();
        List<AssociationListener> listeners = this.associationListeners(prop);
        List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
        if (!listeners.isEmpty()) {
            e = new AssociationEvent(prop, childId, oldFk, newFk, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (!inverseListeners.isEmpty()) {
            if (oldFk != null) {
                e = new AssociationEvent(inverseProp, oldFk, childId, null, con, reason);
                for (AssociationListener inverseListener : inverseListeners) {
                    try {
                        inverseListener.onChange(e);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            }
            if (newFk != null) {
                e = new AssociationEvent(inverseProp, newFk, null, childId, con, reason);
                for (AssociationListener inverseListener : inverseListeners) {
                    try {
                        inverseListener.onChange(e);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            }
        }
        return throwable;
    }

    @Override
    public void fireMiddleTableDelete(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            this.fireMiddleTableDeleteImpl(mappedBy, targetId, sourceId, con, reason);
        } else {
            this.fireMiddleTableDeleteImpl(prop, sourceId, targetId, con, reason);
        }
    }

    private void fireMiddleTableDeleteImpl(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        AssociationEvent e;
        ImmutableProp inverseProp = prop.getOpposite();
        List<AssociationListener> listeners = this.associationListeners(prop);
        List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            e = new AssociationEvent(prop, sourceId, targetId, null, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (!inverseListeners.isEmpty()) {
            e = new AssociationEvent(inverseProp, targetId, sourceId, null, con, reason);
            for (AssociationListener inverseListener : inverseListeners) {
                try {
                    inverseListener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    @Override
    public void fireMiddleTableInsert(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            this.fireMiddleTableInsertImpl(mappedBy, targetId, sourceId, con, reason);
        } else {
            this.fireMiddleTableInsertImpl(prop, sourceId, targetId, con, reason);
        }
    }

    private void fireMiddleTableInsertImpl(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        AssociationEvent e;
        ImmutableProp inverseProp = prop.getOpposite();
        List<AssociationListener> listeners = this.associationListeners(prop);
        List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            e = new AssociationEvent(prop, sourceId, null, targetId, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (!inverseListeners.isEmpty()) {
            e = new AssociationEvent(inverseProp, targetId, null, sourceId, con, reason);
            for (AssociationListener inverseListener : inverseListeners) {
                try {
                    inverseListener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    @Override
    public void fireAssociationEvict(ImmutableProp prop, Object sourceId, Object reason) {
        List<AssociationListener> listeners = this.associationListeners(prop);
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            AssociationEvent e = new AssociationEvent(prop, sourceId, null, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    private List<EntityListener<ImmutableSpi>> entityListeners(ImmutableType type) {
        ArrayList<EntityListener<ImmutableSpi>> listeners = new ArrayList<EntityListener<ImmutableSpi>>(this.globalEntityListeners);
        ConcurrentMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>> map = this.entityTableListenerMultiMap;
        for (ImmutableType t : type.getAllTypes()) {
            CopyOnWriteArrayList list = (CopyOnWriteArrayList)map.get(t);
            if (list == null) continue;
            listeners.addAll(list);
        }
        return listeners;
    }

    private List<AssociationListener> associationListeners(ImmutableProp prop) {
        if (prop == null) {
            return Collections.emptyList();
        }
        ArrayList<AssociationListener> listeners = new ArrayList<AssociationListener>(this.globalAssociationListeners);
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.associationListenerMultiMap.get(prop);
        if (list != null) {
            listeners.addAll(list);
        }
        return listeners;
    }

    @Override
    public boolean isTransaction() {
        return this.transaction;
    }
}

