/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.table.spi;

import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.ViewMetadata;

public abstract class AbstractTypedTable<E>
implements TableProxy<E> {
    private final ImmutableType immutableType;
    protected final TableImplementor<E> raw;
    private final DelayedOperation<E> delayedOperation;
    private final String joinDisabledReason;
    private final Object identifier;

    protected AbstractTypedTable(ImmutableType type) {
        this.immutableType = type;
        this.raw = null;
        this.delayedOperation = null;
        this.joinDisabledReason = null;
        this.identifier = new Object();
    }

    protected AbstractTypedTable(Class<E> entityType) {
        this.immutableType = ImmutableType.get(entityType);
        this.raw = null;
        this.delayedOperation = null;
        this.joinDisabledReason = null;
        this.identifier = new Object();
    }

    protected AbstractTypedTable(Class<E> entityType, DelayedOperation<E> delayedOperation) {
        this.immutableType = ImmutableType.get(entityType);
        this.raw = null;
        this.delayedOperation = delayedOperation;
        this.joinDisabledReason = null;
        this.identifier = new Object();
    }

    protected AbstractTypedTable(TableImplementor<E> raw) {
        this.immutableType = raw.getImmutableType();
        this.raw = raw;
        this.joinDisabledReason = null;
        this.delayedOperation = null;
        this.identifier = new Object();
    }

    protected AbstractTypedTable(AbstractTypedTable<E> base, String joinDisabledReason) {
        this.immutableType = base.immutableType;
        this.raw = base.raw;
        this.delayedOperation = base.delayedOperation;
        this.joinDisabledReason = joinDisabledReason != null ? joinDisabledReason : base.joinDisabledReason;
        this.identifier = base.identifier;
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (this.raw != null) {
            return this.raw.eq(other);
        }
        if (other.getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).eq(other.get(idPropName));
    }

    @Override
    public Predicate eq(Example<E> example) {
        return ((ExampleImpl)example).toPredicate(this);
    }

    @Override
    public Predicate eq(E example) {
        return this.eq((E)Example.of(example));
    }

    @Override
    public Predicate eq(View<E> view) {
        return this.eq((E)Example.of(view));
    }

    @Override
    public Predicate isNull() {
        if (this.raw != null) {
            return this.raw.isNull();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        if (this.raw != null) {
            return this.raw.isNotNull();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        if (this.raw != null) {
            return this.raw.count();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).count();
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        if (this.raw != null) {
            return this.raw.count();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).count();
    }

    @Override
    public <XE extends Expression<?>> XE get(String prop) {
        if (this.raw != null) {
            return this.raw.get(prop);
        }
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        ImmutableProp idViewBaseProp = immutableProp.getIdViewBaseProp();
        if (idViewBaseProp != null && idViewBaseProp.isReference(TargetLevel.ENTITY)) {
            return this.join(idViewBaseProp.getName(), idViewBaseProp.isNullable() ? JoinType.LEFT : JoinType.INNER).get(idViewBaseProp.getTargetType().getIdProp().getName());
        }
        return (XE)PropExpressionImpl.of(this, immutableProp);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), JoinType.INNER, null));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), joinType, null));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop, joinType, treatedAs);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), joinType, treatedAs));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop, JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop.unwrap(), JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop.unwrap(), joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(targetTableType, backPropBlock);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, ImmutableProps.join(targetTableType, backPropBlock), JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(targetTableType, backPropBlock, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, ImmutableProps.join(targetTableType, backPropBlock), joinType));
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this;
        }
        if (this.raw != null) {
            return this.raw.fetch(fetcher);
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public <V extends View<E>> Selection<V> fetch(Class<V> viewType) {
        if (this.raw != null) {
            return this.raw.fetch(viewType);
        }
        ViewMetadata metadata = ViewMetadata.of(viewType);
        return new FetcherSelectionImpl<V>(this, metadata.getFetcher(), metadata.getConverter());
    }

    @Override
    public Table<?> __parent() {
        if (this.raw != null) {
            return this.raw.getParent();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.parent();
        }
        return null;
    }

    @Override
    public ImmutableProp __prop() {
        if (this.raw != null) {
            return this.raw.getJoinProp();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.prop();
        }
        return null;
    }

    @Override
    public boolean __isInverse() {
        return this.delayedOperation instanceof DelayInverseJoin;
    }

    @Override
    public TableImplementor<E> __unwrap() {
        return this.raw;
    }

    @Override
    public TableImplementor<E> __resolve(RootTableResolver resolver) {
        if (this.raw != null) {
            return this.raw;
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.resolve(resolver);
        }
        if (resolver == null) {
            throw new IllegalArgumentException("resolver cannot be null when the table proxy is not wrapper");
        }
        return resolver.resolveRootTable(this);
    }

    protected void __beforeJoin() {
        if (this.joinDisabledReason != null) {
            throw new IllegalStateException("Table join is disabled because " + this.joinDisabledReason);
        }
    }

    public String toString() {
        if (this.raw != null) {
            return this.raw.toString();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.toString();
        }
        return this.immutableType.toString();
    }

    protected <X> DelayedOperation<X> joinOperation(String prop) {
        return new DelayJoin(this, this.immutableType.getProp(prop), JoinType.INNER, null);
    }

    protected <X> DelayedOperation<X> joinOperation(String prop, JoinType joinType) {
        return new DelayJoin(this, this.immutableType.getProp(prop), joinType, null);
    }

    protected <X> DelayedOperation<X> joinOperation(String prop, JoinType joinType, ImmutableType treatedAs) {
        return new DelayJoin(this, this.immutableType.getProp(prop), joinType, treatedAs);
    }

    protected <X> DelayedOperation<X> joinOperation(Class<? extends WeakJoin<?, ?>> weakJoinType, JoinType joinType) {
        return new DelayJoin(this, weakJoinType, joinType);
    }

    public static boolean __refEquals(Table<?> a, Table<?> b) {
        if (a == b) {
            return true;
        }
        if (a instanceof AbstractTypedTable && b instanceof AbstractTypedTable) {
            return ((AbstractTypedTable)a).identifier == ((AbstractTypedTable)b).identifier;
        }
        return false;
    }

    public static interface DelayedOperation<E> {
        public Table<?> parent();

        public ImmutableProp prop();

        public WeakJoinHandle weakJoinHandle();

        public ImmutableType targetType();

        public TableImplementor<E> resolve(RootTableResolver var1);
    }

    private static class DelayJoin<E>
    implements DelayedOperation<E> {
        private final AbstractTypedTable<?> parent;
        private final ImmutableProp prop;
        private final WeakJoinHandle weakJoinHandle;
        private final JoinType joinType;
        private final ImmutableType treatedAs;

        DelayJoin(AbstractTypedTable<?> parent, ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
            this.parent = parent;
            this.joinType = joinType;
            this.treatedAs = treatedAs;
            this.prop = prop;
            this.weakJoinHandle = null;
        }

        private DelayJoin(AbstractTypedTable<?> parent, Class<? extends WeakJoin<?, ?>> weakJoinType, JoinType joinType) {
            this.parent = parent;
            this.joinType = joinType;
            this.treatedAs = null;
            this.prop = null;
            this.weakJoinHandle = WeakJoinHandle.of(weakJoinType);
        }

        @Override
        public Table<?> parent() {
            return this.parent;
        }

        @Override
        public ImmutableProp prop() {
            return this.prop;
        }

        @Override
        public WeakJoinHandle weakJoinHandle() {
            return this.weakJoinHandle;
        }

        @Override
        public ImmutableType targetType() {
            if (this.treatedAs != null) {
                return this.treatedAs;
            }
            if (this.prop != null) {
                return this.prop.getTargetType();
            }
            return this.weakJoinHandle.getTargetType();
        }

        @Override
        public TableImplementor<E> resolve(RootTableResolver ctx) {
            if (this.prop != null) {
                return this.parent.__resolve(ctx).joinImplementor(this.prop.getName(), this.joinType, this.treatedAs);
            }
            return this.parent.__resolve(ctx).weakJoinImplementor(this.weakJoinHandle, this.joinType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayJoin delayJoin = (DelayJoin)o;
            return this.parent.equals(delayJoin.parent) && this.prop.equals((Object)delayJoin.prop) && Objects.equals(this.weakJoinHandle, delayJoin.weakJoinHandle) && this.joinType == delayJoin.joinType;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.prop, this.weakJoinHandle, this.joinType);
        }

        public String toString() {
            return this.prop.toString();
        }
    }

    private static class DelayInverseJoin<E>
    implements DelayedOperation<E> {
        private final AbstractTypedTable<?> parent;
        private final ImmutableProp prop;
        private final JoinType joinType;

        private DelayInverseJoin(AbstractTypedTable<?> parent, ImmutableProp prop, JoinType joinType) {
            this.parent = parent;
            this.prop = prop;
            this.joinType = joinType;
        }

        @Override
        public Table<?> parent() {
            return this.parent;
        }

        @Override
        public ImmutableProp prop() {
            return this.prop;
        }

        @Override
        public WeakJoinHandle weakJoinHandle() {
            return null;
        }

        @Override
        public ImmutableType targetType() {
            return this.prop.getDeclaringType();
        }

        @Override
        public TableImplementor<E> resolve(RootTableResolver ctx) {
            return this.parent.__resolve(ctx).inverseJoinImplementor(this.prop, this.joinType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelayInverseJoin that = (DelayInverseJoin)o;
            return this.parent.equals(that.parent) && this.prop.equals((Object)that.prop) && this.joinType == that.joinType;
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.prop, this.joinType);
        }

        public String toString() {
            ImmutableProp opposite = this.prop.getOpposite();
            if (opposite != null) {
                return opposite.toString();
            }
            return this.parent + "[\u2190 " + this.prop + ']';
        }
    }
}

