/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class DeleteCommandImpl
implements DeleteCommand {
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final ImmutableType immutableType;
    private final Collection<?> ids;
    private final Data data;

    public DeleteCommandImpl(JSqlClientImplementor sqlClient, Connection con, ImmutableType immutableType, Collection<?> ids) {
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : ids) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.immutableType = immutableType;
        this.ids = ids;
        this.data = new Data(sqlClient, DeleteMode.AUTO).freeze();
    }

    public DeleteCommandImpl(DeleteCommandImpl base, Data data) {
        this.sqlClient = base.sqlClient;
        this.con = base.con;
        this.immutableType = base.immutableType;
        this.ids = base.ids;
        this.data = data.freeze();
    }

    @Override
    public DeleteCommand configure(Consumer<DeleteCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (this.data.equals(newData)) {
            return this;
        }
        return new DeleteCommandImpl(this, newData);
    }

    @Override
    public DeleteResult execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public DeleteResult execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private DeleteResult executeImpl(Connection con) {
        boolean binLogOnly = this.sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY;
        Deleter deleter = new Deleter(this.data, con, binLogOnly ? null : new MutationCache(this.sqlClient, false), binLogOnly ? null : new MutationTrigger(), new HashMap<AffectedTable, Integer>());
        deleter.addPreHandleInput(this.immutableType, this.ids);
        return deleter.execute();
    }

    static class Data
    implements DeleteCommand.Cfg {
        private final JSqlClientImplementor sqlClient;
        private DeleteMode mode;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private boolean frozen;

        Data(JSqlClientImplementor sqlClient, DeleteMode deleteMode) {
            this.sqlClient = sqlClient;
            this.mode = deleteMode;
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
        }

        Data(JSqlClientImplementor sqlClient, DeleteMode mode, Map<ImmutableProp, DissociateAction> dissociateActionMap) {
            this.sqlClient = sqlClient;
            this.mode = mode;
            this.dissociateActionMap = dissociateActionMap != null ? new LinkedHashMap<ImmutableProp, DissociateAction>(dissociateActionMap) : new LinkedHashMap<ImmutableProp, DissociateAction>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.mode = base.mode;
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
        }

        public JSqlClientImplementor getSqlClient() {
            return this.sqlClient;
        }

        public DeleteMode getMode() {
            return this.mode;
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        public Data freeze() {
            if (!this.frozen) {
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        @Override
        public DeleteCommand.Cfg setMode(DeleteMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public DeleteCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            if (this.frozen) {
                throw new IllegalStateException("The configuration is frozen");
            }
            if (!prop.isReference(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) {
                throw new IllegalArgumentException("'" + prop + "' must be an entity reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            if (dissociateAction == DissociateAction.SET_NULL && prop.isInputNotNull()) {
                throw new IllegalArgumentException("'" + prop + "' is `inputNotNull` so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data data = (Data)o;
            return this.frozen == data.frozen && this.sqlClient.equals(data.sqlClient) && this.mode == data.mode && this.dissociateActionMap.equals(data.dissociateActionMap);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlClient, this.mode, this.dissociateActionMap, this.frozen});
        }

        public String toString() {
            return "Data{sqlClient=" + this.sqlClient + ", mode=" + (Object)((Object)this.mode) + ", dissociateActionMap=" + this.dissociateActionMap + ", frozen=" + this.frozen + '}';
        }
    }
}

