/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.impl.util.PropCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.runtime.TransientResolverProvider;

class TransientResolverManager {
    private final TransientResolverProvider provider;
    private JSqlClient sqlClient;
    private final PropCache<TransientResolver<?, ?>> resolverCache = new PropCache(this::createResolver, true);

    TransientResolverManager(TransientResolverProvider provider) {
        this.provider = provider;
    }

    void initialize(JSqlClient sqlClient) {
        if (this.sqlClient != null) {
            throw new IllegalStateException("The current object has been initialized");
        }
        this.sqlClient = sqlClient;
        if (this.provider.shouldResolversCreatedImmediately()) {
            this.initializeForTrigger();
        }
    }

    private void initializeForTrigger() {
        Caches caches = this.sqlClient.getCaches();
        if (caches != null) {
            for (ImmutableType type : ((CachesImpl)caches).getObjectCacheMap().keySet()) {
                for (ImmutableProp prop : type.getProps().values()) {
                    if (!prop.hasTransientResolver()) continue;
                    this.get(prop);
                }
            }
            for (ImmutableProp prop : ((CachesImpl)caches).getPropCacheMap().keySet()) {
                if (!prop.hasTransientResolver()) continue;
                this.get(prop);
            }
        }
    }

    public TransientResolver<?, ?> get(ImmutableProp prop) {
        return (TransientResolver)this.resolverCache.get(prop);
    }

    public Class<? extends TransientResolverProvider> getProviderClass() {
        return this.provider.getClass();
    }

    private TransientResolver<?, ?> createResolver(ImmutableProp prop) {
        if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        Transient trans = (Transient)prop.getAnnotation(Transient.class);
        if (trans == null) {
            return null;
        }
        Class<TransientResolver<?, ?>> resolverType = trans.value();
        String resolverRef = trans.ref();
        if (resolverType == Void.TYPE && resolverRef.isEmpty()) {
            return null;
        }
        TransientResolver<?, ?> resolver = null;
        if (!resolverRef.isEmpty()) {
            try {
                resolver = this.provider.get(resolverRef, this.sqlClient);
            }
            catch (Exception ex) {
                throw new ModelException("Illegal property \"" + this + "\", the \"" + this.provider.getClass().getName() + ".get(String)\" throws exception", (Throwable)ex);
            }
            if (resolver == null) {
                throw new ModelException("Illegal property \"" + this + "\", the \"" + this.provider.getClass().getName() + ".get(String)\" returns null");
            }
            resolverType = resolver.getClass();
        }
        if (!TransientResolver.class.isAssignableFrom(resolverType)) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must implement \"" + TransientResolver.class + "\"");
        }
        if (resolverType.isInterface() || (resolverType.getModifiers() & 0x400) != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must be non-abstract class");
        }
        if (resolverType.getTypeParameters().length != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type cannot has parameters");
        }
        Map typeMap = TypeUtils.getTypeArguments(resolverType, TransientResolver.class);
        Type keyType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[0]);
        Type valueType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[1]);
        if (!(keyType instanceof Class) || !Classes.matches((Class)((Class)keyType), (Class)prop.getDeclaringType().getIdProp().getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the first generic type argument of resolver type must be \"" + prop.getDeclaringType().getIdProp().getElementClass() + "\"");
        }
        if (prop.isAssociation(TargetLevel.ENTITY)) {
            ImmutableProp targetIdProp = prop.getTargetType().getIdProp();
            if (prop.isReferenceList(TargetLevel.ENTITY)) {
                ParameterizedType parameterizedType;
                Type valueElementType = null;
                if (valueType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)valueType).getRawType() == List.class && (valueElementType = parameterizedType.getActualTypeArguments()[0]) instanceof WildcardType) {
                    valueElementType = ((WildcardType)valueElementType).getUpperBounds()[0];
                }
                if (!(valueElementType instanceof Class) || !Classes.matches((Class)((Class)valueElementType), (Class)targetIdProp.getElementClass())) {
                    throw new ModelException("Illegal property \"" + prop.getName() + "\", the second generic type argument of resolver type \"" + resolverType.getName() + "\" must be \"" + List.class.getName() + "\" whose element type is \"" + targetIdProp.getElementClass() + "\" which is return type of \"" + targetIdProp + "\"");
                }
            } else if (!(valueType instanceof Class) || !Classes.matches((Class)((Class)valueType), (Class)targetIdProp.getElementClass())) {
                throw new ModelException("Illegal property \"" + prop.getName() + "\", the second generic type argument of resolver type \"" + resolverType.getName() + "\" must be \"" + targetIdProp.getElementClass() + "\" which is return type of \"" + targetIdProp + "\"");
            }
        } else if (!(valueType instanceof Class) || !Classes.matches((Class)((Class)valueType), (Class)prop.getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the second generic type argument of resolver type \"" + resolverType.getName() + "\" must be \"" + prop.getElementClass() + "\"");
        }
        if (resolver != null) {
            return resolver;
        }
        try {
            return this.provider.get(resolverType, this.sqlClient);
        }
        catch (Exception ex) {
            throw TransientResolverManager.convertResolverConstructorError(prop, ex);
        }
    }

    private static RuntimeException convertResolverConstructorError(ImmutableProp prop, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        return new ModelException("Cannot create resolver \"" + ((Transient)prop.getAnnotation(Transient.class)).value() + "\" for property \"" + prop + "\"", throwable);
    }
}

