/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.LiteralExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class ComparisonPredicates {
    public static void renderComparison(ExpressionImplementor<?> left, String op, Object right, SqlBuilder builder) {
        if (right instanceof LiteralExpressionImplementor) {
            right = ((LiteralExpressionImplementor)right).getValue();
        }
        boolean hasTuple = left instanceof TupleExpressionImplementor && (right instanceof TupleExpressionImplementor || right instanceof TupleImplementor);
        boolean hasEmbedded = ComparisonPredicates.hasEmbedded(left);
        if (!hasTuple && !hasEmbedded) {
            ComparisonPredicates.render(left, builder);
            if (right == null && "=".equals(op)) {
                builder.sql(" is null");
            } else if (right == null && "<>".equals(op)) {
                builder.sql(" is not null");
            } else {
                builder.sql(" ").sql(op).sql(" ");
                ComparisonPredicates.render(right, left.getType(), left, builder);
            }
            return;
        }
        if (!"=".equals(op) && !"<>".equals(op)) {
            throw new ExecutionException("The \"" + op + "\" expression does not support tuple or embeddable");
        }
        ArrayList<Item> items = new ArrayList<Item>();
        ItemContext ctx = new ItemContext(builder.getAstContext().getSqlClient(), left, items);
        ctx.visit(right);
        if (items.isEmpty()) {
            throw new ExecutionException("The embedded value has no loaded properties");
        }
        if (builder.getAstContext().getSqlClient().getDialect().isTupleSupported() && !ctx.hasNull()) {
            builder.enter(SqlBuilder.ScopeType.TUPLE);
            for (Item item : items) {
                builder.separator();
                ComparisonPredicates.render(item.left, builder);
            }
            builder.leave();
            builder.sql(" ").sql(op).sql(" ");
            builder.enter(SqlBuilder.ScopeType.TUPLE);
            for (Item item : items) {
                builder.separator();
                ComparisonPredicates.render(item.right, item.left.getType(), item.left, builder);
            }
            builder.leave();
        } else {
            builder.enter(SqlBuilder.ScopeType.AND);
            for (Item item : items) {
                builder.separator();
                ComparisonPredicates.render(item.left, builder);
                if (item.right == null) {
                    builder.sql("=".equals(op) ? " is null" : "is not null");
                    continue;
                }
                builder.sql(" ").sql(op).sql(" ");
                ComparisonPredicates.render(item.right, item.left.getType(), item.left, builder);
            }
            builder.leave();
        }
    }

    public static void renderInCollection(boolean negative, ExpressionImplementor<?> expr, Collection<?> values, SqlBuilder builder) {
        if (values.isEmpty()) {
            builder.sql(negative ? "1 = 1" : "1 = 0");
            return;
        }
        if (values.size() == 1) {
            ComparisonPredicates.renderComparison(expr, negative ? "<>" : "=", values.iterator().next(), builder);
            return;
        }
        boolean hasTuple = expr instanceof TupleExpressionImplementor;
        boolean hasEmbedded = ComparisonPredicates.hasEmbedded(expr);
        if (!hasTuple && !hasEmbedded) {
            ComparisonPredicates.render(expr, builder);
            builder.sql(negative ? " not in " : " in ");
            builder.enter(SqlBuilder.ScopeType.LIST);
            for (Object value : values) {
                builder.separator();
                ComparisonPredicates.render(value, expr.getType(), expr, builder);
            }
            builder.leave();
            return;
        }
        ArrayList<Item> prevItems = null;
        if (builder.getAstContext().getSqlClient().getDialect().isTupleSupported()) {
            builder.enter(SqlBuilder.ScopeType.TUPLE);
            ArrayList<Item> items = new ArrayList<Item>();
            new ItemContext(builder.getAstContext().getSqlClient(), expr, items).visit(values.iterator().next());
            if (items.isEmpty()) {
                throw new ExecutionException("The embedded value has no loaded properties");
            }
            prevItems = items;
            for (Item item : items) {
                builder.separator();
                ComparisonPredicates.render(item.left, builder);
            }
            builder.leave();
            builder.sql(negative ? " not in " : " in ");
            builder.enter(SqlBuilder.ScopeType.LIST);
            for (Object value : values) {
                builder.separator();
                if (items.isEmpty()) {
                    new ItemContext(builder.getAstContext().getSqlClient(), expr, items).visit(value);
                    if (!prevItems.equals(items)) {
                        throw new ExecutionException("The shape of values are not same, previous shape is " + prevItems + ", but the current shape is " + items);
                    }
                }
                builder.enter(SqlBuilder.ScopeType.TUPLE);
                for (Item item : items) {
                    builder.separator();
                    ComparisonPredicates.render(item.right, item.left.getType(), item.left, builder);
                }
                builder.leave();
                items.clear();
            }
            builder.leave();
        } else {
            boolean oneValue;
            boolean bl = oneValue = values.size() == 1;
            if (!oneValue) {
                if (!negative) {
                    builder.sql("(").space('\n');
                }
                builder.enter(negative ? SqlBuilder.ScopeType.AND : SqlBuilder.ScopeType.OR);
            }
            for (Object value : values) {
                builder.separator();
                ArrayList<Item> items = new ArrayList<Item>();
                ItemContext ctx = new ItemContext(builder.getAstContext().getSqlClient(), expr, items);
                ctx.visit(value);
                if (prevItems == null) {
                    if (items.isEmpty()) {
                        throw new ExecutionException("The embedded value has no loaded properties");
                    }
                } else if (!prevItems.equals(items)) {
                    throw new ExecutionException("The shape of values are not same, previous shape is " + prevItems + ", but the current shape is " + items);
                }
                if (!oneValue) {
                    builder.sql("(").space('\n');
                }
                builder.enter(negative ? SqlBuilder.ScopeType.OR : SqlBuilder.ScopeType.AND);
                for (Item item : items) {
                    builder.separator();
                    ComparisonPredicates.render(item.left, builder);
                    builder.sql(negative ? " <> " : " = ");
                    ComparisonPredicates.render(item.right, item.left.getType(), item.left, builder);
                }
                builder.leave();
                if (!oneValue) {
                    builder.space('\n').sql(")");
                }
                prevItems = items;
            }
            if (!oneValue) {
                builder.leave();
                if (!negative) {
                    builder.space('\n').sql(")");
                }
            }
        }
    }

    private static void render(Expression<?> expr, SqlBuilder builder) {
        ((Ast)((Object)expr)).renderTo(builder);
    }

    private static void render(Object value, Class<?> type, Expression<?> matchedExpr, SqlBuilder builder) {
        if (value instanceof Expression) {
            ((Ast)value).renderTo(builder);
        } else if (value != null) {
            JSqlClientImplementor sqlClient = builder.getAstContext().getSqlClient();
            ScalarProvider scalarProvider = null;
            if (matchedExpr instanceof PropExpressionImplementor) {
                scalarProvider = sqlClient.getScalarProvider(((PropExpressionImplementor)matchedExpr).getProp());
            }
            if (scalarProvider == null) {
                scalarProvider = sqlClient.getScalarProvider(type);
            }
            if (scalarProvider != null) {
                try {
                    value = scalarProvider.toSql(value);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Cannot convert the value \"" + value + "\" by the scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                }
            }
            builder.variable(value);
        } else {
            builder.nullVariable(type);
        }
    }

    private static boolean isEmbedded(ExpressionImplementor<?> expr) {
        PropExpressionImplementor propExpr = (PropExpressionImplementor)expr;
        return propExpr.getDeepestProp().isEmbedded(EmbeddedLevel.BOTH);
    }

    private static boolean hasEmbedded(ExpressionImplementor<?> expr) {
        if (expr instanceof TupleExpressionImplementor) {
            TupleExpressionImplementor tupleExpr = (TupleExpressionImplementor)expr;
            for (int i = tupleExpr.size() - 1; i >= 0; --i) {
                Selection<?> selection = tupleExpr.get(i);
                if (!(selection instanceof ExpressionImplementor)) {
                    throw new IllegalArgumentException("The sub item of tuple expression must be expression too");
                }
                if (!ComparisonPredicates.hasEmbedded((ExpressionImplementor)selection)) continue;
                return true;
            }
        } else {
            return ComparisonPredicates.isEmbedded(expr);
        }
        return false;
    }

    private static class ItemContext {
        private static final Object UNLOADED = new Object();
        private final JSqlClientImplementor sqlClient;
        private final MetadataStrategy strategy;
        private final ExpressionImplementor<?> expr;
        private final List<Object> nodes;
        private final ItemContext root;
        private final List<Item> resultItems;
        private boolean hasNull;

        ItemContext(JSqlClientImplementor sqlClient, ExpressionImplementor<?> expr, List<Item> resultItems) {
            this.sqlClient = sqlClient;
            this.strategy = sqlClient.getMetadataStrategy();
            this.expr = expr;
            this.nodes = Collections.emptyList();
            this.root = this;
            this.resultItems = resultItems;
        }

        private ItemContext(ItemContext context, int index) {
            ArrayList<Object> nodes = new ArrayList<Object>(context.nodes.size() + 1);
            nodes.addAll(context.nodes);
            nodes.add(index);
            this.sqlClient = context.sqlClient;
            this.strategy = context.strategy;
            this.expr = ItemContext.item(context.expr, index);
            this.nodes = Collections.singletonList(nodes);
            this.root = context.root;
            this.resultItems = context.resultItems;
        }

        private ItemContext(ItemContext context, List<ImmutableProp> props) {
            ArrayList<Object> nodes = new ArrayList<Object>(context.nodes.size() + 1);
            nodes.addAll(context.nodes);
            nodes.addAll(props);
            this.sqlClient = context.sqlClient;
            this.strategy = context.strategy;
            this.expr = ItemContext.item(context.expr, props);
            this.nodes = nodes;
            this.root = context.root;
            this.resultItems = context.resultItems;
        }

        public boolean hasNull() {
            return this.hasNull;
        }

        public void visit(Object right) {
            if (this.expr instanceof TupleExpressionImplementor) {
                TupleExpressionImplementor tupleExpr = (TupleExpressionImplementor)this.expr;
                int size = tupleExpr.size();
                if (right instanceof TupleExpressionImplementor) {
                    for (int i = 0; i < size; ++i) {
                        new ItemContext(this, i).visit(ItemContext.item(right, i));
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        new ItemContext(this, i).visit(((TupleImplementor)right).get(i));
                    }
                }
            } else if (this.expr instanceof PropExpression.Embedded) {
                Map pathMap = ((PropExpressionImplementor)this.expr).getDeepestProp().getTargetType().getEmbeddedPaths();
                if (right instanceof PropExpression.Embedded) {
                    for (List props : pathMap.values()) {
                        new ItemContext(this, props).visit(ItemContext.item(this.expr, props));
                    }
                } else {
                    for (List props : pathMap.values()) {
                        Object value = ItemContext.itemValue(right, props);
                        if (value == UNLOADED) continue;
                        new ItemContext(this, props).visit(value);
                    }
                }
            } else if (right instanceof Expression) {
                this.resultItems.add(new Item(this.nodes, this.expr, (ExpressionImplementor)right));
            } else {
                this.resultItems.add(new Item(this.nodes, this.expr, right));
                this.root.hasNull = this.root.hasNull | right == null;
            }
        }

        private static ExpressionImplementor<?> item(Object value, int index) {
            Selection<?> selection = ((TupleExpressionImplementor)value).get(index);
            if (!(selection instanceof ExpressionImplementor)) {
                throw new IllegalArgumentException("The tuple used by predicate can only contain sub expressions");
            }
            return (ExpressionImplementor)selection;
        }

        private static ExpressionImplementor<?> item(ExpressionImplementor<?> expr, List<ImmutableProp> props) {
            for (ImmutableProp prop : props) {
                expr = (ExpressionImplementor)((PropExpression.Embedded)((Object)expr)).get(prop);
            }
            return expr;
        }

        private static Object itemValue(Object value, List<ImmutableProp> props) {
            for (ImmutableProp prop : props) {
                if (value == null) {
                    return null;
                }
                ImmutableSpi spi = (ImmutableSpi)value;
                PropId propId = prop.getId();
                if (!spi.__isLoaded(propId)) {
                    return UNLOADED;
                }
                value = spi.__get(propId);
            }
            return value;
        }
    }

    private static class Item {
        final List<Object> nodes;
        final ExpressionImplementor<?> left;
        final Object right;

        private Item(List<Object> nodes, ExpressionImplementor<?> left, Object right) {
            this.nodes = nodes;
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return this.nodes.equals(item.nodes);
        }

        public int hashCode() {
            return this.nodes.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Object o : this.nodes) {
                builder.append('/');
                if (o instanceof ImmutableProp) {
                    builder.append(((ImmutableProp)o).getName());
                    continue;
                }
                builder.append(o);
            }
            return builder.toString();
        }
    }
}

