/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.impl;

import java.sql.Connection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class BackRefIds {
    public static List<?> findBackRefIds(JSqlClientImplementor sqlClient, ImmutableProp backProp, Object id, Connection con) {
        ImmutableType backRefType = backProp.getDeclaringType();
        ImmutableType thisType = backProp.getTargetType();
        ImmutableProp prop = backProp.getMappedBy();
        if (prop != null && prop.isColumnDefinition()) {
            return (List)Queries.createQuery(sqlClient, thisType, ExecutionPurpose.EVICT, FilterLevel.IGNORE_USER_FILTERS, (q, table) -> {
                q.where(new Predicate[]{table.getId().eq(id)});
                q.where(new Predicate[]{table.getAssociatedId(prop).isNotNull()});
                return q.select(table.getAssociatedId(prop));
            }).execute(con);
        }
        return (List)Queries.createQuery(sqlClient, backRefType, ExecutionPurpose.EVICT, FilterLevel.IGNORE_USER_FILTERS, (q, table) -> {
            q.where(new Predicate[]{table.getAssociatedId(backProp).eq(id)});
            return q.select(table.getId());
        }).distinct().execute(con);
    }
}

