/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.table.spi;

import java.util.function.Function;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;

public class UntypedJoinDisabledTableProxy<E>
implements TableProxy<E> {
    private final TableImplementor<E> table;
    private final String joinDisabledReason;

    public UntypedJoinDisabledTableProxy(TableImplementor<E> table, String joinDisabledReason) {
        this.table = table;
        this.joinDisabledReason = "Table join is disabled because " + joinDisabledReason;
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.table.getImmutableType();
    }

    @Override
    public <X> PropExpression<X> get(String prop) {
        return this.table.get(prop);
    }

    @Override
    public <X> PropExpression<X> get(ImmutableProp prop) {
        return this.table.get(prop);
    }

    @Override
    public <X> PropExpression<X> getId() {
        return this.table.getId();
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(ImmutableProp prop) {
        if (!prop.isColumnDefinition()) {
            throw new IllegalStateException(this.joinDisabledReason);
        }
        return this.table.get(prop);
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(String prop) {
        return this.table.get(prop);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <X> PropExpression<X> inverseGetAssociatedId(ImmutableProp prop) {
        ImmutableProp opposite = prop.getOpposite();
        if (opposite == null || !opposite.isColumnDefinition()) {
            throw new IllegalStateException(this.joinDisabledReason);
        }
        return this.table.inverseGetAssociatedId(prop);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        throw new IllegalStateException(this.joinDisabledReason);
    }

    @Override
    public <XT extends Table<?>> Predicate exists(String prop, Function<XT, Predicate> block) {
        return this.table.exists(prop, block);
    }

    @Override
    public <XT extends Table<?>> Predicate exists(ImmutableProp prop, Function<XT, Predicate> block) {
        return this.table.exists(prop, block);
    }

    @Override
    public Predicate eq(Table<E> other) {
        return this.table.eq(other);
    }

    @Override
    public Predicate eq(Example<E> example) {
        return this.table.eq(example);
    }

    @Override
    public Predicate eq(E example) {
        return this.table.eq(example);
    }

    @Override
    public Predicate eq(View<E> view) {
        return this.table.eq(view);
    }

    @Override
    public Predicate isNull() {
        return this.table.isNull();
    }

    @Override
    public Predicate isNotNull() {
        return this.table.isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.table.count();
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        return this.table.count(distinct);
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        return this.table.fetch(fetcher);
    }

    @Override
    public <V extends View<E>> Selection<V> fetch(Class<V> viewType) {
        return this.table.fetch(viewType);
    }

    @Override
    public TableEx<E> asTableEx() {
        return this.table.asTableEx();
    }

    @Override
    public Table<?> __parent() {
        return this.table.getParent();
    }

    @Override
    public ImmutableProp __prop() {
        return this.table.getJoinProp();
    }

    @Override
    public WeakJoinHandle __weakJoinHandle() {
        return this.table.getWeakJoinHandle();
    }

    @Override
    public boolean __isInverse() {
        return this.table.isInverse();
    }

    @Override
    public TableImplementor<E> __unwrap() {
        return this.table;
    }

    @Override
    public TableImplementor<E> __resolve(RootTableResolver resolver) {
        return this.table;
    }

    @Override
    public <P extends TableProxy<E>> P __disableJoin(String reason) {
        return (P)new UntypedJoinDisabledTableProxy<E>(this.table, reason);
    }

    @Override
    public JoinType __currentJoinType() {
        return this.table.getCurrentJoinType();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        return this.table.equals(o);
    }
}

