/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.BetweenPredicate;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparisonPredicate;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.ParameterUtils;
import org.jetbrains.annotations.NotNull;

interface ComparableExpressionImplementor<T extends Comparable<?>>
extends ComparableExpression<T>,
ExpressionImplementor<T> {
    @Override
    @NotNull
    default public Predicate lt(@NotNull Expression<T> other) {
        return new ComparisonPredicate.Lt(this, ParameterUtils.validate("lt", "other", other));
    }

    @Override
    @NotNull
    default public Predicate lt(@NotNull T other) {
        return new ComparisonPredicate.Lt(this, Expression.comparable().value((Comparable)ParameterUtils.validate("lt", "other", other)));
    }

    @Override
    @NotNull
    default public Predicate le(@NotNull Expression<T> other) {
        return new ComparisonPredicate.Le(this, ParameterUtils.validate("le", "other", other));
    }

    @Override
    @NotNull
    default public Predicate le(@NotNull T other) {
        return new ComparisonPredicate.Le(this, Expression.comparable().value((Comparable)ParameterUtils.validate("le", "other", other)));
    }

    @Override
    @NotNull
    default public Predicate gt(@NotNull Expression<T> other) {
        return new ComparisonPredicate.Gt(this, ParameterUtils.validate("gt", "other", other));
    }

    @Override
    @NotNull
    default public Predicate gt(@NotNull T other) {
        return new ComparisonPredicate.Gt(this, Expression.comparable().value((Comparable)ParameterUtils.validate("gt", "other", other)));
    }

    @Override
    @NotNull
    default public Predicate ge(@NotNull Expression<T> other) {
        return new ComparisonPredicate.Ge(this, ParameterUtils.validate("ge", "other", other));
    }

    @Override
    @NotNull
    default public Predicate ge(@NotNull T other) {
        return new ComparisonPredicate.Ge(this, Expression.comparable().value((Comparable)ParameterUtils.validate("ge", "other", other)));
    }

    @Override
    @NotNull
    default public Predicate between(@NotNull Expression<T> min, @NotNull Expression<T> max) {
        return new BetweenPredicate(false, this, ParameterUtils.validate("between", "min", min), ParameterUtils.validate("between", "max", max));
    }

    @Override
    @NotNull
    default public Predicate between(@NotNull T min, @NotNull T max) {
        return new BetweenPredicate(false, this, Literals.any((Comparable)ParameterUtils.validate("between", "min", min)), Literals.any((Comparable)ParameterUtils.validate("between", "max", max)));
    }

    @Override
    @NotNull
    default public Predicate notBetween(@NotNull Expression<T> min, @NotNull Expression<T> max) {
        return new BetweenPredicate(true, this, ParameterUtils.validate("notBetween", "min", min), ParameterUtils.validate("notBetween", "max", max));
    }

    @Override
    @NotNull
    default public Predicate notBetween(@NotNull T min, @NotNull T max) {
        return new BetweenPredicate(true, this, Literals.any((Comparable)ParameterUtils.validate("notBetween", "min", min)), Literals.any((Comparable)ParameterUtils.validate("notBetween", "max", max)));
    }

    @Override
    @NotNull
    default public ComparableExpression<T> coalesce(T defaultValue) {
        return ((CoalesceBuilder.Cmp)this.coalesceBuilder()).or(defaultValue).build();
    }

    @Override
    @NotNull
    default public ComparableExpression<T> coalesce(Expression<T> defaultExpr) {
        return ((CoalesceBuilder.Cmp)((CoalesceBuilder.Cmp)this.coalesceBuilder()).or((Expression)defaultExpr)).build();
    }

    @Override
    default public  @NotNull CoalesceBuilder.Cmp<T> coalesceBuilder() {
        return new CoalesceBuilder.Cmp(this);
    }
}

