/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.DbNull;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;

public class SqlBuilder {
    private final AstContext ctx;
    private final SqlBuilder parent;
    private final SqlFormatter formatter;
    private final StringBuilder builder = new StringBuilder();
    private final List<Object> variables = new ArrayList<Object>();
    private final List<Integer> variablePositions;
    private boolean indentRequired;
    private int childBuilderCount;
    private boolean terminated;
    private Scope scope;

    public SqlBuilder(AstContext ctx) {
        this.ctx = ctx;
        this.parent = null;
        this.formatter = ctx.getSqlClient().getSqlFormatter();
        this.variablePositions = ctx.getSqlClient().getSqlFormatter().isPretty() ? new ArrayList<Integer>() : null;
    }

    private SqlBuilder(SqlBuilder parent) {
        this.ctx = parent.ctx;
        this.parent = parent;
        this.formatter = this.ctx.getSqlClient().getSqlFormatter();
        this.variablePositions = this.ctx.getSqlClient().getSqlFormatter().isPretty() ? new ArrayList<Integer>() : null;
        SqlBuilder p = parent;
        while (p != null) {
            ++p.childBuilderCount;
            p = p.parent;
        }
    }

    public AstContext getAstContext() {
        return this.ctx;
    }

    public SqlBuilder enter(String separator) {
        this.enterImpl(ScopeType.BLANK, separator);
        return this;
    }

    public SqlBuilder enter(ScopeType type) {
        this.enterImpl(type, null);
        return this;
    }

    private void enterImpl(ScopeType type, String separator) {
        boolean ignored;
        Scope oldScope = this.scope;
        boolean bl = ignored = type == ScopeType.TUPLE && oldScope != null && oldScope.type == ScopeType.TUPLE;
        if (!ignored) {
            this.part(type.prefix);
        }
        this.scope = new Scope(oldScope, type, ignored, separator);
    }

    public SqlBuilder separator() {
        Scope scope = this.scope;
        if (scope != null && scope.dirty) {
            boolean forceInLine = false;
            if (scope.type == ScopeType.LIST) {
                boolean bl = forceInLine = ++scope.listSeparatorCount < this.formatter.getListParamCountInLine();
                if (!forceInLine) {
                    scope.listSeparatorCount = 0;
                }
            }
            if (scope.type.isSeparatorIndent) {
                this.part(scope.separator, forceInLine);
            } else {
                --scope.depth;
                this.part(scope.separator, forceInLine);
                ++scope.depth;
            }
            scope.dirty = false;
        }
        return this;
    }

    public SqlBuilder leave() {
        Scope scope = this.scope;
        this.scope = scope.parent;
        if (!scope.ignored) {
            this.part(scope.type.suffix);
        }
        return this;
    }

    private void part(ScopeType.Part part) {
        this.part(part, false);
    }

    private void part(ScopeType.Part part, boolean forceInLine) {
        if (part == null) {
            return;
        }
        this.space(part.before, forceInLine);
        this.preAppend();
        this.builder.append(part.value);
        this.space(part.after, forceInLine);
    }

    public SqlBuilder space(char ch) {
        return this.space(ch, false);
    }

    public SqlBuilder space(char ch, boolean forceInLine) {
        switch (ch) {
            case '?': {
                if (!forceInLine && this.formatter.isPretty()) {
                    this.newLine();
                    break;
                }
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case ' ': {
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case '\n': {
                if (forceInLine || !this.formatter.isPretty()) break;
                this.newLine();
            }
        }
        return this;
    }

    private void preAppend() {
        SqlBuilder parent;
        Scope scope = this.scope;
        if (scope == null && (parent = this.parent) != null) {
            scope = parent.scope;
        }
        if (scope != null) {
            scope.setDirty();
        }
        if (scope == null || !this.indentRequired) {
            this.indentRequired = false;
            return;
        }
        this.indentRequired = false;
        String indent = this.formatter.getIndent();
        for (int i = scope.depth; i > 0; --i) {
            this.builder.append(indent);
        }
    }

    private void newLine() {
        this.builder.append('\n');
        this.indentRequired = true;
    }

    public SqlBuilder definition(String tableAlias, ColumnDefinition definition) {
        return this.definition(tableAlias, definition, null);
    }

    public SqlBuilder definition(String tableAlias, ColumnDefinition definition, Function<Integer, String> asBlock) {
        if (tableAlias == null || tableAlias.isEmpty()) {
            return this.definition(definition);
        }
        this.preAppend();
        if (definition instanceof SingleColumn) {
            this.builder.append(tableAlias).append('.').append(((SingleColumn)definition).getName());
            if (asBlock != null) {
                this.builder.append(" ").append(asBlock.apply(0));
            }
        } else {
            int size = definition.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.builder.append(", ");
                }
                this.builder.append(tableAlias).append('.').append(definition.name(i));
                if (asBlock == null) continue;
                this.builder.append(" ").append(asBlock.apply(i));
            }
        }
        return this;
    }

    public SqlBuilder definition(String tableAlias, ColumnDefinition definition, boolean applyEmbeddedScope) {
        if (applyEmbeddedScope && definition.isEmbedded()) {
            this.enter(ScopeType.TUPLE);
            this.definition(tableAlias, definition);
            this.leave();
        } else {
            this.definition(tableAlias, definition);
        }
        return this;
    }

    public SqlBuilder definition(ColumnDefinition definition) {
        this.preAppend();
        if (definition instanceof SingleColumn) {
            this.builder.append(((SingleColumn)definition).getName());
        } else {
            boolean addComma = false;
            for (String columnName : definition) {
                if (addComma) {
                    this.builder.append(", ");
                } else {
                    addComma = true;
                }
                this.builder.append(columnName);
            }
        }
        return this;
    }

    public SqlBuilder assignment(ImmutableProp prop, Object value) {
        ColumnDefinition definition = (ColumnDefinition)prop.getStorage(this.getAstContext().getSqlClient().getMetadataStrategy());
        this.preAppend();
        if (definition instanceof SingleColumn) {
            this.builder.append(((SingleColumn)definition).getName()).append(" = ");
            if (value != null) {
                this.variable(value);
            } else {
                this.nullVariable(prop.getReturnClass());
            }
        } else {
            ImmutableType type = prop.isEmbedded(EmbeddedLevel.SCALAR) ? prop.getTargetType() : prop.getTargetType().getIdProp().getTargetType();
            List<Class<?>> subTypes = EmbeddableObjects.expandTypes(type);
            Object[] subValues = EmbeddableObjects.expand(type, value);
            int size = definition.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.builder.append(", ");
                }
                this.builder.append(definition.name(i)).append(" = ");
                Object subValue = subValues[i];
                if (subValue != null) {
                    this.variable(subValue);
                    continue;
                }
                this.nullSingeVariable(subTypes.get(i));
            }
        }
        return this;
    }

    public SqlBuilder sql(String sql) {
        this.preAppend();
        this.builder.append(sql);
        return this;
    }

    public SqlBuilder from() {
        this.preAppend();
        this.space('?');
        this.preAppend();
        this.builder.append("from ");
        return this;
    }

    public SqlBuilder join(JoinType joinType) {
        this.preAppend();
        this.space('?');
        this.preAppend();
        this.builder.append(joinType.name().toLowerCase()).append(" join ");
        return this;
    }

    public SqlBuilder on() {
        this.space('?');
        this.preAppend();
        if (this.formatter.isPretty()) {
            this.builder.append(this.formatter.getIndent());
        }
        this.builder.append("on ");
        return this;
    }

    public <T> SqlBuilder variable(Class<T> type, T value) {
        if (value != null) {
            return this.variable(value);
        }
        return this.nullVariable(type);
    }

    public SqlBuilder variable(Object value) {
        this.validate();
        if (value instanceof TupleImplementor) {
            if (value instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).leave();
            } else if (value instanceof Tuple3) {
                Tuple3 tuple = (Tuple3)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).leave();
            } else if (value instanceof Tuple4) {
                Tuple4 tuple = (Tuple4)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).leave();
            } else if (value instanceof Tuple5) {
                Tuple5 tuple = (Tuple5)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).leave();
            } else if (value instanceof Tuple6) {
                Tuple6 tuple = (Tuple6)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).leave();
            } else if (value instanceof Tuple7) {
                Tuple7 tuple = (Tuple7)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).leave();
            } else if (value instanceof Tuple8) {
                Tuple8 tuple = (Tuple8)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).leave();
            } else if (value instanceof Tuple9) {
                Tuple9 tuple = (Tuple9)value;
                this.enter(ScopeType.TUPLE).nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).separator().nonTupleVariable(Objects.requireNonNull(tuple.get_9(), "tuple.get_9 cannot be null")).leave();
            }
        } else {
            this.nonTupleVariable(value);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlBuilder nonTupleVariable(Object value) {
        if (value instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)value;
            ImmutableType type = spi.__type();
            if (type.isEntity()) {
                this.nonTupleVariable(spi.__get(type.getIdProp().getId()));
                return this;
            } else {
                if (!type.isEmbeddable()) throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
                this.embeddedVariable(spi, null);
            }
            return this;
        } else if (value instanceof DbNull) {
            this.preAppend();
            this.builder.append('?');
            this.variables.add(value);
            if (this.variablePositions == null) return this;
            this.variablePositions.add(this.builder.length());
            return this;
        } else {
            Object finalValue;
            ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(value.getClass());
            if (scalarProvider != null) {
                try {
                    finalValue = scalarProvider.toSql(value);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Cannot convert the jvm type \"" + value + "\" to the sql type \"" + scalarProvider.getSqlType() + "\"", ex);
                }
            } else {
                finalValue = value;
            }
            this.preAppend();
            this.builder.append('?');
            this.variables.add(finalValue);
            if (this.variablePositions == null) return this;
            this.variablePositions.add(this.builder.length());
        }
        return this;
    }

    private void embeddedVariable(ImmutableSpi spi, EmbeddedPath parentPath) {
        this.enter(ScopeType.TUPLE);
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            this.separator();
            EmbeddedPath path = new EmbeddedPath(parentPath, prop);
            if (!spi.__isLoaded(prop.getId())) {
                throw new IllegalArgumentException("Embedded object must loaded, the property path \"" + path + "\" is unloaded");
            }
            Object value = spi.__get(prop.getId());
            if (value == null) {
                this.nullVariable(prop);
                continue;
            }
            if (value instanceof ImmutableSpi) {
                this.embeddedVariable((ImmutableSpi)value, path);
                continue;
            }
            this.nonTupleVariable(value);
        }
        this.leave();
    }

    public SqlBuilder nullVariable(ImmutableProp prop) {
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null) {
            return this.nullVariable(prop.getElementClass());
        }
        return this.nullVariable(targetType.getIdProp().getElementClass());
    }

    public SqlBuilder nullVariable(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null) {
            this.nullImmutableVariable(immutableType);
        } else {
            this.nullSingeVariable(type);
        }
        return this;
    }

    private void nullImmutableVariable(ImmutableType type) {
        if (type.isEntity()) {
            ImmutableProp idProp = type.getIdProp();
            if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                this.nullEmbeddedVariable(idProp.getTargetType());
            } else {
                this.nullSingeVariable(idProp.getElementClass());
            }
        } else if (type.isEmbeddable()) {
            this.nullEmbeddedVariable(type);
        } else {
            throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
        }
    }

    private void nullEmbeddedVariable(ImmutableType type) {
        this.validate();
        this.enter(ScopeType.TUPLE);
        for (ImmutableProp prop : type.getProps().values()) {
            ImmutableType targetType = prop.getTargetType();
            if (targetType != null) {
                this.nullEmbeddedVariable(targetType);
                continue;
            }
            this.nullSingeVariable(prop.getElementClass());
        }
        this.leave();
    }

    private void nullSingeVariable(Class<?> type) {
        this.validate();
        ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(type);
        DbNull finalValue = scalarProvider != null ? new DbNull(scalarProvider.getSqlType()) : new DbNull(type);
        this.preAppend();
        this.builder.append('?');
        this.variables.add(finalValue);
        if (this.variablePositions != null) {
            this.variablePositions.add(this.builder.length());
        }
    }

    public SqlBuilder createChildBuilder() {
        return new SqlBuilder(this);
    }

    public Tuple3<String, List<Object>, List<Integer>> build() {
        return this.build(null);
    }

    public Tuple3<String, List<Object>, List<Integer>> build(Function<Tuple3<String, List<Object>, List<Integer>>, Tuple3<String, List<Object>, List<Integer>>> transformer) {
        SqlBuilder p;
        if (this.scope != null) {
            throw new IllegalStateException("Internal bug: Did not leave all scopes");
        }
        this.validate();
        Tuple3<String, List<Object>, List<Integer>> result = new Tuple3<String, List<Object>, List<Integer>>(this.builder.toString(), this.variables, this.variablePositions);
        if (transformer != null) {
            result = transformer.apply(result);
        }
        if ((p = this.parent) != null) {
            this.preAppend();
            if (p.variablePositions != null) {
                int base = p.builder.length();
                for (Integer position : result.get_3()) {
                    p.variablePositions.add(base + position);
                }
            }
            p.builder.append(result.get_1());
            p.variables.addAll((Collection<Object>)result.get_2());
            while (p != null) {
                --p.childBuilderCount;
                p = p.parent;
            }
        }
        this.terminated = true;
        return result;
    }

    private void validate() {
        if (this.childBuilderCount != 0) {
            throw new IllegalStateException("Internal bug: Cannot change sqlbuilder because there are some child builders");
        }
        if (this.terminated) {
            throw new IllegalStateException("Internal bug: Current build has been terminated");
        }
    }

    public static enum ScopeType {
        BLANK(null, null, null),
        SELECT("select?", ",?", null),
        SELECT_DISTINCT("select distinct?", ",?", null),
        SET("?set?", ",?", null),
        WHERE("?where?", "?and?", null),
        ORDER_BY("?order by?", ",?", null),
        GROUP_BY("?group by?", ",?", null),
        HAVING("?having?", "?and?", null),
        SUB_QUERY("(\n", null, "\n)"),
        LIST("(\n", ",?", "\n)"),
        TUPLE("(", ", ", ")"),
        AND(null, "?and?", null, false),
        OR(null, "?or?", null, false),
        VALUES("?values\n", ",?", null);

        final Part prefix;
        final Part separator;
        final Part suffix;
        final boolean isSeparatorIndent;

        private ScopeType(String prefix, String separator, String suffix) {
            this(prefix, separator, suffix, true);
        }

        private ScopeType(String prefix, String separator, String suffix, boolean isSeparatorIndent) {
            this.prefix = ScopeType.partOf(prefix);
            this.separator = ScopeType.partOf(separator);
            this.suffix = ScopeType.partOf(suffix);
            this.isSeparatorIndent = isSeparatorIndent;
        }

        static Part partOf(String value) {
            if (value == null) {
                return null;
            }
            char before = ScopeType.spaceChar(value.charAt(0));
            char after = value.length() > 1 ? ScopeType.spaceChar(value.charAt(value.length() - 1)) : (char)'\u0000';
            return new Part(before, value.substring(before == '\u0000' ? 0 : 1, value.length() - (after == '\u0000' ? 0 : 1)), after);
        }

        private static char spaceChar(char c) {
            return c == ' ' || c == '\n' || c == '?' ? c : (char)'\u0000';
        }

        static class Part {
            final char before;
            final String value;
            final char after;

            Part(char before, String value, char after) {
                this.before = before;
                this.value = value;
                this.after = after;
            }
        }
    }

    private static class Scope {
        final Scope parent;
        final ScopeType type;
        final boolean ignored;
        final ScopeType.Part separator;
        int depth;
        boolean dirty;
        int listSeparatorCount;

        private Scope(Scope parent, ScopeType type, boolean ignored, String separator) {
            this.parent = parent;
            this.type = type;
            this.ignored = ignored;
            this.depth = ignored ? parent.depth : (parent != null ? parent.depth + 1 : 1);
            this.separator = separator != null ? ScopeType.partOf(separator) : type.separator;
        }

        void setDirty() {
            Scope scope = this;
            while (scope != null && !scope.dirty) {
                scope.dirty = true;
                scope = scope.parent;
            }
        }
    }

    private static class EmbeddedPath {
        final EmbeddedPath parent;
        final ImmutableProp prop;

        EmbeddedPath(EmbeddedPath parent, ImmutableProp prop) {
            this.parent = parent;
            this.prop = prop;
        }

        public String toString() {
            if (this.parent == null) {
                return this.prop.getName();
            }
            return this.parent.toString() + '.' + this.prop.getName();
        }
    }
}

