/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.function.Function;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AssociatedPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.ViewMetadata;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.impl.LogicalDeletedFilterProvider;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;

class TableImpl<E>
extends AbstractDataManager<String, TableImplementor<?>>
implements TableImplementor<E> {
    private final AbstractMutableStatementImpl statement;
    private final ImmutableType immutableType;
    private final TableImpl<?> parent;
    private final boolean isInverse;
    private final ImmutableProp joinProp;
    private final WeakJoinHandle weakJoinHandle;
    private JoinType joinType;
    private JoinType currentJoinType;
    private String alias;
    private String middleTableAlias;

    public TableImpl(AbstractMutableStatementImpl statement, ImmutableType immutableType, TableImpl<?> parent, boolean isInverse, ImmutableProp joinProp, WeakJoinHandle weakJoinHandle, JoinType joinType) {
        if (parent != null && immutableType instanceof AssociationType) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent == null != (joinProp == null && weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent != null && joinProp == null == (weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (weakJoinHandle != null && isInverse) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        this.statement = statement;
        this.immutableType = immutableType;
        this.parent = parent;
        this.isInverse = isInverse;
        this.joinProp = joinProp;
        this.weakJoinHandle = weakJoinHandle;
        this.joinType = joinType;
        this.currentJoinType = joinType;
        StatementContext ctx = statement.getContext();
        if (joinProp != null) {
            if (joinProp.isMiddleTableDefinition()) {
                this.middleTableAlias = statement.getContext().allocateTableAlias();
            } else {
                if (joinProp.getSqlTemplate() == null && !joinProp.hasStorage()) {
                    throw new AssertionError((Object)"Internal bug: Join property has not storage");
                }
                this.middleTableAlias = null;
            }
        } else {
            this.middleTableAlias = null;
        }
        this.alias = ctx.allocateTableAlias();
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public AbstractMutableStatementImpl getStatement() {
        return this.statement;
    }

    @Override
    public TableImplementor<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public boolean isRemote() {
        return this.joinProp != null && this.joinProp.isRemote();
    }

    @Override
    public boolean isRawIdAllowed(JSqlClientImplementor sqlClient) {
        ImmutableProp prop = this.joinProp;
        if (prop == null) {
            return false;
        }
        if (this.isInverse && (prop = prop.getOpposite()) == null) {
            return false;
        }
        if (prop.isRemote()) {
            return true;
        }
        if (!prop.isTargetForeignKeyReal(sqlClient.getMetadataStrategy())) {
            return false;
        }
        Filter<Props> filter = sqlClient.getFilters().getFilter(prop.getTargetType());
        return filter == null || filter instanceof LogicalDeletedFilterProvider.IgnoredFilter;
    }

    @Override
    public ImmutableProp getJoinProp() {
        return this.joinProp;
    }

    @Override
    public WeakJoinHandle getWeakJoinHandle() {
        return this.weakJoinHandle;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public JoinType getCurrentJoinType() {
        return this.currentJoinType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (other.getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        ImmutableProp idProp = this.immutableType.getIdProp();
        return this.get(idProp).eq((Object)other.get(idProp));
    }

    @Override
    public Predicate eq(Example<E> example) {
        return ((ExampleImpl)example).toPredicate(this);
    }

    @Override
    public Predicate eq(E example) {
        return this.eq((E)Example.of(example));
    }

    @Override
    public Predicate eq(View<E> view) {
        return this.eq((E)Example.of(view));
    }

    @Override
    public Predicate isNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        if (this.immutableType instanceof AssociationType) {
            return this.get(((AssociationType)this.immutableType).getSourceProp().getName()).count();
        }
        return this.get(this.immutableType.getIdProp().getName()).count(distinct);
    }

    @Override
    public <X> PropExpression<X> get(String prop) {
        return this.get(this.immutableType.getProp(prop));
    }

    @Override
    public <X> PropExpression<X> get(ImmutableProp prop) {
        return this.get(prop, false);
    }

    @Override
    public <X> PropExpression<X> get(ImmutableProp prop, boolean rawId) {
        ImmutableProp idViewBaseProp;
        if (this.isRemote() && this.immutableType.getIdProp() != prop) {
            throw new IllegalArgumentException("The current table is remote so that only the id property \"" + this.immutableType.getIdProp() + "\" can be accessed");
        }
        if (prop.getDeclaringType() != this.immutableType) {
            if (!prop.getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current type \"" + this.immutableType + "\"");
            }
            prop = this.immutableType.getProp(prop.getName());
        }
        if ((idViewBaseProp = prop.getIdViewBaseProp()) != null && idViewBaseProp.isReference(TargetLevel.ENTITY)) {
            return this.joinImplementor(idViewBaseProp.getName(), idViewBaseProp.isNullable() ? JoinType.LEFT : JoinType.INNER).get(idViewBaseProp.getTargetType().getIdProp(), true);
        }
        return PropExpressionImpl.of(this, prop, rawId);
    }

    @Override
    public <X> PropExpression<X> getId() {
        return this.get(this.immutableType.getIdProp());
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return this.getAssociatedId(immutableProp);
    }

    @Override
    public <X> PropExpression<X> getAssociatedId(ImmutableProp prop) {
        TableImplementor<X> joinedTable = this.joinImplementor(prop, prop.isNullable() ? JoinType.LEFT : JoinType.INNER);
        return joinedTable.get(joinedTable.getImmutableType().getIdProp(), true);
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT join(ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType, treatedAs));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType, treatedAs));
    }

    @Override
    public <X> PropExpression<X> inverseGetAssociatedId(ImmutableProp prop) {
        ImmutableProp oppositeProp = prop.getOpposite();
        TableImplementor<X> joinedTable = this.inverseJoinImplementor(prop, oppositeProp != null && oppositeProp.isNullable() ? JoinType.LEFT : JoinType.INNER);
        return joinedTable.get(joinedTable.getImmutableType().getIdProp(), true);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock), joinType);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop) {
        return this.joinImplementor(this.immutableType.getProp(prop), JoinType.INNER, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop) {
        return this.joinImplementor(prop, JoinType.INNER, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType) {
        return this.joinImplementor(this.immutableType.getProp(prop), joinType, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop, JoinType joinType) {
        return this.joinImplementor(prop, joinType, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType, ImmutableType treatedAs) {
        return this.joinImplementor(this.immutableType.getProp(prop), joinType, treatedAs);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
        ImmutableProp manyToManyViewProp;
        if (prop.getDeclaringType() != this.immutableType) {
            if (!prop.getDeclaringType().isAssignableFrom(this.immutableType)) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current type \"" + this.immutableType + "\"");
            }
            prop = this.immutableType.getProp(prop.getName());
        }
        if ((manyToManyViewProp = prop.getManyToManyViewBaseProp()) != null) {
            return ((TableImpl)this.join0(false, manyToManyViewProp, joinType)).join0(false, prop.getManyToManyViewBaseDeeperProp(), joinType);
        }
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            if (this.isRemote()) {
                throw new IllegalStateException("The current table is remote so that join is not supported");
            }
            if (prop.isTransient()) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be transient");
            }
            if (prop.isRemote() && prop.getMappedBy() != null) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be remote and reversed(with `mappedBy`)");
            }
            throw new IllegalArgumentException("\"" + prop + "\" is not association property of \"" + this.immutableType + "\"");
        }
        return this.join0(false, prop, joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp prop) {
        return this.inverseJoinImplementor(prop, JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop) {
        return this.inverseJoinImplementor(prop.unwrap(), JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return this.inverseJoinImplementor(prop.unwrap(), joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp backProp, JoinType joinType) {
        if (backProp.getTargetType() != this.immutableType) {
            throw new IllegalArgumentException("'" + backProp + "' is not back association property");
        }
        if (!backProp.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("'" + backProp + "' is not declared in entity");
        }
        return this.join0(true, backProp, joinType);
    }

    private TableImplementor<?> join0(boolean isInverse, ImmutableProp prop, JoinType joinType) {
        if (prop.isTransient()) {
            throw new ExecutionException("Cannot join to '" + prop.getName() + "' because it's transient association");
        }
        if (isInverse && prop instanceof AssociationProp) {
            throw new ExecutionException("Cannot join to '" + prop + "' by inverse mode because it's property of association entity");
        }
        String joinName = !isInverse ? prop.getName() : (prop.getOpposite() != null ? prop.getOpposite().getName() : "inverse(" + prop + ")");
        if (prop.getMappedBy() != null) {
            return this.join1(joinName, !isInverse, prop.getMappedBy(), joinType);
        }
        return this.join1(joinName, isInverse, prop, joinType);
    }

    private TableImplementor<?> join1(String joinName, boolean isInverse, ImmutableProp prop, JoinType joinType) {
        TableImpl existing = (TableImpl)this.getValue(joinName);
        if (existing != null) {
            if (existing.joinType != joinType) {
                existing.joinType = JoinType.INNER;
            }
            existing.currentJoinType = joinType;
            return existing;
        }
        TableImpl<E> newTable = new TableImpl<E>(this.statement, isInverse ? prop.getDeclaringType() : prop.getTargetType(), this, isInverse, prop, null, joinType);
        this.putValue(joinName, newTable);
        return newTable;
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(Class<? extends WeakJoin<?, ?>> weakJoinType, JoinType joinType) {
        return this.weakJoinImplementor(WeakJoinHandle.of(weakJoinType), joinType);
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(WeakJoinHandle handle, JoinType joinType) {
        String joinName = "weak(" + handle.getWeakJoinType().getName() + ")";
        TableImpl existing = (TableImpl)this.getValue(joinName);
        if (existing != null) {
            if (existing.joinType != joinType) {
                existing.joinType = JoinType.INNER;
            }
            existing.currentJoinType = joinType;
            return existing;
        }
        TableImpl<E> newTable = new TableImpl<E>(this.statement, handle.getTargetType(), this, this.isInverse, null, handle, joinType);
        this.putValue(joinName, newTable);
        return newTable;
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this;
        }
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, the entity type of current table is \"" + this + "\" but the fetcher type is \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public <V extends View<E>> Selection<V> fetch(Class<V> viewType) {
        if (viewType == null) {
            throw new IllegalArgumentException("The argument `staticType` cannot be null");
        }
        ViewMetadata metadata = ViewMetadata.of(viewType);
        Fetcher fetcher = metadata.getFetcher();
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, the entity type of current table is \"" + this + "\" but the static type is based on \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<V>(this, fetcher, metadata.getConverter());
    }

    @Override
    public TableEx<E> asTableEx() {
        return (TableEx)TableProxies.wrap(this);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitTableReference(this, null, false);
    }

    @Override
    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (this.parent == null) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom can only be called base on joined tables");
        }
        if (mode == TableImplementor.RenderMode.NORMAL) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom does not accept render mode ALL");
        }
        TableUsedState usedState = builder.getAstContext().getTableUsedState(this);
        if (usedState != TableUsedState.NONE) {
            builder.separator();
            this.renderSelf(builder, mode);
            if (mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY) {
                for (TableImplementor childTable : this) {
                    childTable.renderTo(builder);
                }
            }
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        TableUsedState usedState = builder.getAstContext().getTableUsedState(this);
        if (this.parent == null || usedState != TableUsedState.NONE) {
            this.renderSelf(builder, TableImplementor.RenderMode.NORMAL);
            for (TableImplementor childTable : this) {
                childTable.renderTo(builder);
            }
        }
    }

    private void renderSelf(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        if (this.isInverse) {
            this.renderInverseJoin(sqlBuilder, mode);
        } else if (this.joinProp != null || this.weakJoinHandle != null) {
            this.renderJoin(sqlBuilder, mode);
        } else {
            sqlBuilder.from().sql(this.immutableType.getTableName(sqlBuilder.getAstContext().getSqlClient().getMetadataStrategy())).sql(" ").sql(this.alias);
        }
    }

    private void renderJoin(SqlBuilder builder, TableImplementor.RenderMode mode) {
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        if (this.weakJoinHandle != null) {
            if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
                Predicate predicate = this.weakJoinHandle.createPredicate(this.parent, this);
                builder.join(this.joinType).sql(this.immutableType.getTableName(strategy)).sql(" ").sql(this.alias).on();
                if (predicate == null) {
                    builder.sql("1 = 1");
                } else {
                    ((Ast)((Object)predicate)).renderTo(builder);
                }
            }
            return;
        }
        if (this.joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(builder, (JoinTemplate)this.joinProp.getSqlTemplate(), mode);
            return;
        }
        if (this.joinProp instanceof AssociationProp) {
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
                this.renderJoinImpl(builder, this.joinType, this.parent.alias, (ColumnDefinition)this.joinProp.getStorage(strategy), this.immutableType.getTableName(strategy), this.alias, (ColumnDefinition)this.immutableType.getIdProp().getStorage(strategy), mode);
            }
            return;
        }
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        MiddleTable middleTable = null;
        if (this.joinProp.isMiddleTableDefinition()) {
            middleTable = (MiddleTable)this.joinProp.getStorage(strategy);
        }
        if (middleTable != null) {
            this.renderJoinImpl(builder, joinType, parent.alias, (ColumnDefinition)parent.immutableType.getIdProp().getStorage(strategy), middleTable.getTableName(), this.middleTableAlias, middleTable.getColumnDefinition(), mode);
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(builder, joinType, this.middleTableAlias, middleTable.getTargetColumnDefinition(), this.immutableType.getTableName(strategy), this.alias, (ColumnDefinition)this.immutableType.getIdProp().getStorage(strategy), TableImplementor.RenderMode.NORMAL);
            }
        } else if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
            this.renderJoinImpl(builder, joinType, parent.alias, (ColumnDefinition)this.joinProp.getStorage(strategy), this.immutableType.getTableName(strategy), this.alias, (ColumnDefinition)this.immutableType.getIdProp().getStorage(strategy), mode);
        }
    }

    private void renderInverseJoin(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        MetadataStrategy strategy = sqlBuilder.getAstContext().getSqlClient().getMetadataStrategy();
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        if (this.joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(sqlBuilder, (JoinTemplate)this.joinProp.getSqlTemplate(), mode);
            return;
        }
        MiddleTable middleTable = null;
        if (this.joinProp.isMiddleTableDefinition()) {
            middleTable = (MiddleTable)this.joinProp.getStorage(strategy);
        }
        if (middleTable != null) {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, (ColumnDefinition)parent.immutableType.getIdProp().getStorage(strategy), middleTable.getTableName(), this.middleTableAlias, middleTable.getTargetColumnDefinition(), mode);
            if (sqlBuilder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(sqlBuilder, joinType, this.middleTableAlias, middleTable.getColumnDefinition(), this.immutableType.getTableName(strategy), this.alias, (ColumnDefinition)this.immutableType.getIdProp().getStorage(strategy), TableImplementor.RenderMode.NORMAL);
            }
        } else {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, (ColumnDefinition)parent.immutableType.getIdProp().getStorage(strategy), this.immutableType.getTableName(strategy), this.alias, (ColumnDefinition)this.joinProp.getStorage(strategy), mode);
        }
    }

    private void renderJoinBySql(SqlBuilder builder, JoinTemplate joinTemplate, TableImplementor.RenderMode mode) {
        if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
            MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
            switch (mode) {
                case NORMAL: {
                    builder.join(this.joinType).sql(this.immutableType.getTableName(strategy)).sql(" ").sql(this.alias).on();
                    break;
                }
                case FROM_ONLY: {
                    builder.sql(this.immutableType.getTableName(strategy)).sql(" ").sql(this.alias);
                }
            }
            if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
                if (this.isInverse) {
                    builder.sql(joinTemplate.toSql(this.alias, this.parent.alias));
                } else {
                    builder.sql(joinTemplate.toSql(this.parent.alias, this.alias));
                }
            }
        }
    }

    private void renderJoinImpl(SqlBuilder builder, JoinType joinType, String previousAlias, ColumnDefinition previousDefinition, String newTableName, String newAlias, ColumnDefinition newDefinition, TableImplementor.RenderMode mode) {
        if (mode != TableImplementor.RenderMode.NORMAL && joinType != JoinType.INNER) {
            throw new AssertionError((Object)"Internal bug: outer join cannot be accepted by abnormal render mode");
        }
        switch (mode) {
            case NORMAL: {
                builder.join(joinType).sql(newTableName).sql(" ").sql(newAlias).on();
                break;
            }
            case FROM_ONLY: {
                builder.sql(newTableName).sql(" ").sql(newAlias);
            }
        }
        if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
            int size = previousDefinition.size();
            builder.enter(SqlBuilder.ScopeType.AND);
            for (int i = 0; i < size; ++i) {
                builder.separator();
                builder.sql(previousAlias).sql(".").sql(previousDefinition.name(i)).sql(" = ").sql(newAlias).sql(".").sql(newDefinition.name(i));
            }
            builder.leave();
        }
    }

    @Override
    public void renderSelection(ImmutableProp prop, boolean rawId, SqlBuilder builder, ColumnDefinition optionalDefinition, boolean withPrefix, Function<Integer, String> asBlock) {
        SqlTemplate template;
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        if (prop.isId() && this.joinProp != null && !(this.joinProp.getSqlTemplate() instanceof JoinTemplate) && (rawId || this.isRawIdAllowed(builder.getAstContext().getSqlClient()))) {
            MiddleTable middleTable = this.joinProp.isMiddleTableDefinition() ? (MiddleTable)this.joinProp.getStorage(strategy) : null;
            boolean isInverse = this.isInverse;
            if (middleTable != null) {
                if (optionalDefinition == null) {
                    if (isInverse) {
                        builder.definition(withPrefix ? this.middleTableAlias : null, middleTable.getColumnDefinition(), asBlock);
                    } else {
                        builder.definition(withPrefix ? this.middleTableAlias : null, middleTable.getTargetColumnDefinition(), asBlock);
                    }
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)prop.getStorage(strategy);
                    ColumnDefinition parentDefinition = isInverse ? middleTable.getColumnDefinition() : middleTable.getTargetColumnDefinition();
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            builder.sql(this.middleTableAlias).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        builder.sql(" ").sql(asBlock.apply(i));
                    }
                }
                return;
            }
            if (!isInverse) {
                if (optionalDefinition == null) {
                    builder.definition(withPrefix ? this.parent.alias : null, (ColumnDefinition)this.joinProp.getStorage(strategy), asBlock);
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)prop.getStorage(strategy);
                    ColumnDefinition parentDefinition = (ColumnDefinition)this.joinProp.getStorage(strategy);
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            builder.sql(this.parent.alias).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        builder.sql(" ").sql(asBlock.apply(i));
                    }
                }
                return;
            }
        }
        if ((template = prop.getSqlTemplate()) instanceof FormulaTemplate) {
            builder.sql(((FormulaTemplate)template).toSql(this.alias));
            if (asBlock != null) {
                builder.sql(" ").sql(asBlock.apply(0));
            }
        } else {
            ColumnDefinition definition = optionalDefinition != null ? optionalDefinition : (ColumnDefinition)prop.getStorage(strategy);
            builder.definition(withPrefix ? this.alias : null, definition, asBlock);
        }
    }

    public String toString() {
        String text;
        if (this.joinProp == null) {
            text = this.immutableType.getJavaClass().getSimpleName();
        } else if (this.isInverse) {
            ImmutableProp opposite = this.joinProp.getOpposite();
            text = opposite != null ? this.parent.toString() + '.' + opposite.getName() : this.parent + "[\u2190 " + this.joinProp + ']';
        } else {
            return this.parent.toString() + '.' + this.joinProp.getName();
        }
        if (this.joinType == JoinType.INNER) {
            return text;
        }
        return text + '(' + this.joinType.name().toLowerCase() + ')';
    }

    @Override
    public TableRowCountDestructive getDestructive() {
        ImmutableProp prop;
        if (this.joinProp == null) {
            return TableRowCountDestructive.NONE;
        }
        if (this.isInverse) {
            prop = this.joinProp.getOpposite();
            if (prop == null) {
                return TableRowCountDestructive.BREAK_REPEATABILITY;
            }
        } else {
            prop = this.joinProp;
        }
        if (prop.isReferenceList(TargetLevel.PERSISTENT)) {
            return TableRowCountDestructive.BREAK_REPEATABILITY;
        }
        if (prop.isNullable() && this.joinType != JoinType.LEFT) {
            return TableRowCountDestructive.BREAK_ROW_COUNT;
        }
        return TableRowCountDestructive.NONE;
    }

    @Override
    public <XT extends Table<?>> Predicate exists(String prop, Function<XT, Predicate> block) {
        ImmutableProp joinProp = (ImmutableProp)this.immutableType.getProps().get(prop);
        if (joinProp == null) {
            throw new IllegalArgumentException("Illegal property name \"" + prop + "\", there is no such property \"" + this.immutableType + "\"");
        }
        return this.exists(joinProp, block);
    }

    @Override
    public <XT extends Table<?>> Predicate exists(ImmutableProp prop, Function<XT, Predicate> block) {
        return new AssociatedPredicate(this, prop, block);
    }

    @Override
    public boolean hasVirtualPredicate() {
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        return this;
    }
}

