/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;

public class JoinUtils {
    private JoinUtils() {
    }

    public static boolean hasLeftJoin(Table<?> table) {
        while (table != null) {
            JoinType currentJoinType;
            ImmutableProp prop;
            if (table instanceof TableProxy) {
                TableProxy proxy = (TableProxy)table;
                prop = proxy.__prop();
                if (proxy.__isInverse()) {
                    prop = prop.getOpposite();
                }
                if (prop != null && prop.isNullable() && ((currentJoinType = proxy.__currentJoinType()) == JoinType.LEFT || currentJoinType == JoinType.FULL)) {
                    return true;
                }
                table = proxy.__parent();
                continue;
            }
            TableImplementor impl = (TableImplementor)table;
            prop = impl.getJoinProp();
            if (impl.isInverse()) {
                prop = prop.getOpposite();
            }
            if (prop != null && prop.isNullable() && ((currentJoinType = impl.getCurrentJoinType()) == JoinType.LEFT || currentJoinType == JoinType.FULL)) {
                return true;
            }
            table = impl.getParent();
        }
        return false;
    }
}

