/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Collection;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AggregationExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparisonPredicate;
import org.babyfish.jimmer.sql.ast.impl.InCollectionPredicate;
import org.babyfish.jimmer.sql.ast.impl.InSubQueryPredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NullExpression;
import org.babyfish.jimmer.sql.ast.impl.NullityPredicate;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExpressionImplementor<T>
extends Expression<T> {
    public Class<T> getType();

    public int precedence();

    @Override
    @NotNull
    default public Predicate eq(@NotNull Expression<T> other) {
        if (other instanceof NullExpression) {
            return this.isNull();
        }
        if (this instanceof NullExpression) {
            return other.isNull();
        }
        return new ComparisonPredicate.Eq(this, other);
    }

    @Override
    @NotNull
    default public Predicate eq(@Nullable T other) {
        if (other == null) {
            return this.isNull();
        }
        return this.eq((T)Literals.any(other));
    }

    @Override
    @NotNull
    default public Predicate ne(@NotNull Expression<T> other) {
        if (other instanceof NullExpression) {
            return this.isNotNull();
        }
        if (this instanceof NullExpression) {
            return other.isNotNull();
        }
        return new ComparisonPredicate.Ne(this, other);
    }

    @Override
    @NotNull
    default public Predicate ne(@Nullable T other) {
        if (other == null) {
            return this.isNotNull();
        }
        return this.ne((T)Literals.any(other));
    }

    @Override
    @NotNull
    default public Predicate isNull() {
        return new NullityPredicate(this, false);
    }

    @Override
    @NotNull
    default public Predicate isNotNull() {
        return new NullityPredicate(this, true);
    }

    @Override
    @NotNull
    default public Predicate in(@NotNull Collection<T> values) {
        return new InCollectionPredicate(this, values, false);
    }

    @Override
    @NotNull
    default public Predicate notIn(@NotNull Collection<T> values) {
        return new InCollectionPredicate(this, values, true);
    }

    @Override
    @NotNull
    default public Predicate in(@NotNull TypedSubQuery<T> subQuery) {
        return new InSubQueryPredicate(this, subQuery, false);
    }

    @Override
    @NotNull
    default public Predicate notIn(@NotNull TypedSubQuery<T> subQuery) {
        return new InSubQueryPredicate(this, subQuery, true);
    }

    @Override
    @NotNull
    default public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    @NotNull
    default public NumericExpression<Long> count(boolean distinct) {
        if (distinct) {
            return new AggregationExpression.CountDistinct(this);
        }
        return new AggregationExpression.Count(this);
    }

    @Override
    @NotNull
    default public Expression<T> coalesce(T defaultValue) {
        return this.coalesceBuilder().or(defaultValue).build();
    }

    @Override
    @NotNull
    default public Expression<T> coalesce(Expression<T> defaultExpr) {
        return this.coalesceBuilder().or(defaultExpr).build();
    }

    @Override
    @NotNull
    default public CoalesceBuilder<T> coalesceBuilder() {
        return new CoalesceBuilder(this);
    }

    @Override
    @NotNull
    default public Order asc() {
        return new Order(this, OrderMode.ASC, NullOrderMode.UNSPECIFIED);
    }

    @Override
    @NotNull
    default public Order desc() {
        return new Order(this, OrderMode.DESC, NullOrderMode.UNSPECIFIED);
    }
}

