/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.PredicateImplementor;
import org.babyfish.jimmer.sql.ast.impl.PredicateWrapper;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicate;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicateMergedResult;
import org.babyfish.jimmer.sql.ast.impl.query.MutableStatementImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractIdentityDataManager;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTypedTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.TableUsedState;

public class AstContext
extends AbstractIdentityDataManager<TableImplementor<?>, TableUsedState>
implements RootTableResolver {
    private final JSqlClientImplementor sqlClient;
    private StatementFrame statementFrame;
    private int modCount;

    public AstContext(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    @Override
    protected TableUsedState createValue(TableImplementor<?> key) {
        return TableUsedState.ID_ONLY;
    }

    public void useTableId(TableImplementor<?> tableImplementor) {
        this.getOrCreateValue(tableImplementor);
    }

    public void useTable(TableImplementor<?> tableImplementor) {
        this.putValue(tableImplementor, TableUsedState.USED);
    }

    public TableUsedState getTableUsedState(TableImplementor<?> tableImplementor) {
        TableUsedState state = (TableUsedState)((Object)this.getValue(tableImplementor));
        return state != null ? state : TableUsedState.NONE;
    }

    public void pushStatement(AbstractMutableStatementImpl statement) {
        StatementFrame frame = this.statementFrame;
        this.statementFrame = new StatementFrame(statement, frame);
    }

    public void popStatement() {
        this.statementFrame = this.statementFrame.parent;
    }

    @Override
    public <E> TableImplementor<E> resolveRootTable(Table<E> table) {
        if (table instanceof TableImplementor) {
            return (TableImplementor)table;
        }
        TableImplementor tableImplementor = ((TableProxy)table).__unwrap();
        if (tableImplementor != null) {
            return tableImplementor;
        }
        StatementFrame frame = this.statementFrame;
        while (frame != null) {
            AbstractMutableStatementImpl statement = frame.statement;
            Object stmtTable = statement.getTable();
            if (AbstractTypedTable.__refEquals(stmtTable, table)) {
                return statement.getTableImplementor();
            }
            frame = frame.parent;
        }
        if (((TableProxy)table).__parent() != null) {
            throw new IllegalArgumentException("\"" + AstContext.class.getName() + ".resolveRootTable\" only does not accept non-root table, you can use \"" + TableProxies.class.getName() + ".resolve\"");
        }
        throw new IllegalArgumentException("Cannot resolve the root table " + table);
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.statementFrame.statement;
    }

    public void pushVirtualPredicateContext(VirtualPredicate.Op op) {
        this.statementFrame.pushVpf(op);
    }

    public void popVirtualPredicateContext() {
        this.statementFrame.popVpf();
    }

    public <T> T resolveVirtualPredicate(T expression) {
        if (expression == null) {
            return null;
        }
        T unwrapped = AstContext.unwrap(expression);
        if (unwrapped instanceof VirtualPredicate) {
            return (T)this.statementFrame.peekVpf().add((VirtualPredicate)unwrapped);
        }
        if (expression instanceof Ast && ((Ast)expression).hasVirtualPredicate()) {
            return (T)((Ast)expression).resolveVirtualPredicate(this);
        }
        if (expression instanceof MutableStatementImplementor && ((MutableStatementImplementor)expression).hasVirtualPredicate()) {
            ((MutableStatementImplementor)expression).resolveVirtualPredicate(this);
            return expression;
        }
        return expression;
    }

    public <T> List<T> resolveVirtualPredicates(List<T> expressions) {
        boolean changed = false;
        for (T expression : expressions) {
            if (!(expression instanceof Ast) || !((Ast)expression).hasVirtualPredicate()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return expressions;
        }
        VirtualPredicateFrame vpf = this.statementFrame.peekVpf();
        ArrayList<T> newExpressions = new ArrayList<T>(expressions.size());
        for (T expression : expressions) {
            T newExpression = this.resolveVirtualPredicate(expression);
            if (newExpression == null) continue;
            newExpressions.add(newExpression);
        }
        return newExpressions;
    }

    public Predicate[] resolveVirtualPredicates(Predicate[] predicates) {
        boolean changed = false;
        for (Predicate predicate : predicates) {
            if (!((Ast)((Object)predicate)).hasVirtualPredicate()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return predicates;
        }
        VirtualPredicateFrame vpf = this.statementFrame.peekVpf();
        ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(predicates.length);
        for (Predicate predicate : predicates) {
            Predicate newPredicate = this.resolveVirtualPredicate(predicate);
            if (newPredicate == null) continue;
            newPredicates.add(newPredicate);
        }
        return newPredicates.toArray(PredicateImplementor.EMPTY_PREDICATES);
    }

    public int modCount() {
        return this.modCount;
    }

    private static <T> T unwrap(T o) {
        while (o instanceof PredicateWrapper) {
            o = ((PredicateWrapper)o).unwrap();
        }
        return o;
    }

    private class StatementFrame {
        final AbstractMutableStatementImpl statement;
        final StatementFrame parent;
        private VirtualPredicateFrame vpFrame;

        private StatementFrame(AbstractMutableStatementImpl statement, StatementFrame parent) {
            this.statement = statement;
            this.parent = parent;
        }

        public VirtualPredicateFrame peekVpf() {
            VirtualPredicateFrame vpFrame = this.vpFrame;
            if (vpFrame == null) {
                this.vpFrame = vpFrame = new VirtualPredicateFrame(VirtualPredicate.Op.AND, null);
            }
            return vpFrame;
        }

        public void pushVpf(VirtualPredicate.Op op) {
            this.vpFrame = new VirtualPredicateFrame(op, this.peekVpf());
        }

        public void popVpf() {
            this.vpFrame = this.vpFrame.parent;
        }
    }

    private class VirtualPredicateFrame
    extends AbstractDataManager<VirtualPredicate, VirtualPredicateMergedResult> {
        private final VirtualPredicate.Op op;
        private final VirtualPredicateFrame parent;

        private VirtualPredicateFrame(VirtualPredicate.Op op, VirtualPredicateFrame parent) {
            this.op = op;
            this.parent = parent;
        }

        @Override
        protected int hashCode(VirtualPredicate key) {
            return System.identityHashCode(key.getTableImplementor(AstContext.this)) ^ key.getSubKey().hashCode();
        }

        @Override
        protected boolean equals(VirtualPredicate key1, VirtualPredicate key2) {
            return key1.getSubKey().equals(key2.getSubKey()) && key1.getTableImplementor(AstContext.this) == key2.getTableImplementor(AstContext.this);
        }

        public Predicate add(VirtualPredicate virtualPredicate) {
            VirtualPredicateMergedResult result = (VirtualPredicateMergedResult)this.getValue(virtualPredicate);
            if (result != null) {
                result.merge(virtualPredicate);
                return null;
            }
            result = new VirtualPredicateMergedResult(AstContext.this.getStatement(), this.op);
            this.putValue(virtualPredicate, result);
            result.merge(virtualPredicate);
            AstContext.this.modCount++;
            return result;
        }
    }
}

