/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComparableExpression<T extends Comparable<?>>
extends Expression<T> {
    @NotNull
    public Predicate lt(@NotNull Expression<T> var1);

    @NotNull
    public Predicate lt(@NotNull T var1);

    @Nullable
    default public Predicate lt(boolean condition, @Nullable T other) {
        return condition && other != null ? this.lt(other) : null;
    }

    @NotNull
    public Predicate le(@NotNull Expression<T> var1);

    @NotNull
    public Predicate le(@NotNull T var1);

    @Nullable
    default public Predicate le(boolean condition, @Nullable T other) {
        return condition && other != null ? this.le(other) : null;
    }

    @NotNull
    public Predicate gt(@NotNull Expression<T> var1);

    @NotNull
    public Predicate gt(@NotNull T var1);

    @Nullable
    default public Predicate gt(boolean condition, @Nullable T other) {
        return condition && other != null ? this.gt(other) : null;
    }

    @NotNull
    public Predicate ge(@NotNull Expression<T> var1);

    @NotNull
    public Predicate ge(@NotNull T var1);

    @Nullable
    default public Predicate ge(boolean condition, @Nullable T other) {
        return condition && other != null ? this.ge(other) : null;
    }

    @NotNull
    public Predicate between(@NotNull Expression<T> var1, @NotNull Expression<T> var2);

    @NotNull
    public Predicate between(@NotNull T var1, @NotNull T var2);

    @Nullable
    default public Predicate between(boolean condition, @Nullable T min, @Nullable T max) {
        if (!condition) {
            return null;
        }
        if (min == null && max == null) {
            return null;
        }
        if (min == null) {
            return this.le(max);
        }
        if (max == null) {
            return this.ge(min);
        }
        return this.between(min, max);
    }

    @NotNull
    public Predicate notBetween(@NotNull Expression<T> var1, @NotNull Expression<T> var2);

    @NotNull
    public Predicate notBetween(@NotNull T var1, @NotNull T var2);

    @Nullable
    default public Predicate notBetween(boolean condition, @Nullable T min, @Nullable T max) {
        if (!condition) {
            return null;
        }
        if (min == null && max == null) {
            return null;
        }
        if (min == null) {
            return this.gt(max);
        }
        if (max == null) {
            return this.lt(min);
        }
        return this.notBetween(min, max);
    }

    @Override
    @NotNull
    public ComparableExpression<T> coalesce(T var1);

    @Override
    @NotNull
    public ComparableExpression<T> coalesce(Expression<T> var1);

    @Override
    @NotNull
    public @NotNull @NotNull CoalesceBuilder.Cmp<T> coalesceBuilder();
}

