/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.babyfish.jimmer.DraftConsumerUncheckedException;
import org.babyfish.jimmer.impl.util.PropCache;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ObjectReader;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class ReaderManager {
    private static final Map<Class<?>, Reader<?>> BASE_READER_MAP;
    private final JSqlClientImplementor sqlClient;
    private TypeCache<Reader<?>> typeReaderCache = new TypeCache(this::createTypeReader, true);
    private PropCache<Reader<?>> propReaderCache = new PropCache(this::createPropReader, true);

    public ReaderManager(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public Reader<?> reader(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        return immutableType != null ? this.reader(immutableType) : this.scalarReader(type);
    }

    public Reader<?> reader(ImmutableType type) {
        return (Reader)this.typeReaderCache.get(type);
    }

    public Reader<?> reader(ImmutableProp prop) {
        return (Reader)this.propReaderCache.get(prop);
    }

    private Reader<?> createPropReader(ImmutableProp prop) {
        Storage storage = prop.getStorage(this.sqlClient.getMetadataStrategy());
        if (storage instanceof ColumnDefinition) {
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new EmbeddedReader(prop.getTargetType(), this);
            }
            if (prop.isReference(TargetLevel.ENTITY)) {
                return new ReferenceReader(prop, this);
            }
            return this.scalarReader(prop);
        }
        SqlTemplate template = prop.getSqlTemplate();
        if (template instanceof FormulaTemplate) {
            return this.scalarReader(prop);
        }
        return null;
    }

    private Reader<?> createTypeReader(ImmutableType immutableType) {
        if (immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        if (immutableType instanceof AssociationType) {
            return new AssociationReader((AssociationType)immutableType, this);
        }
        if (!immutableType.isEntity()) {
            return null;
        }
        LinkedHashMap nonIdReaderMap = new LinkedHashMap();
        Reader<?> idReader = null;
        for (ImmutableProp prop : immutableType.getSelectableProps().values()) {
            if (prop.isId()) {
                idReader = this.reader(prop);
                continue;
            }
            nonIdReaderMap.put(prop, this.reader(prop));
        }
        return new ObjectReader(immutableType, idReader, nonIdReaderMap);
    }

    private Reader<?> scalarReader(ImmutableProp prop) {
        Reader<?> reader;
        ImmutableType immutableType = prop.getTargetType();
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        Reader<?> reader2 = reader = prop.isScalarList() ? null : BASE_READER_MAP.get(prop.getElementClass());
        if (reader == null) {
            ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(prop);
            if (scalarProvider == null) {
                throw new IllegalArgumentException("No scalar provider for property \"" + prop + "\"");
            }
            Class sqlType = scalarProvider.getSqlType();
            reader = BASE_READER_MAP.get(sqlType);
            if (reader == null) {
                reader = ReaderManager.unknownSqlTypeReader(sqlType, scalarProvider, this.sqlClient.getDialect());
            }
            reader = new CustomizedScalarReader(scalarProvider, reader);
        }
        return reader;
    }

    private Reader<?> scalarReader(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        Reader<?> reader = BASE_READER_MAP.get(type);
        if (reader == null) {
            ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(type);
            if (scalarProvider == null) {
                throw new IllegalArgumentException("No scalar provider for customized scalar type \"" + type.getName() + "\"");
            }
            Class sqlType = scalarProvider.getSqlType();
            reader = BASE_READER_MAP.get(sqlType);
            if (reader == null) {
                reader = ReaderManager.unknownSqlTypeReader(sqlType, scalarProvider, this.sqlClient.getDialect());
            }
            reader = new CustomizedScalarReader(scalarProvider, reader);
        }
        return reader;
    }

    private static Reader<?> unknownSqlTypeReader(Class<?> sqlType, ScalarProvider<?, ?> provider, Dialect dialect) {
        Reader<?> reader = provider.reader();
        if (reader == null && (reader = dialect.unknownReader(sqlType)) == null) {
            throw new IllegalStateException("There is no reader for unknown type \"" + sqlType.getName() + "\" in both \"" + ScalarProvider.class.getName() + "\" and \"" + dialect.getClass().getName() + "\"");
        }
        return reader;
    }

    public static boolean isStandardScalarType(Class<?> type) {
        return BASE_READER_MAP.containsKey(type);
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, new BooleanReader());
        map.put(Boolean.class, new BooleanReader());
        map.put(Character.TYPE, new CharReader());
        map.put(Character.class, new CharReader());
        map.put(Byte.TYPE, new ByteReader());
        map.put(Byte.class, new ByteReader());
        map.put(byte[].class, new ByteArrayReader());
        map.put(Byte[].class, new BoxedByteArrayReader());
        map.put(Short.TYPE, new ShortReader());
        map.put(Short.class, new ShortReader());
        map.put(Integer.TYPE, new IntReader());
        map.put(Integer.class, new IntReader());
        map.put(Long.TYPE, new LongReader());
        map.put(Long.class, new LongReader());
        map.put(Float.TYPE, new FloatReader());
        map.put(Float.class, new FloatReader());
        map.put(Double.TYPE, new DoubleReader());
        map.put(Double.class, new DoubleReader());
        map.put(BigInteger.class, new BigIntegerReader());
        map.put(BigDecimal.class, new BigDecimalReader());
        map.put(String.class, new StringReader());
        map.put(UUID.class, new UUIDReader());
        map.put(Blob.class, new BlobReader());
        map.put(Date.class, new SqlDateReader());
        map.put(Time.class, new SqlTimeReader());
        map.put(Timestamp.class, new SqlTimestampReader());
        map.put(java.util.Date.class, new DateReader());
        map.put(LocalDate.class, new LocalDateReader());
        map.put(LocalTime.class, new LocalTimeReader());
        map.put(LocalDateTime.class, new LocalDateTimeReader());
        map.put(OffsetDateTime.class, new OffsetDateTimeReader());
        map.put(ZonedDateTime.class, new ZonedDateTimeReader());
        BASE_READER_MAP = map;
    }

    private static class EmbeddedReader
    implements Reader<Object> {
        private static final ImmutableProp[] EMPTY_PROPS = new ImmutableProp[0];
        private static final Reader<?>[] EMPTY_READERS = new Reader[0];
        private final ImmutableType targetType;
        private ImmutableProp[] props;
        private Reader<?>[] readers;

        EmbeddedReader(ImmutableType targetType, ReaderManager readerManager) {
            this.targetType = targetType;
            LinkedHashMap<ImmutableProp, Reader> map = new LinkedHashMap<ImmutableProp, Reader>();
            for (ImmutableProp childProp : targetType.getProps().values()) {
                if (childProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                    map.put(childProp, new EmbeddedReader(childProp.getTargetType(), readerManager));
                    continue;
                }
                map.put(childProp, readerManager.scalarReader(childProp));
            }
            this.props = map.keySet().toArray(EMPTY_PROPS);
            this.readers = map.values().toArray(EMPTY_READERS);
        }

        @Override
        public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
            DraftSpi spi = (DraftSpi)this.targetType.getDraftFactory().apply(ctx.draftContext(), null);
            try {
                int size = this.readers.length;
                for (int i = 0; i < size; ++i) {
                    ImmutableProp prop = this.props[i];
                    Object value = this.readers[i].read(rs, ctx);
                    if (value == null && !prop.isNullable()) continue;
                    spi.__set(prop.getId(), value);
                }
            }
            catch (Throwable ex) {
                return DraftConsumerUncheckedException.rethrow((Throwable)ex);
            }
            Object embeddable = ctx.resolve(spi);
            return EmbeddableObjects.isCompleted(embeddable) ? embeddable : null;
        }
    }

    private static class ReferenceReader
    implements Reader<Object> {
        private final ImmutableType targetType;
        private final Reader<?> foreignKeyReader;

        private ReferenceReader(ImmutableProp prop, ReaderManager readerManager) {
            this.targetType = prop.getTargetType();
            this.foreignKeyReader = readerManager.scalarReader(this.targetType.getIdProp());
        }

        @Override
        public Object read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object fk = this.foreignKeyReader.read(rs, ctx);
            if (fk == null) {
                return null;
            }
            DraftSpi spi = (DraftSpi)this.targetType.getDraftFactory().apply(ctx.draftContext(), null);
            try {
                spi.__set(this.targetType.getIdProp().getId(), fk);
            }
            catch (Throwable ex) {
                throw DraftConsumerUncheckedException.rethrow((Throwable)ex);
            }
            return ctx.resolve(spi);
        }
    }

    private static class AssociationReader
    implements Reader<Association<?, ?>> {
        private final ImmutableType sourceType;
        private final ImmutableType targetType;
        private final ImmutableProp sourceIdProp;
        private final ImmutableProp targetIdProp;
        private final Reader<?> sourceReader;
        private final Reader<?> targetReader;

        AssociationReader(AssociationType associationType, ReaderManager readerManager) {
            this.sourceType = associationType.getSourceType();
            this.targetType = associationType.getTargetType();
            this.sourceIdProp = this.sourceType.getIdProp();
            this.targetIdProp = this.targetType.getIdProp();
            this.sourceReader = new ReferenceReader(associationType.getSourceProp(), readerManager);
            this.targetReader = new ReferenceReader(associationType.getTargetProp(), readerManager);
        }

        @Override
        public Association<?, ?> read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object source = this.sourceReader.read(rs, ctx);
            Object target = this.targetReader.read(rs, ctx);
            return new Association(source, target);
        }
    }

    private static class CustomizedScalarReader<T, S>
    implements Reader<T> {
        private final ScalarProvider<T, S> scalarProvider;
        private final Reader<S> sqlReader;

        CustomizedScalarReader(ScalarProvider<T, S> scalarProvider, Reader<S> sqlReader) {
            this.scalarProvider = scalarProvider;
            this.sqlReader = sqlReader;
        }

        @Override
        public T read(ResultSet rs, Reader.Context ctx) throws SQLException {
            S sqlValue = this.sqlReader.read(rs, ctx);
            try {
                return sqlValue != null ? (T)this.scalarProvider.toScalar(sqlValue) : null;
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot convert \"" + sqlValue + "\" to the jvm type \"" + this.scalarProvider.getScalarType() + "\"", ex);
            }
        }
    }

    private static class BooleanReader
    implements Reader<Boolean> {
        private BooleanReader() {
        }

        @Override
        public Boolean read(ResultSet rs, Reader.Context ctx) throws SQLException {
            boolean value = rs.getBoolean(ctx.col());
            if (!value && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class CharReader
    implements Reader<Character> {
        private CharReader() {
        }

        @Override
        public Character read(ResultSet rs, Reader.Context ctx) throws SQLException {
            String str = rs.getString(ctx.col());
            return str != null ? Character.valueOf(str.charAt(0)) : null;
        }
    }

    private static class ByteReader
    implements Reader<Byte> {
        private ByteReader() {
        }

        @Override
        public Byte read(ResultSet rs, Reader.Context ctx) throws SQLException {
            byte value = rs.getByte(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class ByteArrayReader
    implements Reader<byte[]> {
        private ByteArrayReader() {
        }

        @Override
        public byte[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBytes(ctx.col());
        }
    }

    private static class BoxedByteArrayReader
    implements Reader<Byte[]> {
        private BoxedByteArrayReader() {
        }

        @Override
        public Byte[] read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getObject(ctx.col(), Byte[].class);
        }
    }

    private static class ShortReader
    implements Reader<Short> {
        private ShortReader() {
        }

        @Override
        public Short read(ResultSet rs, Reader.Context ctx) throws SQLException {
            short value = rs.getShort(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class IntReader
    implements Reader<Integer> {
        private IntReader() {
        }

        @Override
        public Integer read(ResultSet rs, Reader.Context ctx) throws SQLException {
            int value = rs.getInt(ctx.col());
            if (value == 0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class LongReader
    implements Reader<Long> {
        private LongReader() {
        }

        @Override
        public Long read(ResultSet rs, Reader.Context ctx) throws SQLException {
            long value = rs.getLong(ctx.col());
            if (value == 0L && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class FloatReader
    implements Reader<Float> {
        private FloatReader() {
        }

        @Override
        public Float read(ResultSet rs, Reader.Context ctx) throws SQLException {
            float value = rs.getFloat(ctx.col());
            if (value == 0.0f && rs.wasNull()) {
                return null;
            }
            return Float.valueOf(value);
        }
    }

    private static class DoubleReader
    implements Reader<Double> {
        private DoubleReader() {
        }

        @Override
        public Double read(ResultSet rs, Reader.Context ctx) throws SQLException {
            double value = rs.getDouble(ctx.col());
            if (value == 0.0 && rs.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class BigIntegerReader
    implements Reader<BigInteger> {
        private BigIntegerReader() {
        }

        @Override
        public BigInteger read(ResultSet rs, Reader.Context ctx) throws SQLException {
            BigDecimal decimal = rs.getBigDecimal(ctx.col());
            return decimal.toBigInteger();
        }
    }

    private static class BigDecimalReader
    implements Reader<BigDecimal> {
        private BigDecimalReader() {
        }

        @Override
        public BigDecimal read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBigDecimal(ctx.col());
        }
    }

    private static class StringReader
    implements Reader<String> {
        private StringReader() {
        }

        @Override
        public String read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getString(ctx.col());
        }
    }

    private static class UUIDReader
    implements Reader<UUID> {
        private UUIDReader() {
        }

        @Override
        public UUID read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Object obj = rs.getObject(ctx.col());
            if (obj == null) {
                return null;
            }
            if (obj instanceof byte[]) {
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])obj);
                long high = byteBuffer.getLong();
                long low = byteBuffer.getLong();
                return new UUID(high, low);
            }
            return UUID.fromString(obj.toString());
        }
    }

    private static class BlobReader
    implements Reader<Blob> {
        private BlobReader() {
        }

        @Override
        public Blob read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getBlob(ctx.col());
        }
    }

    private static class SqlDateReader
    implements Reader<Date> {
        private SqlDateReader() {
        }

        @Override
        public Date read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getDate(ctx.col());
        }
    }

    private static class SqlTimeReader
    implements Reader<Time> {
        private SqlTimeReader() {
        }

        @Override
        public Time read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getTime(ctx.col());
        }
    }

    private static class SqlTimestampReader
    implements Reader<Timestamp> {
        private SqlTimestampReader() {
        }

        @Override
        public Timestamp read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getTimestamp(ctx.col());
        }
    }

    private static class DateReader
    implements Reader<java.util.Date> {
        private DateReader() {
        }

        @Override
        public java.util.Date read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(ctx.col());
            return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
        }
    }

    private static class LocalDateReader
    implements Reader<LocalDate> {
        private LocalDateReader() {
        }

        @Override
        public LocalDate read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(ctx.col());
            return timestamp != null ? timestamp.toLocalDateTime().toLocalDate() : null;
        }
    }

    private static class LocalTimeReader
    implements Reader<LocalTime> {
        private LocalTimeReader() {
        }

        @Override
        public LocalTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(ctx.col());
            return timestamp != null ? timestamp.toLocalDateTime().toLocalTime() : null;
        }
    }

    private static class LocalDateTimeReader
    implements Reader<LocalDateTime> {
        private LocalDateTimeReader() {
        }

        @Override
        public LocalDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(ctx.col());
            return timestamp != null ? timestamp.toLocalDateTime() : null;
        }
    }

    private static class OffsetDateTimeReader
    implements Reader<OffsetDateTime> {
        private OffsetDateTimeReader() {
        }

        @Override
        public OffsetDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getObject(ctx.col(), OffsetDateTime.class);
        }
    }

    private static class ZonedDateTimeReader
    implements Reader<ZonedDateTime> {
        private ZonedDateTimeReader() {
        }

        @Override
        public ZonedDateTime read(ResultSet rs, Reader.Context ctx) throws SQLException {
            return rs.getObject(ctx.col(), ZonedDateTime.class);
        }
    }
}

