/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogParser;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinLogImpl
implements BinLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinLog.class);
    private static final Set<String> EXCLUDED_TABLE_NAMES = BinLogImpl.standardTableNames("JIMMER_TRANS_CACHE_OPERATOR");
    private final EntityManager entityManager;
    private final String microServiceName;
    private final MetadataStrategy strategy;
    private final BinLogParser parser;
    private final Triggers triggers;

    public BinLogImpl(EntityManager entityManager, String microServiceName, MetadataStrategy strategy, BinLogParser parser, Triggers triggers) {
        this.entityManager = entityManager;
        this.microServiceName = microServiceName;
        this.strategy = strategy;
        this.parser = parser;
        this.triggers = triggers;
    }

    @Override
    public void accept(String tableName, JsonNode oldData, JsonNode newData) {
        this.accept(tableName, oldData, newData, null);
    }

    @Override
    public void accept(String tableName, JsonNode oldData, JsonNode newData, String reason) {
        boolean isNewNull;
        boolean isOldNull = oldData == null || oldData.isNull();
        boolean bl = isNewNull = newData == null || newData.isNull();
        if (isOldNull && isNewNull) {
            return;
        }
        ImmutableType type = this.entityManager.getTypeByServiceAndTable(this.microServiceName, tableName, this.strategy);
        if (type == null) {
            if (!EXCLUDED_TABLE_NAMES.contains(DatabaseIdentifiers.comparableIdentifier((String)tableName))) {
                LOGGER.warn("Illegal table name \"{}\" of micro service \"{}\", it is not managed by current entity manager", (Object)tableName, (Object)this.microServiceName);
            }
            return;
        }
        if (type instanceof AssociationType) {
            if (isOldNull) {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.parser.parseIdPair(associationType, newData);
                this.triggers.fireMiddleTableInsert(associationType.getBaseProp(), idPair.get_1(), idPair.get_2(), null, reason);
            } else {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.parser.parseIdPair(associationType, oldData);
                this.triggers.fireMiddleTableDelete(associationType.getBaseProp(), idPair.get_1(), idPair.get_2(), null, reason);
            }
        } else {
            this.triggers.fireEntityTableChange(this.parser.parseEntity(type, oldData), this.parser.parseEntity(type, newData), null, reason);
        }
    }

    public BinLogParser parser() {
        return this.parser;
    }

    private static Set<String> standardTableNames(String ... tableNames) {
        HashSet<String> set = new HashSet<String>();
        for (String tableName : tableNames) {
            set.add(DatabaseIdentifiers.comparableIdentifier((String)tableName));
        }
        return set;
    }
}

