/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftInterceptorManager;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ScalarProviderManager;
import org.babyfish.jimmer.sql.Serialized;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.TransientResolverManager;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.di.AopProxyProvider;
import org.babyfish.jimmer.sql.di.DefaultLogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.sql.di.DefaultTransientResolverProvider;
import org.babyfish.jimmer.sql.di.DefaultUserIdGeneratorProvider;
import org.babyfish.jimmer.sql.di.InitializationType;
import org.babyfish.jimmer.sql.di.LogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.sql.di.StrategyProvider;
import org.babyfish.jimmer.sql.di.TransientResolverProvider;
import org.babyfish.jimmer.sql.di.UserIdGeneratorProvider;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.BinLogPropReader;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogImpl;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogParser;
import org.babyfish.jimmer.sql.event.impl.TriggersImpl;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.filter.impl.LogicalDeletedFilterProvider;
import org.babyfish.jimmer.sql.loader.graphql.Loaders;
import org.babyfish.jimmer.sql.loader.graphql.impl.LoadersImpl;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.ForeignKeyStrategy;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationException;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.DatabaseValidators;
import org.babyfish.jimmer.sql.runtime.DefaultDatabaseNamingStrategy;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.IdOnlyTargetCheckingLevel;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ReaderManager;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSqlClientImpl
implements JSqlClientImplementor {
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final List<String> executorContextPrefixes;
    private final SqlFormatter sqlFormatter;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final ScalarProviderManager scalarProviderManager;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final int offsetOptimizingThreshold;
    private final EntitiesImpl entities;
    private final EntityManager entityManager;
    private final Caches caches;
    private final TriggersImpl triggers;
    private final TriggersImpl transactionTriggers;
    private final MetadataStrategy metadataStrategy;
    private final BinLog binLog;
    private final UserIdGeneratorProvider userIdGeneratorProvider;
    private final LogicalDeletedValueGeneratorProvider logicalDeletedValueGeneratorProvider;
    private final TransientResolverManager transientResolverManager;
    private final FilterManager filterManager;
    private final boolean defaultDissociationActionCheckable;
    private final IdOnlyTargetCheckingLevel idOnlyTargetCheckingLevel;
    private final boolean saveCommandPessimisticLock;
    private final DraftInterceptorManager draftInterceptorManager;
    private final String microServiceName;
    private final MicroServiceExchange microServiceExchange;
    private final Loaders loaders = new LoadersImpl(this);
    private final ReaderManager readerManager = new ReaderManager(this);
    private final ReadWriteLock initializationLock = new ReentrantReadWriteLock();
    private SqlClientInitializer sqlClientInitializer;

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, List<String> executorContextPrefixes, SqlFormatter sqlFormatter, Map<Class<?>, IdGenerator> idGeneratorMap, ScalarProviderManager scalarProviderManager, int defaultBatchSize, int defaultListBatchSize, int offsetOptimizingThreshold, EntitiesImpl entities, EntityManager entityManager, Caches caches, TriggersImpl triggers, TriggersImpl transactionTriggers, MetadataStrategy metadataStrategy, BinLog binLog, FilterManager filterManager, UserIdGeneratorProvider userIdGeneratorProvider, LogicalDeletedValueGeneratorProvider logicalDeletedValueGeneratorProvider, TransientResolverManager transientResolverManager, boolean defaultDissociationActionCheckable, IdOnlyTargetCheckingLevel idOnlyTargetCheckingLevel, boolean saveCommandPessimisticLock, DraftInterceptorManager draftInterceptorManager, String microServiceName, MicroServiceExchange microServiceExchange, SqlClientInitializer sqlClientInitializer) {
        this.connectionManager = connectionManager != null ? connectionManager : ConnectionManager.ILLEGAL;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect;
        this.executor = executor != null ? executor : DefaultExecutor.INSTANCE;
        this.executorContextPrefixes = executorContextPrefixes != null ? Collections.unmodifiableList(executorContextPrefixes) : null;
        this.sqlFormatter = sqlFormatter;
        this.idGeneratorMap = idGeneratorMap;
        this.scalarProviderManager = scalarProviderManager;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.offsetOptimizingThreshold = offsetOptimizingThreshold;
        this.entities = entities != null ? entities.forSqlClient(this) : new EntitiesImpl(this);
        this.entityManager = entityManager;
        this.caches = caches;
        this.triggers = triggers;
        this.transactionTriggers = transactionTriggers;
        this.metadataStrategy = metadataStrategy;
        this.binLog = binLog;
        this.filterManager = filterManager;
        this.userIdGeneratorProvider = userIdGeneratorProvider != null ? userIdGeneratorProvider : new DefaultUserIdGeneratorProvider();
        this.logicalDeletedValueGeneratorProvider = logicalDeletedValueGeneratorProvider != null ? logicalDeletedValueGeneratorProvider : new DefaultLogicalDeletedValueGeneratorProvider();
        this.transientResolverManager = transientResolverManager;
        this.defaultDissociationActionCheckable = defaultDissociationActionCheckable;
        this.idOnlyTargetCheckingLevel = idOnlyTargetCheckingLevel;
        this.saveCommandPessimisticLock = saveCommandPessimisticLock;
        this.draftInterceptorManager = draftInterceptorManager;
        this.microServiceName = microServiceName;
        this.microServiceExchange = microServiceExchange;
        this.sqlClientInitializer = sqlClientInitializer;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager(boolean forUpdate) {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null && !forUpdate) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public List<String> getExecutorContextPrefixes() {
        return this.executorContextPrefixes;
    }

    @Override
    public SqlFormatter getSqlFormatter() {
        return this.sqlFormatter;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        return this.scalarProviderManager.getProvider(scalarType);
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(TypedProp<T, ?> prop) {
        return this.scalarProviderManager.getProvider(prop.unwrap());
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(ImmutableProp prop) {
        return this.scalarProviderManager.getProvider(prop);
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator((SqlContext)this);
        }
        return userIdGenerator;
    }

    public <T extends SqlContext> T unwrap() {
        return null;
    }

    public UserIdGenerator<?> getUserIdGenerator(String ref) throws Exception {
        return (UserIdGenerator)this.userIdGeneratorProvider.get(ref, (JSqlClient)this);
    }

    public UserIdGenerator<?> getUserIdGenerator(Class<?> userIdGeneratorType) throws Exception {
        return (UserIdGenerator)this.userIdGeneratorProvider.get(userIdGeneratorType, (JSqlClient)this);
    }

    public LogicalDeletedValueGenerator<?> getLogicalDeletedValueGenerator(String ref) throws Exception {
        return (LogicalDeletedValueGenerator)this.logicalDeletedValueGeneratorProvider.get(ref, (JSqlClient)this);
    }

    public LogicalDeletedValueGenerator<?> getLogicalDeletedValueGenerator(Class<?> logicalDeletedValueGeneratorType) throws Exception {
        return (LogicalDeletedValueGenerator)this.logicalDeletedValueGeneratorProvider.get(logicalDeletedValueGeneratorType, (JSqlClient)this);
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public int getOffsetOptimizingThreshold() {
        return this.offsetOptimizingThreshold;
    }

    @Override
    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T table) {
        if (table instanceof TableEx) {
            throw new IllegalArgumentException("Top-level query does not support TableEx");
        }
        return new MutableRootQueryImpl((JSqlClientImplementor)this, table, ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
    }

    @Override
    public MutableUpdate createUpdate(TableProxy<?> table) {
        return new MutableUpdateImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public MutableDelete createDelete(TableProxy<?> table) {
        return new MutableDeleteImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableRootQueryImpl<AssociationTable<SE, ST, TE, TT>>((JSqlClientImplementor)this, (TableProxy)((Object)table), ExecutionPurpose.QUERY, FilterLevel.DEFAULT);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return new MutableSubQueryImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableSubQueryImpl((JSqlClientImplementor)this, (TableProxy)((Object)table));
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public CacheOperator getCacheOperator() {
        return ((CachesImpl)this.caches).getOperator();
    }

    @Override
    public TriggerType getTriggerType() {
        if (this.transactionTriggers == null) {
            return TriggerType.BINLOG_ONLY;
        }
        if (this.transactionTriggers == this.triggers) {
            return TriggerType.TRANSACTION_ONLY;
        }
        return TriggerType.BOTH;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public Triggers getTriggers(boolean transaction) {
        if (transaction) {
            TriggersImpl tt = this.transactionTriggers;
            if (tt == null) {
                throw new IllegalStateException("Transaction triggers is not supported by current sql client");
            }
            return tt;
        }
        return this.triggers;
    }

    @Override
    public MetadataStrategy getMetadataStrategy() {
        return this.metadataStrategy;
    }

    @Override
    public BinLog getBinLog() {
        BinLog bl = this.binLog;
        if (bl == null) {
            throw new IllegalStateException("binLog is not supported because the entityManager of sql client is not specified");
        }
        return bl;
    }

    @Override
    public Associations getAssociations(TypedProp.Association<?, ?> prop) {
        return this.getAssociations(prop.unwrap());
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public Loaders getLoaders() {
        return this.loaders;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClientImplementor caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, this.filterManager, this.userIdGeneratorProvider, this.logicalDeletedValueGeneratorProvider, this.transientResolverManager, this.defaultDissociationActionCheckable, this.idOnlyTargetCheckingLevel, this.saveCommandPessimisticLock, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange, this.sqlClientInitializer);
    }

    @Override
    public JSqlClientImplementor filters(Consumer<FilterConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        FilterConfig cfg = new FilterConfig(this.filterManager);
        block.accept(cfg);
        if (cfg.getFilterManager() == this.filterManager) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, cfg.getFilterManager(), this.userIdGeneratorProvider, this.logicalDeletedValueGeneratorProvider, this.transientResolverManager, this.defaultDissociationActionCheckable, this.idOnlyTargetCheckingLevel, this.saveCommandPessimisticLock, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange, this.sqlClientInitializer);
    }

    @Override
    public JSqlClientImplementor disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, this.filterManager, this.userIdGeneratorProvider, this.logicalDeletedValueGeneratorProvider, this.transientResolverManager, this.defaultDissociationActionCheckable, this.idOnlyTargetCheckingLevel, this.saveCommandPessimisticLock, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange, this.sqlClientInitializer);
    }

    @Override
    public JSqlClientImplementor executor(Executor executor) {
        if (executor == null) {
            executor = DefaultExecutor.INSTANCE;
        }
        if (this.executor.equals(executor)) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, this.filterManager, this.userIdGeneratorProvider, this.logicalDeletedValueGeneratorProvider, this.transientResolverManager, this.defaultDissociationActionCheckable, this.idOnlyTargetCheckingLevel, this.saveCommandPessimisticLock, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange, this.sqlClientInitializer);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return this.transientResolverManager.get(prop);
    }

    public UserIdGeneratorProvider getUserIdGeneratorProvider() {
        return this.userIdGeneratorProvider;
    }

    @Override
    public StrategyProvider<TransientResolver<?, ?>> getTransientResolverProvider() {
        return this.transientResolverManager.getTransientResolverProvider();
    }

    @Override
    public Filters getFilters() {
        return this.filterManager;
    }

    @Override
    public boolean isDefaultDissociationActionCheckable() {
        return this.defaultDissociationActionCheckable;
    }

    @Override
    public IdOnlyTargetCheckingLevel getIdOnlyTargetCheckingLevel() {
        return this.idOnlyTargetCheckingLevel;
    }

    @Override
    @Nullable
    public DraftInterceptor<?, ?> getDraftInterceptor(ImmutableType type) {
        return this.draftInterceptorManager.get(type);
    }

    @Override
    public Reader<?> getReader(Class<?> type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableType type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableProp prop) {
        return this.readerManager.reader(prop);
    }

    @Override
    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @Override
    public MicroServiceExchange getMicroServiceExchange() {
        return this.microServiceExchange;
    }

    @Override
    public void initialize() {
        if (this.sqlClientInitializer != null) {
            this.sqlClientInitializer.initialize();
        }
    }

    private static class SqlClientInitializer {
        private final ReadWriteLock rwl = new ReentrantReadWriteLock();
        private Runnable action;

        private SqlClientInitializer() {
        }

        public void setAction(Runnable action) {
            if (this.action != null) {
                throw new IllegalStateException("action has already been set");
            }
            if (action == null) {
                throw new IllegalArgumentException("action cannot be null");
            }
            this.action = action;
        }

        private void initialize() {
            Lock lock = this.rwl.readLock();
            lock.lock();
            try {
                if (this.action == null) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            lock = this.rwl.writeLock();
            lock.lock();
            try {
                if (this.action == null) {
                    return;
                }
                this.action.run();
                this.action = null;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private static final Logger LOGGER = LoggerFactory.getLogger(BuilderImpl.class);
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect = DefaultDialect.INSTANCE;
        private Executor executor;
        private List<String> executorContextPrefixes;
        private SqlFormatter sqlFormatter = SqlFormatter.SIMPLE;
        private UserIdGeneratorProvider userIdGeneratorProvider;
        private LogicalDeletedValueGeneratorProvider logicalDeletedValueGeneratorProvider;
        private TransientResolverProvider transientResolverProvider;
        private final Map<Class<?>, ScalarProvider<?, ?>> typeScalarProviderMap = new HashMap();
        private final Map<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderMap = new HashMap();
        private final Map<Class<?>, ObjectMapper> serializedTypeObjectMapperMap = new HashMap();
        private final Map<ImmutableProp, ObjectMapper> serializedPropObjectMapperMap = new HashMap<ImmutableProp, ObjectMapper>();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private EnumType.Strategy defaultEnumStrategy = EnumType.Strategy.NAME;
        private DatabaseNamingStrategy databaseNamingStrategy = DefaultDatabaseNamingStrategy.UPPER_CASE;
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private int offsetOptimizingThreshold = Integer.MAX_VALUE;
        private EntityManager userEntityManager;
        private EntityManager defaultEntityManager;
        private final CacheConfig cacheConfig = new CacheConfig();
        private TriggerType triggerType = TriggerType.BINLOG_ONLY;
        private TriggersImpl triggers;
        private TriggersImpl transactionTriggers;
        private LogicalDeletedBehavior logicalDeletedBehavior = LogicalDeletedBehavior.DEFAULT;
        private final List<Filter<?>> filters = new ArrayList();
        private final Set<Filter<?>> disabledFilters = new HashSet();
        private boolean defaultDissociationActionCheckable = true;
        private IdOnlyTargetCheckingLevel idOnlyTargetCheckingLevel = IdOnlyTargetCheckingLevel.NONE;
        private boolean saveCommandPessimisticLock = false;
        private final List<DraftInterceptor<?, ?>> interceptors = new ArrayList();
        private ObjectMapper binLogObjectMapper;
        private final Map<ImmutableProp, BinLogPropReader> binLogPropReaderMap = new HashMap<ImmutableProp, BinLogPropReader>();
        private final Map<Class<?>, BinLogPropReader> typeBinLogPropReaderMap = new HashMap();
        private boolean isForeignKeyEnabledByDefault = true;
        private final Set<Customizer> customizers = new LinkedHashSet<Customizer>();
        private final Set<Initializer> initializers = new LinkedHashSet<Initializer>();
        private DatabaseValidationMode databaseValidationMode = DatabaseValidationMode.NONE;
        private String databaseValidationCatalog;
        private String databaseValidationSchema;
        private AopProxyProvider aopProxyProvider;
        private String microServiceName = "";
        private MicroServiceExchange microServiceExchange;
        private InitializationType initializationType = InitializationType.IMMEDIATE;

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect != null ? dialect : DefaultDialect.INSTANCE;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutorContextPrefixes(Collection<String> prefixes) {
            if (prefixes == null || prefixes.isEmpty()) {
                this.executorContextPrefixes = null;
            } else {
                TreeSet<String> set = new TreeSet<String>();
                for (String prefix : prefixes) {
                    if (prefix == null || prefix.isEmpty()) continue;
                    set.add(prefix);
                }
                this.executorContextPrefixes = set.isEmpty() ? null : new ArrayList<String>(set);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setSqlFormatter(SqlFormatter sqlFormatter) {
            this.sqlFormatter = sqlFormatter != null ? sqlFormatter : SqlFormatter.SIMPLE;
            return this;
        }

        @Override
        public JSqlClient.Builder setUserIdGeneratorProvider(UserIdGeneratorProvider userIdGeneratorProvider) {
            this.userIdGeneratorProvider = userIdGeneratorProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setLogicalDeletedValueGeneratorProvider(LogicalDeletedValueGeneratorProvider logicalDeletedValueGeneratorProvider) {
            this.logicalDeletedValueGeneratorProvider = logicalDeletedValueGeneratorProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setTransientResolverProvider(TransientResolverProvider transientResolverProvider) {
            this.transientResolverProvider = transientResolverProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            Collection<ImmutableProp> props = scalarProvider.getHandledProps();
            if (props == null || props.isEmpty()) {
                this.addScalarProviderImpl(null, scalarProvider);
            } else {
                for (ImmutableProp prop : props) {
                    if (prop == null) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" cannot be null");
                    }
                    if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" must be scalar, but \"" + prop + "\" is not");
                    }
                    this.addScalarProviderImpl(prop, scalarProvider);
                }
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setScalarProvider(TypedProp<?, ?> prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop.unwrap(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder setScalarProvider(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop, scalarProvider);
            return this;
        }

        private void addScalarProviderImpl(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            Type scalarType = scalarProvider.getScalarType();
            if (prop == null) {
                if (!(scalarType instanceof Class)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be \"" + scalarType + "\" because it is global scalar provider, please use property-specific scalar provider");
                }
                if (this.typeScalarProviderMap.containsKey(scalarType)) {
                    throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarType + "\" twice");
                }
                if (((Class)scalarType).isArray() || Iterable.class.isAssignableFrom((Class)scalarType) || Map.class.isAssignableFrom((Class)scalarType)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be array, collection or map, because it is global scalar provider, please use property-specific scalar provider");
                }
                this.typeScalarProviderMap.put((Class)scalarType, scalarProvider);
            } else {
                if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" because the property is not scalar property");
                }
                if (this.propScalarProviderMap.containsKey(prop)) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" twice");
                }
                ImmutableProp originalProp = prop.toOriginal();
                if (originalProp != prop) {
                    throw new IllegalArgumentException("\"" + prop + "\" hides \"" + originalProp + "\", please add scalar provider for that hidden property");
                }
                this.propScalarProviderMap.put(prop, scalarProvider);
            }
        }

        @Override
        public JSqlClient.Builder setDefaultSerializedTypeObjectMapper(ObjectMapper mapper) {
            return this.setSerializedTypeObjectMapper(Object.class, mapper);
        }

        @Override
        public JSqlClient.Builder setSerializedTypeObjectMapper(Class<?> type, ObjectMapper mapper) {
            this.serializedTypeObjectMapperMap.put(type != null ? type : Object.class, mapper);
            return this;
        }

        @Override
        public JSqlClient.Builder setSerializedPropObjectMapper(TypedProp<?, ?> prop, ObjectMapper mapper) {
            return this.setSerializedPropObjectMapper(prop.unwrap(), mapper);
        }

        @Override
        public JSqlClient.Builder setSerializedPropObjectMapper(ImmutableProp prop, ObjectMapper mapper) {
            if (prop.getAnnotation(Serialized.class) == null) {
                throw new IllegalArgumentException("Cannot set the serialized property object mapper for \"" + prop + "\" because it is not decorated by \"@" + Serialized.class.getName() + "\"");
            }
            this.serializedPropObjectMapperMap.put(prop, mapper);
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultEnumStrategy(EnumType.Strategy strategy) {
            this.defaultEnumStrategy = strategy != null ? strategy : EnumType.Strategy.NAME;
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseNamingStrategy(DatabaseNamingStrategy strategy) {
            this.databaseNamingStrategy = strategy != null ? strategy : DefaultDatabaseNamingStrategy.UPPER_CASE;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setOffsetOptimizingThreshold(int threshold) {
            if (threshold < 0) {
                throw new IllegalArgumentException("`threshold` cannot be negative number");
            }
            this.offsetOptimizingThreshold = threshold;
            return this;
        }

        @Override
        public JSqlClient.Builder setEntityManager(EntityManager entityManager) {
            if (this.userEntityManager != null && this.userEntityManager != entityManager) {
                throw new IllegalStateException("The EntityManager of SqlBuilder.Builder can only be set once");
            }
            this.userEntityManager = entityManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            block.accept(this.cacheConfig);
            return this;
        }

        @Override
        public JSqlClient.Builder setCacheFactory(CacheFactory cacheFactory) {
            this.cacheConfig.setCacheFactory(cacheFactory);
            return this;
        }

        @Override
        public JSqlClient.Builder setCacheOperator(CacheOperator cacheOperator) {
            this.cacheConfig.setCacheOperator(cacheOperator);
            return this;
        }

        @Override
        public JSqlClient.Builder addCacheAbandonedCallback(CacheAbandonedCallback callback) {
            this.cacheConfig.addAbandonedCallback(callback);
            return this;
        }

        @Override
        public JSqlClient.Builder addCacheAbandonedCallbacks(Collection<? extends CacheAbandonedCallback> callbacks) {
            this.cacheConfig.addAbandonedCallbacks(callbacks);
            return this;
        }

        @Override
        public JSqlClient.Builder setTriggerType(TriggerType triggerType) {
            this.triggerType = triggerType != null ? triggerType : TriggerType.BINLOG_ONLY;
            return this;
        }

        @Override
        public JSqlClient.Builder setLogicalDeletedBehavior(LogicalDeletedBehavior behavior) {
            this.logicalDeletedBehavior = behavior != null ? behavior : LogicalDeletedBehavior.DEFAULT;
            return this;
        }

        @Override
        public JSqlClient.Builder addFilters(Filter<?> ... filters) {
            return this.addFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addFilters(Collection<? extends Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                if (filter instanceof FilterManager.Exported) {
                    throw new IllegalArgumentException("Cannot add filter which is exported by filter manager");
                }
                this.filters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Filter<?> ... filters) {
            return this.addDisabledFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Collection<? extends Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
                this.disabledFilters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultDissociateActionCheckable(boolean checkable) {
            this.defaultDissociationActionCheckable = checkable;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdOnlyTargetCheckingLevel(IdOnlyTargetCheckingLevel checkingLevel) {
            this.idOnlyTargetCheckingLevel = checkingLevel != null ? checkingLevel : IdOnlyTargetCheckingLevel.NONE;
            return this;
        }

        @Override
        public JSqlClient.Builder setSaveCommandPessimisticLock() {
            return this.setSaveCommandPessimisticLock(true);
        }

        @Override
        public JSqlClient.Builder setSaveCommandPessimisticLock(boolean lock) {
            this.saveCommandPessimisticLock = lock;
            return this;
        }

        @Override
        public JSqlClient.Builder addDraftInterceptor(DraftInterceptor<?, ?> interceptor) {
            return this.addDraftInterceptors(Collections.singletonList(interceptor));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(DraftInterceptor<?, ?> ... interceptors) {
            return this.addDraftInterceptors(Arrays.asList(interceptors));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(Collection<? extends DraftInterceptor<?, ?>> interceptors) {
            for (DraftInterceptor<?, ?> interceptor : interceptors) {
                if (interceptor == null) continue;
                this.interceptors.add(interceptor);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBinLogObjectMapper(ObjectMapper mapper) {
            this.binLogObjectMapper = mapper;
            return this;
        }

        @Override
        public JSqlClient.Builder setBinLogPropReader(ImmutableProp prop, BinLogPropReader reader) {
            if (prop.isEmbedded(EmbeddedLevel.BOTH)) {
                throw new IllegalArgumentException("Cannot set bin log reader for embedded property \"" + prop + "\"");
            }
            if (!prop.isScalar(TargetLevel.ENTITY)) {
                throw new IllegalArgumentException("Cannot set bin log reader for non-scalar property \"" + prop + "\"");
            }
            if (!prop.isColumnDefinition()) {
                throw new IllegalArgumentException("Cannot set bin log reader for property \"" + prop + "\" which is not column definition");
            }
            if (prop instanceof AssociationProp) {
                throw new IllegalArgumentException("Cannot set bin log reader for association property \"" + prop + "\"");
            }
            this.binLogPropReaderMap.put(prop, reader);
            return this;
        }

        @Override
        public JSqlClient.Builder setBinLogPropReader(TypedProp.Scalar<?, ?> prop, BinLogPropReader reader) {
            return this.setBinLogPropReader(prop.unwrap(), reader);
        }

        @Override
        public JSqlClient.Builder setBinLogPropReader(Class<?> propType, BinLogPropReader reader) {
            if (propType == Void.TYPE) {
                throw new IllegalArgumentException("Cannot set bin log reader for void type");
            }
            this.typeBinLogPropReaderMap.put(propType, reader);
            return this;
        }

        @Override
        public JSqlClient.Builder setForeignKeyEnabledByDefault(boolean enabled) {
            this.isForeignKeyEnabledByDefault = enabled;
            return this;
        }

        @Override
        public JSqlClient.Builder addCustomizers(Customizer ... customizers) {
            for (Customizer customizer : customizers) {
                if (customizer == null) continue;
                this.customizers.add(customizer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addCustomizers(Collection<? extends Customizer> customizers) {
            for (Customizer customizer : customizers) {
                if (customizer == null) continue;
                this.customizers.add(customizer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addInitializers(Initializer ... initializers) {
            for (Initializer initializer : initializers) {
                if (initializer == null) continue;
                this.initializers.add(initializer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addInitializers(Collection<? extends Initializer> initializers) {
            for (Initializer initializer : initializers) {
                if (initializer == null) continue;
                this.initializers.add(initializer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseValidationMode(DatabaseValidationMode databaseValidationMode) {
            this.databaseValidationMode = Objects.requireNonNull(databaseValidationMode, "argument cannot be null");
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseValidationCatalog(String catalog) {
            this.databaseValidationCatalog = catalog != null && !catalog.isEmpty() ? catalog : null;
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseValidationSchema(String schema) {
            this.databaseValidationSchema = schema != null && !schema.isEmpty() ? schema : null;
            return this;
        }

        @Override
        public JSqlClient.Builder setAopProxyProvider(AopProxyProvider provider) {
            this.aopProxyProvider = this.aopProxyProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setMicroServiceName(String microServiceName) {
            this.microServiceName = microServiceName != null ? microServiceName : "";
            return this;
        }

        @Override
        public JSqlClient.Builder setMicroServiceExchange(MicroServiceExchange exchange) {
            this.microServiceExchange = exchange;
            return this;
        }

        @Override
        public JSqlClient.Builder setInitializationType(InitializationType type) {
            this.initializationType = type != null ? type : InitializationType.IMMEDIATE;
            return this;
        }

        @Override
        public JSqlClient build() {
            if (!this.microServiceName.isEmpty() && this.microServiceExchange == null) {
                throw new IllegalStateException("The `microServiceExchange` must be configured when `microServiceName` is configured");
            }
            for (Customizer customizer : this.customizers) {
                try {
                    customizer.customize(this);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Failed to execute customizer before create sql client", ex);
                }
            }
            ForeignKeyStrategy foreignKeyStrategy = !this.dialect.isForeignKeySupported() ? ForeignKeyStrategy.FORCED_FAKE : (this.isForeignKeyEnabledByDefault ? ForeignKeyStrategy.REAL : ForeignKeyStrategy.FAKE);
            MetadataStrategy metadataStrategy = new MetadataStrategy(this.databaseNamingStrategy, foreignKeyStrategy);
            this.entityManager().validate(metadataStrategy);
            FilterManager filterManager = this.createFilterManager();
            this.validateAssociations(filterManager);
            this.createTriggers();
            Caches caches = CachesImpl.of(this.cacheConfig, this.microServiceName, this.entityManager(), this.triggers, filterManager);
            BinLogParser binLogParser = new BinLogParser();
            BinLogImpl binLog = new BinLogImpl(this.entityManager(), this.microServiceName, metadataStrategy, binLogParser, this.triggers);
            TransientResolverManager transientResolverManager = new TransientResolverManager(this.transientResolverProvider != null ? this.transientResolverProvider : DefaultTransientResolverProvider.INSTANCE, this.aopProxyProvider);
            SqlClientInitializer sqlClientInitializer = null;
            if (this.initializationType == InitializationType.MANUAL) {
                sqlClientInitializer = new SqlClientInitializer();
            }
            JSqlClientImpl sqlClient = new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, new ScalarProviderManager(this.typeScalarProviderMap, this.propScalarProviderMap, this.serializedTypeObjectMapperMap, this.serializedPropObjectMapperMap, this.defaultEnumStrategy, this.dialect), this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, null, this.entityManager(), caches, this.triggers, this.transactionTriggers, metadataStrategy, binLog, filterManager, this.userIdGeneratorProvider, this.logicalDeletedValueGeneratorProvider, transientResolverManager, this.defaultDissociationActionCheckable, this.idOnlyTargetCheckingLevel, this.saveCommandPessimisticLock, new DraftInterceptorManager(this.interceptors), this.microServiceName, this.microServiceExchange, sqlClientInitializer);
            Runnable initializationAction = () -> {
                CachesImpl.initialize(caches, sqlClient);
                filterManager.initialize(sqlClient);
                binLogParser.initialize(sqlClient, this.binLogObjectMapper, this.binLogPropReaderMap, this.typeBinLogPropReaderMap);
                transientResolverManager.initialize(sqlClient);
                this.triggers.initialize(sqlClient);
                if (this.transactionTriggers != null && this.transactionTriggers != this.triggers) {
                    this.transactionTriggers.initialize(sqlClient);
                }
                for (Initializer initializer : this.initializers) {
                    try {
                        initializer.initialize(sqlClient);
                    }
                    catch (Exception ex) {
                        throw new ExecutionException("Failed to execute initializer after create sql client", ex);
                    }
                }
                this.validateDatabase(metadataStrategy);
            };
            if (sqlClientInitializer != null) {
                sqlClientInitializer.setAction(initializationAction);
            } else {
                initializationAction.run();
            }
            return sqlClient;
        }

        private void createTriggers() {
            if (this.triggers == null) {
                switch (this.triggerType) {
                    case TRANSACTION_ONLY: {
                        this.transactionTriggers = this.triggers = new TriggersImpl(true);
                        break;
                    }
                    case BOTH: {
                        this.triggers = new TriggersImpl(false);
                        this.transactionTriggers = new TriggersImpl(true);
                        break;
                    }
                    default: {
                        this.triggers = new TriggersImpl(false);
                    }
                }
            }
        }

        private FilterManager createFilterManager() {
            return new FilterManager(this.aopProxyProvider, new LogicalDeletedFilterProvider(this.logicalDeletedBehavior, this.entityManager(), this.microServiceName), this.filters, this.disabledFilters);
        }

        private void validateAssociations(FilterManager filterManager) {
            for (ImmutableType type : this.entityManager().getAllTypes(this.microServiceName)) {
                if (!type.isEntity()) continue;
                for (ImmutableProp prop : type.getProps().values()) {
                    if (prop.isNullable() || !filterManager.isNullableRequired(prop)) continue;
                    throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because the target type \"" + prop.getTargetType() + "\" may be handled by some global filters");
                }
            }
        }

        private void validateDatabase(MetadataStrategy metadataStrategy) {
            if (this.databaseValidationMode != DatabaseValidationMode.NONE) {
                ConnectionManager cm = this.connectionManager;
                if (cm == null) {
                    throw new IllegalStateException("The `connectionManager` of must be configured when `validate` is configured");
                }
                DatabaseValidationException validationException = cm.execute(con -> {
                    try {
                        return DatabaseValidators.validate(this.entityManager(), this.microServiceName, this.defaultDissociationActionCheckable, metadataStrategy, this.databaseValidationCatalog, this.databaseValidationSchema, con);
                    }
                    catch (SQLException ex) {
                        throw new ExecutionException("Cannot validate the database because of SQL exception", ex);
                    }
                });
                if (validationException != null) {
                    if (this.databaseValidationMode == DatabaseValidationMode.ERROR) {
                        throw validationException;
                    }
                    LOGGER.warn(validationException.getMessage(), (Throwable)validationException);
                }
            }
        }

        private EntityManager entityManager() {
            EntityManager em = this.userEntityManager;
            if (em == null && (em = this.defaultEntityManager) == null) {
                this.defaultEntityManager = em = EntityManager.fromResources(null, null);
            }
            return em;
        }
    }
}

