/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.AbstractImmutableTypeImpl;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.meta.impl.MetaCache;
import org.babyfish.jimmer.sql.runtime.DissociationInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityManager.class);
    private final ReadWriteLock reloadingLock = new ReentrantReadWriteLock();
    private volatile Data data;

    public EntityManager(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EntityManager(Collection<Class<?>> classes) {
        if (!(classes instanceof Set)) {
            classes = new LinkedHashSet(classes);
        }
        HashSet<String> qualifiedNames = new HashSet<String>();
        for (Class<?> clazz : classes) {
            if (qualifiedNames.add(clazz.getName())) continue;
            throw new IllegalArgumentException("Multiple classes with the same qualified name \"" + clazz.getName() + "\" but belonging to different class loaders cannot be registered into the entity manager");
        }
        Map<ImmutableType, ImmutableTypeInfo> map = new LinkedHashMap<ImmutableType, ImmutableTypeInfo>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            ImmutableType immutableType = ImmutableType.get(clazz);
            if (!immutableType.isEntity()) {
                throw new IllegalArgumentException("\"" + immutableType + "\" is not entity");
            }
            for (Object type : immutableType.getAllTypes()) {
                map.put((ImmutableType)type, new ImmutableTypeInfo());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            ImmutableTypeInfo info = (ImmutableTypeInfo)entry.getValue();
            if (type.isMappedSuperclass()) {
                for (ImmutableType otherType : map.keySet()) {
                    if (!this.isImplementationType(type, otherType)) continue;
                    info.implementationTypes.add(otherType);
                }
                continue;
            }
            for (ImmutableType otherType : map.keySet()) {
                if (type == otherType || !type.isAssignableFrom(otherType)) continue;
                info.allDerivedTypes.add(otherType);
                if (!otherType.getSuperTypes().contains(type)) continue;
                info.directDerivedTypes.add(otherType);
            }
            for (ImmutableProp prop : type.getProps().values()) {
                ImmutableType targetType = prop.getTargetType();
                if (targetType == null || !targetType.isEntity() || prop.isRemote()) continue;
                ImmutableTypeInfo targetInfo = map.get(targetType);
                if (targetInfo == null) {
                    throw new IllegalArgumentException("The target type \"" + targetType + "\" of the non-remote property \"" + prop + "\" is not manged by the current entity manager");
                }
                targetInfo.backProps.add(prop);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((ImmutableType)entry.getKey()).isEntity()) continue;
            ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>();
            ArrayList<ImmutableProp> backProps = new ArrayList<ImmutableProp>();
            boolean hasInverseLocalAssociation = false;
            for (ImmutableProp prop : ((ImmutableType)entry.getKey()).getProps().values()) {
                if (prop.isRemote()) continue;
                if (prop.getMappedBy() != null) {
                    hasInverseLocalAssociation = true;
                    continue;
                }
                if (!prop.isMiddleTableDefinition()) continue;
                props.add(prop);
            }
            if (hasInverseLocalAssociation) {
                for (ImmutableProp backProp : ((ImmutableTypeInfo)entry.getValue()).backProps) {
                    if (backProp.getMappedBy() != null || backProp.isRemote()) continue;
                    if (backProp.isMiddleTableDefinition()) {
                        backProps.add(backProp);
                        continue;
                    }
                    if (!backProp.isReference(TargetLevel.PERSISTENT) || !backProp.isColumnDefinition()) continue;
                    backProps.add(backProp);
                }
            }
            if (props.isEmpty() && backProps.isEmpty()) continue;
            ((ImmutableTypeInfo)entry.getValue()).dissociationInfo = new DissociationInfo(Collections.unmodifiableList(props), Collections.unmodifiableList(backProps));
        }
        for (ImmutableTypeInfo immutableTypeInfo : map.values()) {
            immutableTypeInfo.implementationTypes = Collections.unmodifiableList(immutableTypeInfo.implementationTypes);
            immutableTypeInfo.directDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.directDerivedTypes);
            immutableTypeInfo.allDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.allDerivedTypes);
            immutableTypeInfo.backProps = Collections.unmodifiableList(immutableTypeInfo.backProps.stream().sorted(Comparator.comparing(ImmutableProp::toString)).collect(Collectors.toList()));
        }
        map = Collections.unmodifiableMap(map);
        HashMap<String, ImmutableType> hashMap = new HashMap<String, ImmutableType>((map.size() * 4 + 2) / 3);
        for (ImmutableType type : map.keySet()) {
            hashMap.put(type.getJavaClass().getName(), type);
        }
        this.data = new Data(map, hashMap);
    }

    public static EntityManager combine(EntityManager ... entityManagers) {
        if (entityManagers.length == 0) {
            throw new IllegalArgumentException("No entity managers");
        }
        if (entityManagers.length == 1) {
            return entityManagers[0];
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (EntityManager entityManager : entityManagers) {
            for (ImmutableType type : entityManager.getAllTypes(null)) {
                if (!type.isEntity()) continue;
                classes.add(type.getJavaClass());
            }
        }
        return new EntityManager(classes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EntityManager fromResources(@Nullable ClassLoader classLoader, @Nullable Predicate<Class<?>> predicate) {
        if (classLoader == null) {
            classLoader = EntityManager.class.getClassLoader();
        }
        LinkedHashSet classes = new LinkedHashSet();
        try {
            Enumeration<URL> urls = classLoader.getResources("META-INF/jimmer/entities");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String className;
                    while ((className = reader.readLine()) != null) {
                        Class<?> clazz;
                        if ((className = className.trim()).isEmpty()) continue;
                        try {
                            clazz = Class.forName(className, true, classLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Cannot parse class name \"" + className + "\" in \"META-INF/jimmer/entities\"", ex);
                        }
                        if (predicate != null && !predicate.test(clazz)) continue;
                        classes.add(clazz);
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to load resource \"" + url + "\"", ex);
                    return new EntityManager(classes);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load resources \"META-INF/jimmer/entities\"", ex);
        }
    }

    public Set<ImmutableType> getAllTypes(String microServiceName) {
        if (microServiceName == null) {
            return this.data.map.keySet();
        }
        LinkedHashSet<ImmutableType> set = microServiceName.isEmpty() ? new LinkedHashSet<ImmutableType>((this.data.map.size() * 4 + 2) / 3) : new LinkedHashSet();
        for (ImmutableType type : this.data.map.keySet()) {
            if (!type.getMicroServiceName().equals(microServiceName)) continue;
            set.add(type);
        }
        return set;
    }

    public List<ImmutableType> getImplementationTypes(ImmutableType type) {
        return this.info((ImmutableType)type).implementationTypes;
    }

    public List<ImmutableType> getDirectDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).directDerivedTypes;
    }

    public List<ImmutableType> getAllDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).allDerivedTypes;
    }

    public List<ImmutableProp> getAllBackProps(ImmutableType type) {
        return this.info((ImmutableType)type).backProps;
    }

    @Nullable
    public DissociationInfo getDissociationInfo(ImmutableType type) {
        return this.info((ImmutableType)type).dissociationInfo;
    }

    private ImmutableTypeInfo info(ImmutableType type) {
        ImmutableTypeInfo info = this.data.map.get(type);
        if (info == null) {
            ImmutableType oldType = this.data.typeMapForSpringDevTools.get(type.getJavaClass().getName());
            if (oldType != null) {
                LOGGER.info("You seem to be using spring-dev-tools (or other multi-ClassLoader technology), so that some entity metadata changes but the ORM's entire metadata graph is not updated, now try to reload the EntityManager.");
                try {
                    this.reload(type);
                }
                catch (Error | RuntimeException ex) {
                    throw new IllegalStateException("You seem to be using spring-dev-tools (or other multi-ClassLoader technology), so that some entity metadata changes but the ORM's entire metadata graph is not updated, jimmer try to reload the EntityManager but meet some problem.", ex);
                }
                info = this.data.map.get(type);
            }
            if (info == null) {
                throw new IllegalArgumentException("\"" + type + "\" is not managed by current EntityManager");
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(ImmutableType immutableType) {
        Lock lock = this.reloadingLock.readLock();
        lock.lock();
        try {
            if (this.data.map.containsKey(immutableType)) {
                return;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.reloadingLock.writeLock();
        lock.lock();
        try {
            if (this.data.map.containsKey(immutableType)) {
                return;
            }
            EntityManager newEntityManager = EntityManager.fromResources(immutableType.getJavaClass().getClassLoader(), null);
            this.data = newEntityManager.data;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isImplementationType(ImmutableType mappedSuperClass, ImmutableType type) {
        if (!mappedSuperClass.isMappedSuperclass()) {
            throw new AssertionError((Object)"Internal bug");
        }
        if (!type.isEntity()) {
            return false;
        }
        if (!mappedSuperClass.isAssignableFrom(type)) {
            return false;
        }
        for (ImmutableType superType : type.getSuperTypes()) {
            if (!superType.isMappedSuperclass()) continue;
            return true;
        }
        return false;
    }

    public ImmutableType getTypeByServiceAndTable(String microServiceName, String tableName, MetadataStrategy strategy) {
        Objects.requireNonNull(microServiceName, "`microServiceName` cannot be null");
        tableName = DatabaseIdentifiers.comparableIdentifier((String)Objects.requireNonNull(tableName, "`tableName` cannot be null"));
        try {
            int index;
            do {
                ImmutableType type;
                if ((type = this.getTypeByServiceAndTableImpl(microServiceName, tableName, strategy)) == null) continue;
                return type;
            } while ((index = tableName.indexOf(46)) != -1 && !(tableName = tableName.substring(index + 1)).isEmpty());
        }
        catch (ConflictTableException ex) {
            if (ex.searchedTableName.equals(tableName)) {
                throw new IllegalArgumentException("There are multiple types of tables named \"" + tableName + "\" in microservice \"" + microServiceName + "\": " + ex.conflictTypes);
            }
            throw new IllegalArgumentException("Trying to find the type of the table name \"" + tableName + "\" in microservice \"" + microServiceName + "\" failed, and turned to query table \"" + ex.searchedTableName + "\", but found these conflicting types: " + ex.conflictTypes);
        }
        return null;
    }

    private ImmutableType getTypeByServiceAndTableImpl(String microServiceName, String tableName, MetadataStrategy strategy) throws ConflictTableException {
        Map<Key, Object> typeMap = this.data.getTypeMap(strategy);
        Object result = typeMap.get(new Key(microServiceName, tableName));
        if (result == null) {
            return null;
        }
        if (result instanceof List) {
            throw new ConflictTableException(tableName, (List)result);
        }
        return (ImmutableType)result;
    }

    @NotNull
    public ImmutableType getNonNullTypeByServiceAndTable(String microServiceName, String tableName, MetadataStrategy strategy) {
        ImmutableType type = this.getTypeByServiceAndTable(microServiceName, tableName, strategy);
        if (type == null) {
            throw new IllegalArgumentException("The table \"" + tableName + "\" of micro service \"" + microServiceName + "\" is not managed by current EntityManager");
        }
        return type;
    }

    public void validate(MetadataStrategy strategy) {
        this.data.getTypeMap(strategy);
    }

    private static void tableSharedBy(Key key, ImmutableType type1, ImmutableType type2) {
        if (type1 instanceof AssociationType && type2 instanceof AssociationType) {
            AssociationType associationType1 = (AssociationType)type1;
            AssociationType associationType2 = (AssociationType)type2;
            if (associationType1.getSourceType() == associationType2.getTargetType() && associationType1.getTargetType() == associationType2.getSourceType()) {
                throw new IllegalArgumentException("Illegal entity manager, in the micro-service \"" + key.microServiceName + "\", the table \"" + key.tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\". These two associations seem to form a bidirectional association, if so, please make one of them real (using @" + JoinTable.class + ") and the other image (specify `mappedBy` of @" + ManyToOne.class + ")");
            }
        }
        throw new IllegalArgumentException("Illegal entity manager, in the microservice \"" + key.microServiceName + "\", the table \"" + key.tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\"");
    }

    private static class Key {
        final String microServiceName;
        final String tableName;

        private Key(String microServiceName, String tableName) {
            this.microServiceName = microServiceName;
            this.tableName = tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.microServiceName.equals(key.microServiceName) && this.tableName.equals(key.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.microServiceName, this.tableName);
        }

        public String toString() {
            return "Key{microServiceName='" + this.microServiceName + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }
    }

    private static class ImmutableTypeInfo {
        List<ImmutableType> implementationTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> directDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> allDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableProp> backProps = new ArrayList<ImmutableProp>();
        DissociationInfo dissociationInfo;

        private ImmutableTypeInfo() {
        }
    }

    private static class Data {
        final Map<ImmutableType, ImmutableTypeInfo> map;
        final Map<String, ImmutableType> typeMapForSpringDevTools;
        final MetaCache<Map<Key, Object>> typeMapCache = new MetaCache(this::createTypeMap);

        Data(Map<ImmutableType, ImmutableTypeInfo> map, Map<String, ImmutableType> typeMapForSpringDevTools) {
            this.map = map;
            this.typeMapForSpringDevTools = typeMapForSpringDevTools;
        }

        public Map<Key, Object> getTypeMap(MetadataStrategy strategy) {
            return (Map)this.typeMapCache.get(strategy);
        }

        private Map<Key, Object> createTypeMap(MetadataStrategy strategy) {
            Map<Key, ImmutableType> rawTypeMap = this.createRawTypeMap(strategy);
            HashMap<Key, ImmutableType> typeMap = new HashMap<Key, ImmutableType>(rawTypeMap);
            for (Map.Entry<Key, ImmutableType> e : rawTypeMap.entrySet()) {
                int index;
                String tableName = e.getKey().tableName;
                while ((index = tableName.indexOf(46)) != -1 && !(tableName = tableName.substring(index + 1)).isEmpty()) {
                    Key newKey = new Key(e.getKey().microServiceName, tableName);
                    ImmutableType type = e.getValue();
                    Object oldTypeOrList = typeMap.get(newKey);
                    if (oldTypeOrList instanceof List) {
                        ((List)oldTypeOrList).add(type);
                        continue;
                    }
                    if (oldTypeOrList != null) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(oldTypeOrList);
                        list.add(type);
                        typeMap.put(newKey, (ImmutableType)list);
                        continue;
                    }
                    typeMap.put(newKey, type);
                }
            }
            return typeMap;
        }

        private Map<Key, ImmutableType> createRawTypeMap(MetadataStrategy strategy) {
            HashMap<Key, ImmutableType> typeMap = new HashMap<Key, ImmutableType>();
            for (ImmutableType type : this.map.keySet()) {
                if (!type.isEntity()) continue;
                String tableName = DatabaseIdentifiers.comparableIdentifier((String)type.getTableName(strategy));
                String microServiceName = type.getMicroServiceName();
                Key key = new Key(microServiceName, tableName);
                ImmutableType conflictType = typeMap.put(key, type);
                if (conflictType != null) {
                    EntityManager.tableSharedBy(key, conflictType, type);
                }
                for (ImmutableProp prop : type.getProps().values()) {
                    AssociationType associationType;
                    String associationTableName;
                    if (!prop.isMiddleTableDefinition() || (conflictType = typeMap.put(key = new Key(microServiceName, associationTableName = DatabaseIdentifiers.comparableIdentifier((String)(associationType = AssociationType.of(prop)).getTableName(strategy))), (ImmutableType)associationType)) == null) continue;
                    EntityManager.tableSharedBy(key, conflictType, (ImmutableType)associationType);
                }
            }
            for (ImmutableType type : this.map.keySet()) {
                if (!type.isEntity()) continue;
                ((AbstractImmutableTypeImpl)type).validateColumnUniqueness(strategy);
                for (ImmutableProp prop : type.getProps().values()) {
                    boolean isForeignKey;
                    if (prop.isNullable() || !prop.isReference(TargetLevel.ENTITY) || prop.isTransient()) continue;
                    Storage storage = prop.getStorage(strategy);
                    if (prop.isRemote()) {
                        throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because it is remote association");
                    }
                    if (storage instanceof ColumnDefinition) {
                        isForeignKey = ((ColumnDefinition)storage).isForeignKey();
                        if (isForeignKey) continue;
                        throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because it is based on FAKE foreign key");
                    }
                    if (!(storage instanceof MiddleTable) || (isForeignKey = ((MiddleTable)storage).getTargetColumnDefinition().isForeignKey())) continue;
                    throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because it is based on middle table whose target column is FAKE foreign key");
                }
            }
            for (ImmutableType type : this.map.keySet()) {
                if (!type.isEntity() || type.getSuperTypes().isEmpty()) continue;
                HashMap<String, ImmutableProp> superPropMap = new HashMap<String, ImmutableProp>();
                for (ImmutableType superType : type.getSuperTypes()) {
                    for (ImmutableProp superProp : superType.getProps().values()) {
                        Storage storage2;
                        Storage storage1;
                        ImmutableProp conflictProp = superPropMap.put(superProp.getName(), superProp);
                        if (conflictProp == null || Objects.equals(storage1 = conflictProp.getStorage(strategy), storage2 = superProp.getStorage(strategy))) continue;
                        throw new ModelException("Illegal entity type \"" + type + "\", conflict super properties \"" + conflictProp + "\" and \"" + superProp + "\", the storage of the first one is " + storage1 + " but the storage of the second one is " + storage2);
                    }
                }
            }
            return typeMap;
        }
    }

    private static class ConflictTableException
    extends Exception {
        final String searchedTableName;
        final List<ImmutableType> conflictTypes;

        private ConflictTableException(String searchedTableName, List<ImmutableType> conflictTypes) {
            this.searchedTableName = searchedTableName;
            this.conflictTypes = conflictTypes;
        }
    }
}

