/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.sql.fetcher.Fetcher;

public final class ViewMetadata<E, V extends View<E>> {
    private static final ClassCache<ViewMetadata<?, ?>> cache = new ClassCache(ViewMetadata::create, false);
    private final Fetcher<E> fetcher;
    private final Function<E, V> converter;

    public ViewMetadata(Fetcher<E> fetcher, Function<E, V> converter) {
        this.fetcher = Objects.requireNonNull(fetcher, "fetch cannot be null");
        this.converter = Objects.requireNonNull(converter, "converter cannot be null");
    }

    public Fetcher<E> getFetcher() {
        return this.fetcher;
    }

    public Function<E, V> getConverter() {
        return this.converter;
    }

    public int hashCode() {
        return Objects.hash(this.fetcher, this.converter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewMetadata that = (ViewMetadata)o;
        return this.fetcher.equals(that.fetcher) && this.converter.equals(that.converter);
    }

    public String toString() {
        return "ViewMetadata{fetcher=" + this.fetcher + ", converter=" + this.converter + '}';
    }

    public static <E, V extends View<E>> ViewMetadata<E, V> of(Class<V> viewType) {
        return (ViewMetadata)cache.get(viewType);
    }

    private static ViewMetadata<?, ?> create(Class<?> viewType) {
        Field metadataField;
        if (!View.class.isAssignableFrom(viewType)) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" does not inherit \"" + View.class.getName() + "\"");
        }
        Iterator itr = TypeUtils.getTypeArguments(viewType, View.class).values().iterator();
        if (!itr.hasNext()) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" does not specify the generic parameter of \"" + View.class.getName() + "\"");
        }
        Type type = (Type)itr.next();
        if (!(type instanceof Class) || !((Class)type).isInterface()) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\"illegal, the generic parameter of \"" + View.class.getName() + "\" must be interface");
        }
        Class entityType = (Class)type;
        try {
            metadataField = viewType.getDeclaredField("METADATA");
            if (!Modifier.isStatic(metadataField.getModifiers()) || !Modifier.isFinal(metadataField.getModifiers())) {
                metadataField = null;
            }
        }
        catch (NoSuchFieldException ex) {
            metadataField = null;
        }
        if (metadataField == null) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" is illegal, there is not static final field \"METADATA\"");
        }
        if (metadataField.getType() != ViewMetadata.class) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" is illegal, the type of \"" + metadataField + "\" must be \"" + ViewMetadata.class.getName() + "\"");
        }
        TypeVariable<Class<T>>[] typeParameters = ViewMetadata.class.getTypeParameters();
        Map typeArgumentMap = TypeUtils.getTypeArguments((Type)metadataField.getGenericType(), ViewMetadata.class);
        if (typeArgumentMap.get(typeParameters[0]) != entityType) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" is illegal, the first generic argument of the return type of \"" + metadataField + "\" must be \"" + entityType.getName() + "\"");
        }
        if (typeArgumentMap.get(typeParameters[1]) != viewType) {
            throw new IllegalArgumentException("The type \"" + viewType.getName() + "\" is illegal, the first generic argument of the return type of \"" + metadataField + "\" must be \"" + viewType.getName() + "\"");
        }
        metadataField.setAccessible(true);
        try {
            return (ViewMetadata)metadataField.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError("Internal bug", ex);
        }
    }
}

