/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class MergedTypedRootQueryImpl<R>
implements TypedRootQueryImplementor<R>,
TypedQueryImplementor {
    private final JSqlClientImplementor sqlClient;
    private final String operator;
    private TypedQueryImplementor left;
    private TypedQueryImplementor right;
    private final List<Selection<?>> selections;
    private final boolean isForUpdate;

    public MergedTypedRootQueryImpl(JSqlClientImplementor sqlClient, String operator, TypedRootQuery<R> left, TypedRootQuery<R> right) {
        this.sqlClient = sqlClient;
        this.operator = operator;
        this.left = (TypedQueryImplementor)((Object)left);
        this.right = (TypedQueryImplementor)((Object)right);
        this.selections = MergedTypedRootQueryImpl.mergedSelections(this.left.getSelections(), this.right.getSelections());
        this.isForUpdate = ((TypedRootQueryImplementor)left).isForUpdate() || ((TypedRootQueryImplementor)right).isForUpdate();
    }

    @Override
    public List<R> execute() {
        return this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(this::executeImpl);
    }

    @Override
    public List<R> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        return Selectors.select(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.selections, ExecutionPurpose.QUERY);
    }

    @Override
    public <X> List<X> map(Connection con, Function<R, X> mapper) {
        Object rows = this.execute(con);
        ArrayList<X> mapped = new ArrayList<X>(rows.size());
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            Object row = iterator.next();
            mapped.add(mapper.apply(row));
        }
        return mapped;
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        int finalBatchSize;
        int n = finalBatchSize = batchSize > 0 ? batchSize : this.sqlClient.getDefaultBatchSize();
        if (con != null) {
            this.forEachImpl(con, finalBatchSize, consumer);
        } else {
            this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute((Connection newConn) -> {
                this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
                return null;
            });
        }
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        Selectors.forEach(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.selections, ExecutionPurpose.QUERY, batchSize, consumer);
    }

    private Tuple3<String, List<Object>, List<Integer>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder.getAstContext());
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.left.accept(visitor);
        this.right.accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.enter('?' + this.operator + '?');
        this.left.renderTo(builder);
        builder.separator();
        this.right.renderTo(builder);
        builder.leave();
    }

    @Override
    public boolean hasVirtualPredicate() {
        return this.left.hasVirtualPredicate() || this.right.hasVirtualPredicate();
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        this.left = ctx.resolveVirtualPredicate(this.left);
        this.right = ctx.resolveVirtualPredicate(this.right);
        return this;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "intersect", this, other);
    }

    private static List<Selection<?>> mergedSelections(List<Selection<?>> list1, List<Selection<?>> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        int size = list1.size();
        for (int index = 0; index < size; ++index) {
            if (MergedTypedRootQueryImpl.isSameType(list1.get(index), list2.get(index))) continue;
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        return list1;
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof Table && b instanceof Table) {
            return ((Table)a).getImmutableType() == ((Table)b).getImmutableType();
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }
}

