/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class InSubQueryPredicate
extends AbstractPredicate {
    private Expression<?> expression;
    private TypedSubQuery<?> subQuery;
    private final boolean negative;

    public InSubQueryPredicate(Expression<?> expression, TypedSubQuery<?> subQuery, boolean negative) {
        this.expression = expression;
        this.subQuery = subQuery;
        this.negative = negative;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Predicate not() {
        return new InSubQueryPredicate(this.expression, this.subQuery, !this.negative);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
        ((Ast)((Object)this.subQuery)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderChild((Ast)((Object)this.expression), builder);
        builder.sql(this.negative ? " not in " : " in ");
        this.renderChild((Ast)((Object)this.subQuery), builder);
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return InSubQueryPredicate.hasVirtualPredicate(this.expression) || InSubQueryPredicate.hasVirtualPredicate(this.subQuery);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        this.subQuery = ctx.resolveVirtualPredicate(this.subQuery);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InSubQueryPredicate)) {
            return false;
        }
        InSubQueryPredicate that = (InSubQueryPredicate)o;
        return this.negative == that.negative && this.expression.equals(that.expression) && this.subQuery.equals(that.subQuery);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.subQuery, this.negative);
    }
}

