/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class Constants {
    public static <N extends Number> NumericExpression<N> number(N value) {
        return new Num<N>(value);
    }

    private static class Num<N extends Number>
    extends AbstractExpression<N>
    implements NumericExpressionImplementor<N> {
        private N value;

        public Num(N value) {
            this.value = (Number)Objects.requireNonNull(value, "`value` cannot be null");
        }

        @Override
        public Class<N> getType() {
            return this.value.getClass();
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder) {
            builder.sql(this.value.toString());
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return false;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            return this;
        }

        @Override
        public int precedence() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Num num = (Num)o;
            return this.value.equals(num.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

