/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.math.BigDecimal;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.TupleExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

abstract class AggregationExpression<T>
extends AbstractExpression<T> {
    Expression<?> expression;

    public AggregationExpression(Expression<?> expression) {
        this.expression = expression;
    }

    protected abstract String functionName();

    protected String prefix() {
        return null;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitAggregation(this.functionName(), this.expression, this.prefix());
    }

    @Override
    public final void renderTo(@NotNull SqlBuilder builder) {
        this.validate(builder.getAstContext().getSqlClient());
        builder.sql(this.functionName());
        builder.sql("(");
        String prefix = this.prefix();
        if (prefix != null) {
            builder.sql(prefix);
            builder.sql(" ");
        }
        this.renderExpression(builder);
        builder.sql(")");
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return AggregationExpression.hasVirtualPredicate(this.expression);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        return this;
    }

    private void validate(JSqlClientImplementor sqlClient) {
        if (!sqlClient.getDialect().isTupleCountSupported()) {
            if (this.expression instanceof PropExpression) {
                PropExpressionImpl propExpr = (PropExpressionImpl)this.expression;
                EmbeddedColumns.Partial partial = propExpr.getPartial(sqlClient.getMetadataStrategy());
                if (partial != null && partial.size() > 1) {
                    throw new IllegalArgumentException("The `count` function does not support embedded property because multiple columns `count` is not supported by current dialect \"" + sqlClient.getDialect().getClass().getName() + "\"");
                }
            } else if (this.expression instanceof TupleExpressionImplementor) {
                throw new IllegalArgumentException("The `count` function does not support tuple expression because multiple columns `count` is not supported by current dialect \"" + sqlClient.getDialect().getClass().getName() + "\"");
            }
        }
    }

    protected void renderExpression(@NotNull SqlBuilder builder) {
        this.renderChild((Ast)((Object)this.expression), builder);
    }

    @Override
    public int precedence() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationExpression that = (AggregationExpression)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    static class Avg
    extends AggregationExpression<BigDecimal>
    implements NumericExpressionImplementor<BigDecimal> {
        public Avg(Expression<? extends Number> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "avg";
        }

        @Override
        public Class<BigDecimal> getType() {
            return BigDecimal.class;
        }
    }

    static class Max<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Max(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "max";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class Min<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Min(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "min";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class Sum<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Sum(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "sum";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class CountDistinct
    extends Count {
        public CountDistinct(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String prefix() {
            return "distinct";
        }

        @Override
        protected void renderExpression(@NotNull SqlBuilder builder) {
            if (builder.getAstContext().getSqlClient().getDialect().isTupleCountSupported()) {
                if (this.expression instanceof PropExpressionImplementor) {
                    ((PropExpressionImplementor)this.expression).renderTo(builder, true);
                    return;
                }
                if (this.expression instanceof TupleExpressionImplementor) {
                    ((TupleExpressionImplementor)this.expression).renderTo(builder, true);
                    return;
                }
            }
            super.renderExpression(builder);
        }
    }

    static class Count
    extends AggregationExpression<Long>
    implements NumericExpressionImplementor<Long> {
        public Count(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "count";
        }

        @Override
        public Class<Long> getType() {
            return Long.class;
        }
    }
}

