/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.Collection;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.Constants;
import org.babyfish.jimmer.sql.ast.impl.ExpressionFactories;
import org.babyfish.jimmer.sql.ast.impl.SimpleCaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressionContext;
import org.babyfish.jimmer.sql.ast.impl.Tuples;
import org.babyfish.jimmer.sql.ast.impl.util.RowCounts;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;

public interface Expression<T>
extends Selection<T> {
    public Predicate eq(Expression<T> var1);

    public Predicate eq(T var1);

    public Predicate ne(Expression<T> var1);

    public Predicate ne(T var1);

    public Predicate isNull();

    public Predicate isNotNull();

    public Predicate in(Collection<T> var1);

    public Predicate notIn(Collection<T> var1);

    public Predicate in(TypedSubQuery<T> var1);

    public Predicate notIn(TypedSubQuery<T> var1);

    public NumericExpression<Long> count();

    public NumericExpression<Long> count(boolean var1);

    public Expression<T> coalesce(T var1);

    public Expression<T> coalesce(Expression<T> var1);

    public CoalesceBuilder<T> coalesceBuilder();

    public Order asc();

    public Order desc();

    public static <N extends Number> NumericExpression<N> constant(N value) {
        return Constants.number(value);
    }

    public static NumericExpression<Long> rowCount() {
        return RowCounts.INSTANCE;
    }

    public static StringFactory string() {
        return ExpressionFactories.of(StringFactory.class);
    }

    public static NumericFactory numeric() {
        return ExpressionFactories.of(NumericFactory.class);
    }

    public static ComparableFactory comparable() {
        return ExpressionFactories.of(ComparableFactory.class);
    }

    public static AnyFactory any() {
        return ExpressionFactories.of(AnyFactory.class);
    }

    public static <T> Expression<T> nullValue(Class<T> type) {
        return Expression.any().nullValue(type);
    }

    public static <T1, T2> Expression<Tuple2<T1, T2>> tuple(Expression<T1> expr1, Expression<T2> expr2) {
        return new Tuples.Expr2<T1, T2>(expr1, expr2);
    }

    public static <T1, T2, T3> Expression<Tuple3<T1, T2, T3>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3) {
        return new Tuples.Expr3<T1, T2, T3>(expr1, expr2, expr3);
    }

    public static <T1, T2, T3, T4> Expression<Tuple4<T1, T2, T3, T4>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4) {
        return new Tuples.Expr4<T1, T2, T3, T4>(expr1, expr2, expr3, expr4);
    }

    public static <T1, T2, T3, T4, T5> Expression<Tuple5<T1, T2, T3, T4, T5>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5) {
        return new Tuples.Expr5<T1, T2, T3, T4, T5>(expr1, expr2, expr3, expr4, expr5);
    }

    public static <T1, T2, T3, T4, T5, T6> Expression<Tuple6<T1, T2, T3, T4, T5, T6>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6) {
        return new Tuples.Expr6<T1, T2, T3, T4, T5, T6>(expr1, expr2, expr3, expr4, expr5, expr6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Expression<Tuple7<T1, T2, T3, T4, T5, T6, T7>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7) {
        return new Tuples.Expr7<T1, T2, T3, T4, T5, T6, T7>(expr1, expr2, expr3, expr4, expr5, expr6, expr7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Expression<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7, Expression<T8> expr8) {
        return new Tuples.Expr8<T1, T2, T3, T4, T5, T6, T7, T8>(expr1, expr2, expr3, expr4, expr5, expr6, expr7, expr8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Expression<Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> tuple(Expression<T1> expr1, Expression<T2> expr2, Expression<T3> expr3, Expression<T4> expr4, Expression<T5> expr5, Expression<T6> expr6, Expression<T7> expr7, Expression<T8> expr8, Expression<T9> expr9) {
        return new Tuples.Expr9<T1, T2, T3, T4, T5, T6, T7, T8, T9>(expr1, expr2, expr3, expr4, expr5, expr6, expr7, expr8, expr9);
    }

    public static interface StringFactory {
        public StringExpression value(String var1);

        public StringExpression sql(String var1);

        public StringExpression sql(String var1, Expression<?> var2, Object ... var3);

        public StringExpression sql(String var1, Expression<?>[] var2, Object ... var3);

        public StringExpression sql(String var1, Consumer<SqlExpressionContext> var2);

        public <C> SimpleCaseBuilder.Str<C> caseBuilder(C var1);

        public <C> SimpleCaseBuilder.Str<C> caseBuilder(Expression<C> var1);

        public CaseBuilder.Str caseBuilder();
    }

    public static interface NumericFactory {
        public <N extends Number> NumericExpression<N> value(N var1);

        public <N extends Number> NumericExpression<N> sql(Class<N> var1, String var2);

        public <N extends Number> NumericExpression<N> sql(Class<N> var1, String var2, Expression<?> var3, Object ... var4);

        public <N extends Number> NumericExpression<N> sql(Class<N> var1, String var2, Expression<?>[] var3, Object ... var4);

        public <N extends Number> NumericExpression<N> sql(Class<N> var1, String var2, Consumer<SqlExpressionContext> var3);

        public <C, N extends Number> SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> var1, C var2);

        public <C, N extends Number> SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> var1, Expression<C> var2);

        public <N extends Number> CaseBuilder.Num<N> caseBuilder(Class<N> var1);
    }

    public static interface ComparableFactory {
        public <T extends Comparable<?>> ComparableExpression<T> value(T var1);

        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> var1, String var2);

        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> var1, String var2, Expression<?> var3, Object ... var4);

        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> var1, String var2, Expression<?>[] var3, Object ... var4);

        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> var1, String var2, Consumer<SqlExpressionContext> var3);

        public <C, T extends Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, C var2);

        public <C, T extends Comparable<?>> SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        public <T extends Comparable<?>> CaseBuilder.Cmp<T> caseBuilder(Class<T> var1);
    }

    public static interface AnyFactory {
        public <T> Expression<T> value(T var1);

        public <T> Expression<T> nullValue(Class<T> var1);

        public <T> Expression<T> sql(Class<T> var1, String var2);

        public <T> Expression<T> sql(Class<T> var1, String var2, Expression<?> var3, Object ... var4);

        public <T> Expression<T> sql(Class<T> var1, String var2, Expression<?>[] var3, Object ... var4);

        public <T> Expression<T> sql(Class<T> var1, String var2, Consumer<SqlExpressionContext> var3);

        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> var1, C var2);

        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> var1, Expression<C> var2);

        public <T> CaseBuilder<T> caseBuilder(Class<T> var1);
    }
}

