/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftHandler;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DraftHandlerManager {
    private final Map<ImmutableType, List<DraftHandler<?, ?>>> handlerMap;
    private final TypeCache<DraftHandler<?, ?>> cache = new TypeCache(this::create, true);

    DraftHandlerManager(Collection<DraftHandler<?, ?>> handlers) {
        HashMap handlerMap = new HashMap();
        for (DraftHandler<?, ?> handler : handlers) {
            if (handler == null) continue;
            DraftInterceptor<?> interceptor = DraftInterceptor.unwrap(handler);
            Object derivedObject = interceptor != null ? interceptor : handler;
            Class baseType = interceptor != null ? DraftInterceptor.class : DraftHandler.class;
            Collection types = TypeUtils.getTypeArguments(derivedObject.getClass(), baseType).values();
            if (types.isEmpty()) {
                throw new IllegalArgumentException("Illegal type \"" + derivedObject.getClass().getName() + "\", it extends \"" + baseType.getName() + "\" but the generic type is not specified");
            }
            Type draftType = (Type)types.iterator().next();
            if (!(draftType instanceof Class) || !((Class)draftType).isInterface()) {
                throw new IllegalArgumentException("Illegal draft type \"" + derivedObject.getClass().getName() + "\", it extends \"" + baseType.getName() + "\" but the generic type is not draft interface type");
            }
            ImmutableType immutableType = ImmutableType.get((Class)((Class)draftType));
            handlerMap.computeIfAbsent(immutableType, it -> new ArrayList()).add(handler);
        }
        this.handlerMap = handlerMap;
    }

    public DraftHandler<?, ?> get(ImmutableType type) {
        return (DraftHandler)this.cache.get(type);
    }

    private DraftHandler<?, ?> create(ImmutableType type) {
        final ArrayList handlers = new ArrayList();
        Set allTypes = type.getAllTypes();
        for (ImmutableType t : allTypes) {
            List<DraftHandler<?, ?>> list = this.handlerMap.get(t);
            if (list == null) continue;
            handlers.addAll(list);
        }
        if (handlers.isEmpty()) {
            return null;
        }
        final LinkedHashSet<ImmutableProp> dependencies = new LinkedHashSet<ImmutableProp>();
        for (DraftHandler draftHandler : handlers) {
            for (ImmutableProp prop : draftHandler.dependencies()) {
                if (!prop.isColumnDefinition()) {
                    throw new IllegalArgumentException("Illegal draft handler type \"" + draftHandler.getClass().getName() + "\", its \"dependencies\" contains the property \"" + prop + "\" which is not column definition");
                }
                if (!allTypes.contains(prop.getDeclaringType())) {
                    throw new IllegalArgumentException("Illegal draft handler type \"" + draftHandler.getClass().getName() + "\", its \"dependencies\" contains the property \"" + prop + "\" which is not belong to the type \"" + type + "\"");
                }
                if (prop.isId()) continue;
                dependencies.add(prop);
            }
        }
        return new DraftHandler<Draft, ImmutableSpi>(){

            @Override
            public void beforeSave(@NotNull Draft draft, @Nullable ImmutableSpi original) {
                for (DraftHandler handler : handlers) {
                    handler.beforeSave(draft, original);
                }
            }

            @Override
            public Collection<ImmutableProp> dependencies() {
                return dependencies;
            }
        };
    }
}

