/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.cache.ParameterizedLocatedCacheImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocatedCacheImpl<K, V>
implements LocatedCache<K, V> {
    private static final ThreadLocal<Set<LocatedCache<?, ?>>> LOADING_CACHES_LOCAL = new ThreadLocal();
    protected final Cache<K, V> raw;
    private final ImmutableType type;
    private final ImmutableProp prop;
    private final CacheOperator operator;

    public LocatedCacheImpl(Cache<K, V> raw, ImmutableType type, ImmutableProp prop, CacheOperator operator) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("The nullity of type and prop must be different");
        }
        if (prop != null && !prop.isAssociation(TargetLevel.PERSISTENT) && !prop.hasTransientResolver()) {
            throw new IllegalArgumentException("The prop \"" + prop + "\" is neither entity association nor transient property with resolver");
        }
        this.raw = Objects.requireNonNull(raw, "raw cannot be null");
        this.type = type;
        this.prop = prop;
        this.operator = operator;
    }

    public static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableType type, CacheOperator operator) {
        return LocatedCacheImpl.wrap(cache, type, null, operator);
    }

    public static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableProp prop, CacheOperator operator) {
        return LocatedCacheImpl.wrap(cache, null, prop, operator);
    }

    private static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableType type, ImmutableProp prop, CacheOperator operator) {
        if (cache == null) {
            return null;
        }
        if (cache instanceof LocatedCache) {
            LocatedCacheImpl wrapper = (LocatedCacheImpl)cache;
            if (wrapper.type == type && wrapper.prop == prop) {
                return wrapper;
            }
            cache = ((LocatedCacheImpl)cache).raw;
        }
        if (cache instanceof Cache.Parameterized) {
            return new ParameterizedLocatedCacheImpl((Cache.Parameterized)cache, type, prop, operator);
        }
        return new LocatedCacheImpl<K, V>(cache, type, prop, operator);
    }

    public static <K, V> LocatedCache<K, V> export(LocatedCache<K, V> cache) {
        Set<LocatedCache<?, ?>> disabledCaches;
        if (cache != null && (disabledCaches = LOADING_CACHES_LOCAL.get()) != null && disabledCaches.contains(cache)) {
            return null;
        }
        return cache;
    }

    public static <K, V> Cache<K, V> unwrap(Cache<K, V> cache) {
        if (cache instanceof LocatedCacheImpl) {
            LocatedCacheImpl wrapper = (LocatedCacheImpl)cache;
            return wrapper.raw;
        }
        return cache;
    }

    @Override
    public ImmutableType getType() {
        return this.type;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public Class<K> getKeyClass() {
        if (this.type != null) {
            return this.type.getIdProp().getElementClass();
        }
        return this.prop.getDeclaringType().getIdProp().getElementClass();
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull CacheEnvironment<K, V> env) {
        return this.loading(() -> {
            Map<K, V> valueMap = this.raw.getAll(keys, env);
            for (V value : valueMap.values()) {
                this.validateResult(value);
            }
            return valueMap;
        });
    }

    @Override
    public void delete(@NotNull K key) {
        if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.delete(key);
        } else {
            this.operator.delete(this, key, null);
        }
    }

    @Override
    public void delete(@NotNull K key, Object reason) {
        if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.delete(key, reason);
        } else {
            this.operator.delete(this, key, reason);
        }
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            this.delete(keys.iterator().next());
        } else if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.deleteAll(keys);
        } else {
            this.operator.deleteAll(this, keys, null);
        }
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys, @Nullable Object reason) {
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            this.delete(keys.iterator().next(), reason);
        } else if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.deleteAll(keys, reason);
        } else {
            this.operator.deleteAll(this, keys, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R loading(Supplier<R> block) {
        Set<LocatedCache<?, ?>> disabledCaches = LOADING_CACHES_LOCAL.get();
        if (disabledCaches == null) {
            disabledCaches = new HashSet();
            LOADING_CACHES_LOCAL.set(disabledCaches);
        }
        disabledCaches.add(this);
        try {
            R r = block.get();
            return r;
        }
        finally {
            if (disabledCaches.size() > 1) {
                disabledCaches.remove(this);
            } else {
                LOADING_CACHES_LOCAL.remove();
            }
        }
    }

    protected void validateResult(Object result) {
        if (result == null) {
            if (this.prop != null && !this.prop.isReferenceList(TargetLevel.OBJECT) && !this.prop.isNullable()) {
                throw new IllegalArgumentException("Property cache for \"" + this.prop + "\" must return non-null value");
            }
        } else if (this.prop == null) {
            if (!(result instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("Object cache for \"" + this.type + "\" must return object");
            }
            if (result instanceof Draft) {
                throw new IllegalArgumentException("Object cache for \"" + this.type + "\" cannot return draft");
            }
        } else if (this.prop.isReferenceList(TargetLevel.OBJECT)) {
            if (!(result instanceof List)) {
                throw new IllegalArgumentException("Association id list cache for \"" + this.prop + "\" must return list");
            }
            List rows = (List)result;
            for (Object row : rows) {
                if (!(row instanceof ImmutableSpi) && !(row instanceof List)) continue;
                throw new IllegalArgumentException("Association id list cache for \"" + this.prop + "\" returns a list but some elements are not simple id values");
            }
        } else if (result instanceof ImmutableSpi || result instanceof List) {
            throw new IllegalArgumentException("Property cache for \"" + this.prop + "\" must return simple value");
        }
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.type, this.prop);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocatedCacheImpl that = (LocatedCacheImpl)o;
        return this.raw.equals(that.raw) && Objects.equals(this.type, that.type) && Objects.equals(this.prop, that.prop);
    }

    public String toString() {
        return "CacheWrapper{raw=" + this.raw + ", type=" + this.type + ", prop=" + this.prop + '}';
    }
}

