/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.babyfish.jimmer.client.ApiIgnore;
import org.babyfish.jimmer.error.CodeBasedRuntimeException;
import org.babyfish.jimmer.internal.ClientException;
import org.babyfish.jimmer.sql.runtime.ExportedSavePath;
import org.babyfish.jimmer.sql.runtime.SaveErrorCode;
import org.babyfish.jimmer.sql.runtime.SavePath;
import org.jetbrains.annotations.NotNull;

@ClientException(family="SAVE_COMMAND", subTypes={NullTarget.class, IllegalTargetId.class, CannotDissociateTarget.class, NoIdGenerator.class, IllegalIdGenerator.class, IllegalGeneratedId.class, EmptyObject.class, NoKeyProps.class, NoNonIdProps.class, NoVersion.class, OptimisticLockError.class, KeyNotUnique.class, NeitherIdNorKey.class, ReversedRemoteAssociation.class, LongRemoteAssociation.class, FailedRemoteValidation.class, UnstructuredAssociation.class})
public abstract class SaveException
extends CodeBasedRuntimeException {
    private final ExportedSavePath exportedPath;
    private SavePath path;

    public SaveException(@NotNull SavePath path, String message) {
        super(message == null || message.isEmpty() ? "Save error caused by the path: \"" + path + "\"" : "Save error caused by the path: \"" + path + "\": " + message, null);
        this.path = path;
        this.exportedPath = path.export();
    }

    public SaveException(@NotNull ExportedSavePath path, String message) {
        super(message, null);
        this.exportedPath = path;
    }

    @JsonIgnore
    public abstract SaveErrorCode getSaveErrorCode();

    @NotNull
    public ExportedSavePath getExportedPath() {
        return this.exportedPath;
    }

    @ApiIgnore
    @NotNull
    public SavePath getPath() {
        SavePath sp = this.path;
        if (sp == null) {
            this.path = sp = SavePath.of(this.exportedPath);
        }
        return sp;
    }

    @NotNull
    public Map<String, Object> getFields() {
        return Collections.singletonMap("path", this.exportedPath);
    }

    @ClientException(code="UNSTRUCTURED_ASSOCIATION")
    public static class UnstructuredAssociation
    extends SaveException {
        public UnstructuredAssociation(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public UnstructuredAssociation(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.UNSTRUCTURED_ASSOCIATION;
        }
    }

    @ClientException(code="FAILED_REMOTE_VALIDATION")
    public static class FailedRemoteValidation
    extends SaveException {
        public FailedRemoteValidation(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public FailedRemoteValidation(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.FAILED_REMOTE_VALIDATION;
        }
    }

    @ClientException(code="LONG_REMOTE_ASSOCIATION")
    public static class LongRemoteAssociation
    extends SaveException {
        public LongRemoteAssociation(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public LongRemoteAssociation(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.LONG_REMOTE_ASSOCIATION;
        }
    }

    @ClientException(code="REVERSED_REMOTE_ASSOCIATION")
    public static class ReversedRemoteAssociation
    extends SaveException {
        public ReversedRemoteAssociation(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public ReversedRemoteAssociation(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.REVERSED_REMOTE_ASSOCIATION;
        }
    }

    @ClientException(code="NEITHER_ID_NOR_KEY")
    public static class NeitherIdNorKey
    extends SaveException {
        public NeitherIdNorKey(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NeitherIdNorKey(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NEITHER_ID_NOR_KEY;
        }
    }

    @ClientException(code="KEY_NOT_UNIQUE")
    public static class KeyNotUnique
    extends SaveException {
        public KeyNotUnique(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public KeyNotUnique(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.KEY_NOT_UNIQUE;
        }
    }

    @ClientException(code="OPTIMISTIC_LOCK_ERROR")
    public static class OptimisticLockError
    extends SaveException {
        public OptimisticLockError(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public OptimisticLockError(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.OPTIMISTIC_LOCK_ERROR;
        }
    }

    @ClientException(code="NO_VERSION")
    public static class NoVersion
    extends SaveException {
        public NoVersion(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NoVersion(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NO_VERSION;
        }
    }

    @ClientException(code="NO_NON_ID_PROPS")
    public static class NoNonIdProps
    extends SaveException {
        public NoNonIdProps(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NoNonIdProps(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NO_NON_ID_PROPS;
        }
    }

    @ClientException(code="NO_KEY_PROPS")
    public static class NoKeyProps
    extends SaveException {
        public NoKeyProps(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NoKeyProps(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NO_KEY_PROPS;
        }
    }

    @ClientException(code="EMPTY_OBJECT")
    public static class EmptyObject
    extends SaveException {
        public EmptyObject(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public EmptyObject(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.EMPTY_OBJECT;
        }
    }

    @ClientException(code="ILLEGAL_GENERATED_ID")
    public static class IllegalGeneratedId
    extends SaveException {
        public IllegalGeneratedId(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public IllegalGeneratedId(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.ILLEGAL_GENERATED_ID;
        }
    }

    @ClientException(code="ILLEGAL_ID_GENERATOR")
    public static class IllegalIdGenerator
    extends SaveException {
        public IllegalIdGenerator(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public IllegalIdGenerator(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.ILLEGAL_ID_GENERATOR;
        }
    }

    @ClientException(code="NO_ID_GENERATOR")
    public static class NoIdGenerator
    extends SaveException {
        public NoIdGenerator(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NoIdGenerator(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NO_ID_GENERATOR;
        }
    }

    @ClientException(code="CANNOT_DISSOCIATE_TARGETS")
    public static class CannotDissociateTarget
    extends SaveException {
        public CannotDissociateTarget(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public CannotDissociateTarget(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.CANNOT_DISSOCIATE_TARGETS;
        }
    }

    @ClientException(code="ILLEGAL_TARGET_ID")
    public static class IllegalTargetId
    extends SaveException {
        public IllegalTargetId(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public IllegalTargetId(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.ILLEGAL_TARGET_ID;
        }
    }

    @ClientException(code="NULL_TARGET")
    public static class NullTarget
    extends SaveException {
        public NullTarget(@NotNull SavePath path, String message) {
            super(path, message);
        }

        public NullTarget(@NotNull ExportedSavePath path, String message) {
            super(path, message);
        }

        @Override
        @JsonIgnore
        public SaveErrorCode getSaveErrorCode() {
            return SaveErrorCode.NULL_TARGET;
        }
    }
}

