/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.Collections;
import java.util.Map;
import org.babyfish.jimmer.error.CodeBasedRuntimeException;
import org.babyfish.jimmer.sql.runtime.ExportedSavePath;
import org.babyfish.jimmer.sql.runtime.SaveErrorCode;
import org.babyfish.jimmer.sql.runtime.SavePath;
import org.jetbrains.annotations.NotNull;

public class SaveException
extends CodeBasedRuntimeException {
    private final SaveErrorCode code;
    private final ExportedSavePath exportedPath;
    private SavePath path;

    public SaveException(@NotNull SaveErrorCode code, @NotNull SavePath path, String message) {
        super(message == null || message.isEmpty() ? "Save error caused by the path: \"" + path + "\"" : "Save error caused by the path: \"" + path + "\": " + message, null);
        this.code = code;
        this.path = path;
        this.exportedPath = path.export();
    }

    public SaveException(@NotNull SaveErrorCode code, @NotNull ExportedSavePath path, String message) {
        super(message, null);
        this.code = code;
        this.exportedPath = path;
    }

    @NotNull
    public SaveErrorCode getCode() {
        return this.code;
    }

    @NotNull
    public ExportedSavePath getExportedPath() {
        return this.exportedPath;
    }

    @NotNull
    public SavePath getPath() {
        SavePath sp = this.path;
        if (sp == null) {
            this.path = sp = SavePath.of(this.exportedPath);
        }
        return sp;
    }

    @NotNull
    public Map<String, Object> getFields() {
        return Collections.singletonMap("path", this.exportedPath);
    }
}

