/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query.specification;

import java.util.Collection;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;

public class PredicateApplier {
    private Context context;

    public PredicateApplier(MutableQuery query) {
        AbstractMutableStatementImpl statement = (AbstractMutableStatementImpl)((Object)query);
        this.context = new Context(null, statement, null);
    }

    public void push(ImmutableProp prop) {
        Context ctx = this.context;
        if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("\"" + prop + "\" is not association property");
        }
        this.context = new Context(ctx, prop.isReference(TargetLevel.PERSISTENT) ? ctx.statement() : null, prop);
    }

    public void pop() {
        Context ctx = this.context;
        Context parentCtx = ctx.parent;
        if (parentCtx == null) {
            throw new IllegalStateException("No context to be pop");
        }
        this.context = parentCtx;
    }

    public AbstractMutableStatementImpl getQuery() {
        return this.context.statement();
    }

    public void eq(ImmutableProp[] props, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().get(props[i]).eq(value);
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void ne(ImmutableProp prop, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        ctx.statement().where(ctx.table().get(prop).ne(value));
    }

    public void gt(ImmutableProp prop, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        ComparableExpression expr = (ComparableExpression)((Object)ctx.table().get(prop));
        ctx.statement().where(expr.gt((Comparable)value));
    }

    public void ge(ImmutableProp prop, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        ComparableExpression expr = (ComparableExpression)((Object)ctx.table().get(prop));
        ctx.statement().where(expr.ge((Comparable)value));
    }

    public void lt(ImmutableProp prop, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        ComparableExpression expr = (ComparableExpression)((Object)ctx.table().get(prop));
        ctx.statement().where(expr.lt((Comparable)value));
    }

    public void le(ImmutableProp prop, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        ComparableExpression expr = (ComparableExpression)((Object)ctx.table().get(prop));
        ctx.statement().where(expr.le((Comparable)value));
    }

    public void isNull(ImmutableProp[] props, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().get(props[i]).isNull();
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void isNotNull(ImmutableProp[] props, Object value) {
        if (value == null) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().get(props[i]).isNotNull();
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void like(ImmutableProp[] props, String value, boolean insensitive, boolean matchStart, boolean matchEnd) {
        if (value == null || value.isEmpty()) {
            return;
        }
        LikeMode mode = matchStart && matchEnd ? LikeMode.EXACT : (matchStart ? LikeMode.START : (matchEnd ? LikeMode.END : LikeMode.ANYWHERE));
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = insensitive ? ((StringExpression)((Object)ctx.table().get(props[i]))).ilike(value, mode) : ((StringExpression)((Object)ctx.table().get(props[i]))).like(value, mode);
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void notLike(ImmutableProp prop, String value, boolean insensitive, boolean matchStart, boolean matchEnd) {
        if (value == null || value.isEmpty()) {
            return;
        }
        LikeMode mode = matchStart && matchEnd ? LikeMode.EXACT : (matchStart ? LikeMode.START : (matchEnd ? LikeMode.END : LikeMode.ANYWHERE));
        Context ctx = this.context;
        Predicate predicate = insensitive ? ((StringExpression)((Object)ctx.table().get(prop))).ilike(value, mode) : ((StringExpression)((Object)ctx.table().get(prop))).like(value, mode);
        ctx.statement().where(Predicate.not(predicate));
    }

    public void valueIn(ImmutableProp[] props, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().get(props[i]).in(values);
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void valueNotIn(ImmutableProp prop, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Context ctx = this.context;
        ctx.statement().where(ctx.table().get(prop).notIn(values));
    }

    public void associatedIdEq(ImmutableProp[] props, Object associatedId) {
        if (associatedId == null) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().getAssociatedId(props[i]).eq(associatedId);
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void associatedIdNe(ImmutableProp prop, Object associatedId) {
        if (associatedId == null) {
            return;
        }
        Context ctx = this.context;
        ctx.statement().where(ctx.table().getAssociatedId(prop).ne(associatedId));
    }

    public void associatedIdIn(ImmutableProp[] props, Collection<?> associatedIds) {
        if (associatedIds == null || associatedIds.isEmpty()) {
            return;
        }
        Context ctx = this.context;
        Predicate[] predicates = new Predicate[props.length];
        for (int i = predicates.length - 1; i >= 0; --i) {
            predicates[i] = ctx.table().getAssociatedId(props[i]).in(associatedIds);
        }
        ctx.statement().where(Predicate.or(predicates));
    }

    public void associatedIdNotIn(ImmutableProp prop, Collection<?> associatedIds) {
        if (associatedIds == null || associatedIds.isEmpty()) {
            return;
        }
        Context ctx = this.context;
        ctx.statement().where(ctx.table().getAssociatedId(prop).notIn(associatedIds));
    }

    private static class Context {
        final Context parent;
        private AbstractMutableStatementImpl _statement;
        final ImmutableProp prop;
        private Table<?> _table;

        Context(Context parent, AbstractMutableStatementImpl statement, ImmutableProp prop) {
            this.parent = parent;
            this._statement = statement;
            this.prop = prop;
            if (parent == null) {
                this._table = statement.getTable();
            }
        }

        AbstractMutableStatementImpl statement() {
            AbstractMutableStatementImpl statement = this._statement;
            if (statement == null) {
                TableProxy proxy;
                AbstractMutableStatementImpl parentStatement = this.parent.statement();
                MutableSubQueryImpl subQuery = null;
                if (parentStatement.getTable() instanceof TableProxy && (proxy = (TableProxy)TableProxies.fluent(this.prop.getTargetType().getJavaClass())) != null) {
                    subQuery = new MutableSubQueryImpl(parentStatement.getSqlClient(), proxy);
                }
                if (subQuery == null) {
                    subQuery = new MutableSubQueryImpl(parentStatement, this.prop.getTargetType());
                }
                subQuery.where(this.parent.table().getId().eq(subQuery.getTable().inverseGetAssociatedId(this.prop)));
                parentStatement.where(subQuery.exists());
                this._statement = statement = subQuery;
            }
            return statement;
        }

        Table<?> table() {
            Table<Object> table = this._table;
            if (table == null) {
                table = this.prop.isReferenceList(TargetLevel.PERSISTENT) ? this.statement().getTable() : this.parent.table().join(this.prop);
                this._table = table;
            }
            return table;
        }
    }
}

