/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.table.Table;

public interface AffectedTable {
    public static Entity of(Class<?> javaType) {
        return AffectedTable.of(ImmutableType.get(javaType));
    }

    public static Entity of(ImmutableType type) {
        if (!(type.getImmutableAnnotation() instanceof org.babyfish.jimmer.sql.Entity)) {
            throw new IllegalArgumentException("\"" + type + "\" is not entity");
        }
        return new Entity(type);
    }

    public static <T extends Table<?>> Middle of(TypedProp.Association<?, ?> prop) {
        return new Middle(prop.unwrap());
    }

    public static Middle of(ImmutableProp prop) {
        return new Middle(prop);
    }

    public static final class Entity
    implements AffectedTable {
        private ImmutableType type;

        Entity(ImmutableType type) {
            this.type = Objects.requireNonNull(type, "type cannot be null");
        }

        public ImmutableType getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entity entity = (Entity)o;
            return this.type.equals((Object)entity.type);
        }

        public String toString() {
            return "TableOf(" + this.type + ')';
        }
    }

    public static final class Middle
    implements AffectedTable {
        private ImmutableProp prop;

        Middle(ImmutableProp prop) {
            ImmutableProp storageProp;
            Objects.requireNonNull(prop, "prop cannot be null");
            ImmutableProp immutableProp = storageProp = prop.getMappedBy() != null ? prop.getMappedBy() : prop;
            if (!storageProp.isMiddleTableDefinition()) {
                throw new IllegalArgumentException("\"" + prop + "\" is neither middle table property nor inverse property of middle table property");
            }
            this.prop = storageProp;
        }

        public ImmutableProp getProp() {
            return this.prop;
        }

        public int hashCode() {
            return this.prop.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Middle middle = (Middle)o;
            return this.prop.equals((Object)middle.prop);
        }

        public String toString() {
            return "Middle table of(" + this.prop + ')';
        }
    }
}

