/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedId;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedKey;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

class MutationCache {
    final JSqlClientImplementor sqlClientWithoutCache;
    private final boolean pessimisticLockRequired;
    final Map<TypedId, ImmutableSpi> idObjMap = new HashMap<TypedId, ImmutableSpi>();
    final Map<TypedKey, ImmutableSpi> keyObjMap = new HashMap<TypedKey, ImmutableSpi>();
    private final IdentityHashMap<Object, Object> savedMap = new IdentityHashMap();
    private NoFilter noFilter;

    public MutationCache(JSqlClientImplementor sqlClient, boolean pessimisticLockRequired) {
        this.sqlClientWithoutCache = sqlClient.caches(CacheDisableConfig::disableAll);
        this.pessimisticLockRequired = pessimisticLockRequired;
    }

    public boolean hasId(ImmutableType type, Object id) {
        return this.get(new TypedId(type, id)) != null;
    }

    public ImmutableSpi find(ImmutableSpi example, boolean requiresKey) {
        Object id;
        ImmutableType type = example.__type();
        ImmutableProp idProp = type.getIdProp();
        PropId idPropId = idProp.getId();
        if (example.__isLoaded(idPropId) && (id = example.__get(idPropId)) != null) {
            return this.get(new TypedId(type, id));
        }
        TypedKey key = TypedKey.of(example, this.keyProps(type), requiresKey);
        if (key == null) {
            return null;
        }
        return this.get(key);
    }

    public List<ImmutableSpi> loadByIds(ImmutableType type, Collection<?> ids, Connection con) {
        if (!(ids instanceof Set)) {
            ids = new HashSet(ids);
        }
        ArrayList<ImmutableSpi> list = new ArrayList<ImmutableSpi>(ids.size());
        ArrayList missedIds = new ArrayList();
        for (Object id : ids) {
            ImmutableSpi spi = this.get(new TypedId(type, id));
            if (spi != null) {
                list.add(spi);
                continue;
            }
            missedIds.add(id);
        }
        if (!missedIds.isEmpty()) {
            List rows = (List)Internal.requiresNewDraftContext(ctx -> {
                MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClientWithoutCache, type, ExecutionPurpose.MUTATE, this.filterLevel());
                TableImplementor<?> table = query.getTableImplementor();
                query.where(new Predicate[]{table.getId().in(missedIds)});
                List spiList = (List)query.select(table).forUpdate(this.isPessimisticLockRequired()).execute(con);
                return ctx.resolveList(spiList);
            });
            for (ImmutableSpi row : rows) {
                this.save(row, false);
                list.add(row);
            }
        }
        return list;
    }

    public ImmutableSpi save(ImmutableSpi spi, boolean forUserSave) {
        TypedKey key;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Set<ImmutableProp> keyProps = this.keyProps(type);
        ImmutableSpi oldSpi = this.find(spi, false);
        if (oldSpi != null) {
            TypedKey oldKey;
            TypedId oldTypedId = new TypedId(type, oldSpi.__get(idProp.getId()));
            this.idObjMap.remove(oldTypedId);
            if (keyProps != null && !keyProps.isEmpty() && (oldKey = TypedKey.of(oldSpi, keyProps, false)) != null) {
                this.keyObjMap.remove(oldKey);
            }
            ImmutableSpi newSpi = spi;
            spi = (ImmutableSpi)Internal.produce((ImmutableType)spi.__type(), (Object)oldSpi, draft -> {
                for (ImmutableProp prop : type.getProps().values()) {
                    PropId propId;
                    if (!prop.isMutable() || !newSpi.__isLoaded(propId = prop.getId())) continue;
                    ((DraftSpi)draft).__set(propId, newSpi.__get(prop.getId()));
                }
            });
        }
        TypedId typedId = new TypedId(type, spi.__get(idProp.getId()));
        this.idObjMap.put(typedId, spi);
        if (keyProps != null && !keyProps.isEmpty() && (key = TypedKey.of(spi, keyProps, false)) != null) {
            this.keyObjMap.put(key, spi);
        }
        if (forUserSave) {
            this.savedMap.put(spi, null);
        }
        return spi;
    }

    public boolean isSaved(ImmutableSpi spi) {
        return this.savedMap.containsKey(spi);
    }

    protected Set<ImmutableProp> keyProps(ImmutableType type) {
        return Collections.emptySet();
    }

    public boolean isPessimisticLockRequired() {
        return this.pessimisticLockRequired;
    }

    public MutationCache withFilter(boolean withFilter) {
        if (withFilter) {
            return this;
        }
        NoFilter noFilter = this.noFilter;
        if (noFilter == null) {
            this.noFilter = noFilter = new NoFilter(this);
        }
        return noFilter;
    }

    FilterLevel filterLevel() {
        return FilterLevel.DEFAULT;
    }

    ImmutableSpi get(TypedId id) {
        return this.idObjMap.get(id);
    }

    ImmutableSpi get(TypedKey key) {
        return this.idObjMap.get(key);
    }

    private static class NoFilter
    extends MutationCache {
        private final MutationCache parent;

        public NoFilter(MutationCache parent) {
            super(parent.sqlClientWithoutCache, parent.pessimisticLockRequired);
            this.parent = parent;
        }

        @Override
        public List<ImmutableSpi> loadByIds(ImmutableType type, Collection<?> ids, Connection con) {
            if (this.sqlClientWithoutCache.getFilters().getFilter(type) == null) {
                return this.parent.loadByIds(type, ids, con);
            }
            return super.loadByIds(type, ids, con);
        }

        @Override
        FilterLevel filterLevel() {
            return FilterLevel.IGNORE_ALL;
        }

        @Override
        public MutationCache withFilter(boolean withFilter) {
            return withFilter ? this.parent : this;
        }

        @Override
        ImmutableSpi get(TypedId id) {
            ImmutableSpi spi = super.get(id);
            if (spi != null) {
                return spi;
            }
            return this.parent.get(id);
        }

        @Override
        ImmutableSpi get(TypedKey key) {
            ImmutableSpi spi = super.get(key);
            if (spi != null) {
                return spi;
            }
            return this.parent.get(key);
        }
    }
}

