/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class CompositePredicate
extends AbstractPredicate {
    private static final Predicate[] EMPTY_PREDICATE_ARR = new Predicate[0];
    private final Predicate[] predicates;

    CompositePredicate(Predicate[] predicates) {
        this.predicates = predicates;
    }

    public static Predicate and(Predicate ... predicates) {
        Predicate[] arr = predicates;
        for (Predicate p : predicates) {
            if (p != null) continue;
            ArrayList<Predicate> list = new ArrayList<Predicate>(predicates.length - 1);
            for (Predicate p2 : predicates) {
                if (p2 == null) continue;
                list.add(p2);
            }
            arr = list.toArray(EMPTY_PREDICATE_ARR);
            break;
        }
        if (arr.length == 0) {
            return null;
        }
        if (arr.length == 1) {
            return arr[0];
        }
        return new And(arr);
    }

    public static Predicate or(Predicate ... predicates) {
        Predicate[] arr = predicates;
        for (Predicate p : predicates) {
            if (p != null) continue;
            ArrayList<Predicate> list = new ArrayList<Predicate>(predicates.length - 1);
            for (Predicate p2 : predicates) {
                if (p2 == null) continue;
                list.add(p2);
            }
            arr = list.toArray(EMPTY_PREDICATE_ARR);
            break;
        }
        if (arr.length == 0) {
            return null;
        }
        if (arr.length == 1) {
            return arr[0];
        }
        return new Or(arr);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        for (Predicate predicate : this.predicates) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.enter(this.scopeType());
        for (Predicate predicate : this.predicates) {
            builder.separator();
            this.renderChild((Ast)((Object)predicate), builder);
        }
        builder.leave();
    }

    protected abstract SqlBuilder.ScopeType scopeType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositePredicate that = (CompositePredicate)o;
        return Arrays.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }

    static class And
    extends CompositePredicate {
        And(Predicate ... predicates) {
            super(predicates);
        }

        @Override
        protected SqlBuilder.ScopeType scopeType() {
            return SqlBuilder.ScopeType.AND;
        }

        @Override
        public int precedence() {
            return 6;
        }
    }

    static class Or
    extends CompositePredicate {
        Or(Predicate ... predicates) {
            super(predicates);
        }

        @Override
        protected SqlBuilder.ScopeType scopeType() {
            return SqlBuilder.ScopeType.OR;
        }

        @Override
        public int precedence() {
            return 7;
        }
    }
}

