/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class CaseBuilder<T> {
    private Class<T> type;
    private List<Tuple2<Predicate, Expression<T>>> whens = new ArrayList<Tuple2<Predicate, Expression<T>>>();

    CaseBuilder(Class<T> type) {
        this.type = type;
    }

    public CaseBuilder<T> when(Predicate cond, T then) {
        return this.when(cond, Literals.any(then));
    }

    public CaseBuilder<T> when(Predicate cond, Expression<T> then) {
        this.whens.add(new Tuple2<Predicate, Expression<T>>(cond, then));
        return this;
    }

    public Expression<T> otherwise(T otherwise) {
        return this.otherwise(Literals.any(otherwise));
    }

    public Expression<T> otherwise(Expression<T> otherwise) {
        ArrayList whens = new ArrayList(this.whens);
        if (String.class.isAssignableFrom(this.type)) {
            return new StrExpr(whens, otherwise);
        }
        if (this.type.isPrimitive() || Number.class.isAssignableFrom(this.type)) {
            return new NumExpr<String>((Class<String>)this.type, whens, otherwise);
        }
        if (Comparable.class.isAssignableFrom(this.type)) {
            return new CmpExpr<String>(this.type, whens, otherwise);
        }
        return new AnyExpr<String>(this.type, whens, otherwise);
    }

    private static class StrExpr
    extends AnyExpr<String>
    implements StringExpressionImplementor {
        StrExpr(List<Tuple2<Predicate, Expression<String>>> whens, Expression<String> otherwise) {
            super(String.class, whens, otherwise);
        }
    }

    private static class NumExpr<N extends Number>
    extends AnyExpr<N>
    implements NumericExpressionImplementor<N> {
        NumExpr(Class<N> type, List<Tuple2<Predicate, Expression<N>>> whens, Expression<N> otherwise) {
            super(type, whens, otherwise);
        }
    }

    private static class CmpExpr<T extends Comparable<?>>
    extends AnyExpr<T>
    implements ComparableExpressionImplementor<T> {
        CmpExpr(Class<T> type, List<Tuple2<Predicate, Expression<T>>> whens, Expression<T> otherwise) {
            super(type, whens, otherwise);
        }
    }

    private static class AnyExpr<T>
    extends AbstractExpression<T> {
        private Class<T> type;
        private List<Tuple2<Predicate, Expression<T>>> whens;
        private Expression<T> otherwise;

        AnyExpr(Class<T> type, List<Tuple2<Predicate, Expression<T>>> whens, Expression<T> otherwise) {
            this.type = type;
            this.whens = whens;
            this.otherwise = otherwise;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public int precedence() {
            return 0;
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            for (Tuple2<Predicate, Expression<T>> when : this.whens) {
                ((Ast)((Object)when.get_1())).accept(visitor);
                ((Ast)((Object)when.get_2())).accept(visitor);
            }
            ((Ast)((Object)this.otherwise)).accept(visitor);
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder) {
            this.usingLowestPrecedence(() -> {
                builder.sql("case");
                for (Tuple2<Predicate, Expression<T>> when : this.whens) {
                    builder.sql(" when ");
                    this.renderChild((Ast)((Object)when.get_1()), builder);
                    builder.sql(" then ");
                    this.renderChild((Ast)((Object)when.get_2()), builder);
                }
                builder.sql(" else ");
                this.renderChild((Ast)((Object)this.otherwise), builder);
                builder.sql(" end");
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnyExpr anyExpr = (AnyExpr)o;
            return this.type.equals(anyExpr.type) && this.whens.equals(anyExpr.whens) && this.otherwise.equals(anyExpr.otherwise);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.whens, this.otherwise);
        }
    }

    public static class Cmp<T extends Comparable<?>>
    extends CaseBuilder<T> {
        Cmp(Class<T> type) {
            super(type);
        }

        @Override
        public Cmp<T> when(Predicate cond, T then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<T> when(Predicate cond, Expression<T> then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public ComparableExpression<T> otherwise(T otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }

        @Override
        public ComparableExpression<T> otherwise(Expression<T> otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }
    }

    public static class Num<N extends Number>
    extends CaseBuilder<N> {
        Num(Class<N> type) {
            super(type);
        }

        @Override
        public Num<N> when(Predicate cond, N then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<N> when(Predicate cond, Expression<N> then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public NumericExpression<N> otherwise(N otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }

        @Override
        public NumericExpression<N> otherwise(Expression<N> otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }
    }

    public static class Str
    extends CaseBuilder<String> {
        Str() {
            super(String.class);
        }

        public Str when(Predicate cond, String then) {
            return (Str)super.when(cond, then);
        }

        public Str when(Predicate cond, Expression<String> then) {
            return (Str)super.when(cond, then);
        }

        public StringExpression otherwise(String otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }

        public StringExpression otherwise(Expression<String> otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }
    }
}

