/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.impl.util.CollectionUtils;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherFactory;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.fetcher.impl.FieldFilterArgsImpl;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.loader.Utils;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public abstract class AbstractDataLoader {
    private static final ThreadLocal<Connection> TRANSIENT_RESOLVER_CON_LOCAL = new ThreadLocal();
    private static final SortedMap<String, Object> ILLEGAL_PARAMETERS = Collections.unmodifiableSortedMap(new TreeMap());
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final Storage storage;
    private final boolean remote;
    private final ImmutableProp sourceIdProp;
    private final ImmutableProp targetIdProp;
    private final Filter<Props> globalFiler;
    private final FieldFilter<Table<ImmutableSpi>> propFilter;
    private final int limit;
    private final long offset;
    private final boolean rawValue;
    private final TransientResolver<?, ?> resolver;
    private final FetcherImplementor<ImmutableSpi> fetcher;

    protected AbstractDataLoader(JSqlClientImplementor sqlClient, Connection con, ImmutableType entityType, ImmutableProp prop, Fetcher<?> fetcher, FieldFilter<?> propFilter, int limit, int offset, boolean rawValue) {
        if (!prop.isAssociation(TargetLevel.ENTITY) && !prop.hasTransientResolver()) {
            throw new IllegalArgumentException("\"" + prop + "\" is neither association nor transient with resolver");
        }
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            if (fetcher != null) {
                throw new IllegalArgumentException("Cannot specify fetcher for scalar prop \"" + prop + "\"");
            }
            if (propFilter != null) {
                throw new IllegalArgumentException("Cannot specify filter for scalar prop \"" + prop + "\"");
            }
            if (limit != Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cannot specify limit for scalar prop \"" + prop + "\"");
            }
            if (offset != 0) {
                throw new IllegalArgumentException("Cannot specify limit for scalar prop \"" + prop + "\"");
            }
        }
        if (entityType != null) {
            if (!entityType.isEntity()) {
                throw new IllegalArgumentException("\"" + entityType + "\" is not entity");
            }
        } else if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.storage = prop.getStorage(sqlClient.getMetadataStrategy());
        this.remote = prop.isRemote();
        this.sourceIdProp = prop.getDeclaringType().getIdProp();
        this.targetIdProp = prop.getTargetType() != null ? prop.getTargetType().getIdProp() : null;
        this.globalFiler = prop.isAssociation(TargetLevel.PERSISTENT) ? sqlClient.getFilters().getTargetFilter(prop) : null;
        this.propFilter = propFilter;
        if (prop.isReference(TargetLevel.ENTITY) && !prop.isNullable()) {
            if (this.globalFiler != null) {
                throw new ExecutionException("Cannot apply filter \"" + this.globalFiler + "\" for \"" + prop + "\" because that property is not nullable");
            }
            if (propFilter != null) {
                throw new ExecutionException("Cannot apply field filter of object fetcher for \"" + prop + "\" because that property is not nullable");
            }
        }
        this.limit = limit;
        this.offset = offset;
        this.rawValue = rawValue;
        if (prop.isAssociation(TargetLevel.PERSISTENT)) {
            this.resolver = null;
            this.fetcher = fetcher != null ? (FetcherImplementor)fetcher : new FetcherImpl(prop.getTargetType().getJavaClass());
        } else {
            this.resolver = sqlClient.getResolver(prop);
            this.fetcher = prop.isAssociation(TargetLevel.ENTITY) ? (fetcher != null ? (FetcherImplementor)fetcher : new FetcherImpl(prop.getTargetType().getJavaClass())) : null;
        }
    }

    public Map<ImmutableSpi, Object> load(Collection<ImmutableSpi> sources) {
        if (sources.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sources.size() > 1 && (this.limit != Integer.MAX_VALUE || this.offset != 0L)) {
            throw new IllegalArgumentException("Pagination data loader does not support batch loading");
        }
        if (this.resolver != null) {
            return this.loadTransients(sources);
        }
        if (this.storage instanceof ColumnDefinition) {
            return this.loadParents(sources);
        }
        if (this.prop.isReferenceList(TargetLevel.ENTITY)) {
            return this.loadTargetMultiMap(sources);
        }
        return this.loadTargetMap(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ImmutableSpi, Object> loadTransients(Collection<ImmutableSpi> sources) {
        boolean useCache;
        Cache.Parameterized parameterizedCache;
        List<Object> sourceIds = this.toSourceIds(sources);
        TransientResolver<?, ?> resolver = this.resolver;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        Ref<SortedMap<String, Object>> parameterMapRef = resolver.getParameterMapRef();
        SortedMap<String, Object> parameterMap = parameterMapRef != null ? AbstractDataLoader.standardResolveParameters((SortedMap)parameterMapRef.getValue()) : null;
        Cache.Parameterized parameterized = parameterizedCache = cache instanceof Cache.Parameterized ? (Cache.Parameterized)cache : null;
        if (cache != null) {
            CacheAbandonedCallback callback;
            if (parameterMapRef == null) {
                useCache = false;
                callback = this.sqlClient.getCaches().getAbandonedCallback();
                if (callback != null) {
                    callback.abandoned(this.prop, CacheAbandonedCallback.Reason.CACHEABLE_FILTER_REQUIRED);
                }
            } else if (parameterMap != null && !parameterMap.isEmpty() && parameterizedCache == null) {
                useCache = false;
                callback = this.sqlClient.getCaches().getAbandonedCallback();
                if (callback != null) {
                    callback.abandoned(this.prop, CacheAbandonedCallback.Reason.PARAMETERIZED_CACHE_REQUIRED);
                }
            } else {
                useCache = true;
            }
        } else {
            useCache = false;
        }
        if (!useCache) {
            Map<Object, Object> resolvedMap;
            TRANSIENT_RESOLVER_CON_LOCAL.set(this.con);
            try {
                resolvedMap = this.translateResolvedMap(resolver.resolve(sourceIds), sourceIds);
            }
            finally {
                TRANSIENT_RESOLVER_CON_LOCAL.remove();
            }
            return Utils.joinCollectionAndMap(sources, this::toSourceId, resolvedMap);
        }
        CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, ids -> {
            TRANSIENT_RESOLVER_CON_LOCAL.set(this.con);
            try {
                Map map = resolver.resolve(ids);
                return map;
            }
            finally {
                TRANSIENT_RESOLVER_CON_LOCAL.remove();
            }
        }, false);
        Map<Object, Object> valueMap = parameterMap != null && !parameterMap.isEmpty() && parameterizedCache != null ? parameterizedCache.getAll(sourceIds, parameterMap, env) : cache.getAll(sourceIds, env);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, this.translateResolvedMap(valueMap, sourceIds));
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParents(Collection<ImmutableSpi> sources) {
        Cache fkCache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        SortedMap<String, Object> parameters = this.getParameters();
        if (!this.remote && !this.useCache(fkCache, parameters)) {
            return this.loadParentsDirectly(sources);
        }
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        List<Object> missedFkSourceIds = new ArrayList();
        if (this.isUnreliableParentId()) {
            missedFkSourceIds = this.toSourceIds(sources);
        } else {
            for (ImmutableSpi source : sources) {
                if (source.__isLoaded(this.prop.getId())) {
                    ImmutableSpi immutableSpi = (ImmutableSpi)source.__get(this.prop.getId());
                    if (immutableSpi == null) continue;
                    fkMap.put(this.toSourceId(source), this.toTargetId(immutableSpi));
                    continue;
                }
                missedFkSourceIds.add(this.toSourceId(source));
            }
        }
        if (!missedFkSourceIds.isEmpty()) {
            Map<Object, Object> missedFkMap;
            if (this.remote) {
                missedFkMap = this.queryForeignKeyMap(missedFkSourceIds);
            } else {
                CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, this::queryForeignKeyMap, false);
                missedFkMap = parameters != null ? ((Cache.Parameterized)fkCache).getAll(missedFkSourceIds, parameters, env) : fkCache.getAll(missedFkSourceIds, env);
            }
            for (Object e : missedFkSourceIds) {
                Object fk = missedFkMap.get(e);
                if (fk == null) continue;
                fkMap.put(e, fk);
            }
        }
        Map targetMap = Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(fkMap.values()))));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParentsDirectly(Collection<ImmutableSpi> sources) {
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        ArrayList<Object> missedFkSourceIds = new ArrayList<Object>();
        for (ImmutableSpi source : sources) {
            if (source.__isLoaded(this.prop.getId())) {
                ImmutableSpi target = (ImmutableSpi)source.__get(this.prop.getId());
                if (target == null) continue;
                fkMap.put(this.toSourceId(source), this.toTargetId(target));
                continue;
            }
            missedFkSourceIds.add(this.toSourceId(source));
        }
        Map map1 = null;
        if (!fkMap.isEmpty()) {
            map1 = this.isUnreliableParentId() ? Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.queryTargets(fkMap.values()))) : Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(fkMap.values())));
        }
        Map map2 = null;
        if (!missedFkSourceIds.isEmpty()) {
            if (this.isUnreliableParentId() || this.fetcher.getFieldMap().size() > 1) {
                map2 = Tuple2.toMap(this.querySourceTargetPairs(missedFkSourceIds));
            } else {
                Map<Object, Object> loadedFkMap = this.queryForeignKeyMap(missedFkSourceIds);
                map2 = new LinkedHashMap((missedFkSourceIds.size() * 4 + 2) / 3);
                for (Object e : missedFkSourceIds) {
                    Object targetId = loadedFkMap.get(e);
                    map2.put(e, this.makeIdOnlyTarget(targetId));
                }
            }
        }
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.mergeMap(map1, map2));
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMap(Collection<ImmutableSpi> sources) {
        Map idMap;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        SortedMap<String, Object> parameters = this.getParameters();
        if (!this.remote && !this.useCache(cache, parameters)) {
            return this.loadTargetMapDirectly(sources);
        }
        if (this.remote && this.prop.getMappedBy() != null) {
            List tuples;
            try {
                tuples = this.sqlClient.getMicroServiceExchange().findByAssociatedIds(this.prop.getTargetType().getMicroServiceName(), this.prop.getMappedBy(), this.toSourceIds(sources), FetcherFactory.excludeMicroServiceNameExceptRoot(this.fetcher, this.prop.getDeclaringType().getMicroServiceName()));
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot load the remote association \"" + this.prop + "\" because error raised", ex);
            }
            return Utils.joinCollectionAndMap(sources, this::toSourceId, Tuple2.toMap(tuples));
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        if (this.remote) {
            idMap = Tuple2.toMap(this.querySourceTargetIdPairs(sourceIds));
        } else {
            CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, it -> Tuple2.toMap(this.querySourceTargetIdPairs(it)), false);
            idMap = parameters != null ? ((Cache.Parameterized)cache).getAll(sourceIds, parameters, env) : cache.getAll(sourceIds, env);
        }
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(idMap.values())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMaps(idMap, targetMap));
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.globalFiler != null || this.propFilter != null || this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMap(Collection<ImmutableSpi> sources) {
        Map idMultiMap;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        SortedMap<String, Object> parameters = this.getParameters();
        if (!this.remote && !this.useCache(cache, parameters)) {
            return this.loadTargetMultiMapDirectly(sources);
        }
        if (this.remote && this.prop.getMappedBy() != null) {
            List tuples;
            try {
                tuples = this.sqlClient.getMicroServiceExchange().findByAssociatedIds(this.prop.getTargetType().getMicroServiceName(), this.prop.getMappedBy(), this.toSourceIds(sources), FetcherFactory.excludeMicroServiceNameExceptRoot(this.fetcher, this.prop.getDeclaringType().getMicroServiceName()));
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot load the remote association \"" + this.prop + "\" because error raised", ex);
            }
            return Utils.joinCollectionAndMap(sources, this::toSourceId, Tuple2.toMultiMap(tuples));
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        if (this.remote) {
            idMultiMap = Tuple2.toMultiMap(this.querySourceTargetIdPairs(sourceIds));
        } else {
            CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, it -> Tuple2.toMultiMap(this.querySourceTargetIdPairs(it)), false);
            idMultiMap = parameters != null ? ((Cache.Parameterized)cache).getAll(sourceIds, parameters, env) : cache.getAll(sourceIds, env);
        }
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(idMultiMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMultiMapAndMap(idMultiMap, targetMap));
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.globalFiler != null || this.propFilter != null || this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMultiMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMultiMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<Object, Object> queryForeignKeyMap(Collection<Object> sourceIds) {
        if (sourceIds.size() == 1) {
            Object sourceId = CollectionUtils.first(sourceIds);
            List targetIds = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, source) -> {
                PropExpression pkExpr = source.get(this.sourceIdProp);
                Table targetTable = source.join(this.prop);
                PropExpression fkExpr = source.getAssociatedId(this.prop);
                q.where(new Predicate[]{pkExpr.eq(sourceId)});
                q.where(new Predicate[]{fkExpr.isNotNull()});
                this.applyPropFilter((MutableQuery)q, targetTable, sourceIds);
                this.applyGlobalFilter((Sortable)q, targetTable);
                this.applyDefaultOrder((MutableQuery)q, targetTable);
                return q.select(fkExpr);
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toMap(sourceId, targetIds);
        }
        List tuples = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, source) -> {
            PropExpression pkExpr = source.get(this.sourceIdProp);
            Table targetTable = source.join(this.prop);
            PropExpression fkExpr = source.getAssociatedId(this.prop);
            q.where(new Predicate[]{pkExpr.in(sourceIds)});
            q.where(new Predicate[]{fkExpr.isNotNull()});
            this.applyPropFilter((MutableQuery)q, targetTable, sourceIds);
            this.applyGlobalFilter((Sortable)q, targetTable);
            this.applyDefaultOrder((MutableQuery)q, targetTable);
            return q.select(pkExpr, fkExpr);
        }).execute(this.con);
        return Tuple2.toMap(tuples);
    }

    private List<Tuple2<Object, Object>> querySourceTargetIdPairs(Collection<Object> sourceIds) {
        if (this.propFilter == null && this.prop.getReal().isMiddleTableDefinition()) {
            if (sourceIds.size() == 1) {
                Object sourceId = CollectionUtils.first(sourceIds);
                List targetIds = (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), ExecutionPurpose.LOAD, (q, association) -> {
                    Expression sourceIdExpr = association.sourceId();
                    Expression targetIdExpr = association.targetId();
                    q.where(new Predicate[]{sourceIdExpr.eq(sourceId)});
                    this.applyPropFilter((MutableQuery)q, (Table<?>)association.target(), sourceIds);
                    this.applyGlobalFilter((Sortable)q, (Table<?>)association.target());
                    this.applyDefaultOrder((MutableQuery)q, (Table<?>)association.target());
                    return q.select(targetIdExpr);
                }).limit(this.limit, this.offset).execute(this.con);
                return Utils.toTuples(sourceId, targetIds);
            }
            return (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), ExecutionPurpose.LOAD, (q, association) -> {
                Expression sourceIdExpr = association.sourceId();
                Expression targetIdExpr = association.targetId();
                q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
                this.applyPropFilter((MutableQuery)q, (Table<?>)association.target(), sourceIds);
                this.applyGlobalFilter((Sortable)q, (Table<?>)association.target());
                this.applyDefaultOrder((MutableQuery)q, (Table<?>)association.target());
                return q.select(sourceIdExpr, targetIdExpr);
            }).execute(this.con);
        }
        return this.executeTupleQuery(sourceIds, target -> target.get(this.targetIdProp.getName()));
    }

    private List<Tuple2<Object, ImmutableSpi>> querySourceTargetPairs(Collection<Object> sourceIds) {
        return this.executeTupleQuery(sourceIds, target -> target.fetch(this.fetcher));
    }

    private List<ImmutableSpi> queryTargets(Collection<Object> targetIds) {
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, target) -> {
            PropExpression idExpr = target.get(this.targetIdProp.getName());
            q.where(new Predicate[]{idExpr.in(targetIds)});
            this.applyPropFilter((MutableQuery)q, (Table<?>)target, targetIds);
            this.applyGlobalFilter((Sortable)q, (Table<?>)target);
            this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
            return q.select(target.fetch(this.fetcher));
        }).execute(this.con);
    }

    private <R> List<Tuple2<Object, R>> executeTupleQuery(Collection<Object> sourceIds, Function<Table<ImmutableSpi>, Selection<?>> valueExpressionGetter) {
        if (sourceIds.size() == 1) {
            Object sourceId = CollectionUtils.first(sourceIds);
            List results = (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, target) -> {
                PropExpression sourceIdExpr = target.inverseGetAssociatedId(this.prop);
                q.where(new Predicate[]{sourceIdExpr.eq(sourceId)});
                this.applyPropFilter((MutableQuery)q, (Table<?>)target, sourceIds);
                this.applyGlobalFilter((Sortable)q, (Table<?>)target);
                this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
                return q.select((Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toTuples(sourceId, results);
        }
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, target) -> {
            PropExpression sourceIdExpr = target.inverseGetAssociatedId(this.prop);
            q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
            this.applyPropFilter((MutableQuery)q, (Table<?>)target, sourceIds);
            this.applyGlobalFilter((Sortable)q, (Table<?>)target);
            this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
            return q.select(sourceIdExpr, (Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
        }).execute(this.con);
    }

    private void applyGlobalFilter(Sortable sortable, Table<?> table) {
        AbstractMutableQueryImpl query = (AbstractMutableQueryImpl)sortable;
        query.setOrderByPriority(1);
        TableImplementor tableImplementor = null;
        if (table instanceof TableImplementor) {
            tableImplementor = (TableImplementor)table;
        } else if (table instanceof TableProxy) {
            tableImplementor = ((TableProxy)table).__unwrap();
        }
        if (tableImplementor == null) {
            throw new AssertionError((Object)"The table create by data loader must be table implementation or table wrapper");
        }
        query.applyDataLoaderGlobalFilters(tableImplementor);
    }

    private void applyPropFilter(MutableQuery query, Table<?> table, Collection<Object> keys) {
        if (this.propFilter != null) {
            FieldFilterArgsImpl<Table<?>> args = FieldFilterArgsImpl.of((AbstractMutableQueryImpl)query, table, keys);
            ((AbstractMutableQueryImpl)query).setOrderByPriority(2);
            this.propFilter.apply(args);
        }
    }

    private void applyDefaultOrder(MutableQuery query, Table<?> table) {
        if (((AbstractMutableQueryImpl)query).getAcceptedOrderByPriority() > 0) {
            return;
        }
        List orderedItems = this.prop.getOrderedItems();
        if (!orderedItems.isEmpty() && !this.remote) {
            for (OrderedItem orderedItem : orderedItems) {
                PropExpression expr = table.get(orderedItem.getProp().getName());
                if (orderedItem.isDesc()) {
                    query.orderBy(expr.desc());
                    continue;
                }
                query.orderBy(new Expression[]{expr});
            }
        }
    }

    private Object toSourceId(ImmutableSpi source) {
        return source.__get(this.sourceIdProp.getId());
    }

    private List<Object> toSourceIds(Collection<ImmutableSpi> sources) {
        return sources.stream().map(this::toSourceId).collect(Collectors.toList());
    }

    private Object toTargetId(ImmutableSpi target) {
        if (target == null) {
            return null;
        }
        return target.__get(this.targetIdProp.getId());
    }

    private List<ImmutableSpi> findTargets(Collection<Object> targetIds) {
        if (this.fetcher.getFieldMap().size() < 2 && !this.remote) {
            return this.makeIdOnlyTargets(targetIds);
        }
        if (this.remote) {
            try {
                return this.sqlClient.getMicroServiceExchange().findByIds(this.prop.getTargetType().getMicroServiceName(), targetIds, FetcherFactory.excludeMicroServiceNameExceptRoot(this.fetcher, this.prop.getDeclaringType().getMicroServiceName()));
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot load the remote association \"" + this.prop + "\" because error raised", ex);
            }
        }
        return ((EntitiesImpl)this.sqlClient.getEntities()).forLoader().forConnection(this.con).findByIds(this.fetcher, targetIds);
    }

    private List<ImmutableSpi> makeIdOnlyTargets(Collection<Object> targetIds) {
        return targetIds.stream().map(this::makeIdOnlyTarget).collect(Collectors.toCollection(() -> new ArrayList(targetIds.size())));
    }

    private ImmutableSpi makeIdOnlyTarget(Object id) {
        if (id == null) {
            return null;
        }
        return (ImmutableSpi)Internal.produce((ImmutableType)this.prop.getTargetType(), null, draft -> {
            DraftSpi targetDraft = (DraftSpi)draft;
            targetDraft.__set(this.targetIdProp.getId(), id);
        });
    }

    private SortedMap<String, Object> getParameters() {
        Filter<Props> filter = this.globalFiler;
        if (filter instanceof CacheableFilter) {
            SortedMap<String, Object> parameters = ((CacheableFilter)filter).getParameters();
            if (parameters.isEmpty()) {
                return null;
            }
            return parameters;
        }
        if (filter != null) {
            return ILLEGAL_PARAMETERS;
        }
        return null;
    }

    private boolean useCache(Cache<?, ?> cache, Map<String, Object> parameters) {
        if (cache == null) {
            return false;
        }
        if (this.remote) {
            return true;
        }
        if (this.propFilter != null) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.FIELD_FILTER_USED);
            }
            return false;
        }
        if (parameters == ILLEGAL_PARAMETERS) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.CACHEABLE_FILTER_REQUIRED);
            }
            return false;
        }
        if (parameters != null && !(cache instanceof Cache.Parameterized)) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.PARAMETERIZED_CACHE_REQUIRED);
            }
            return false;
        }
        return true;
    }

    private Map<Object, Object> translateResolvedMap(Map<Object, Object> map, Collection<Object> keys) {
        map = this.fetchResolvedMap(map);
        Object defaultValue = this.resolver.getDefaultValue();
        if (defaultValue == null && this.prop.isReferenceList(TargetLevel.OBJECT)) {
            defaultValue = Collections.emptyList();
        }
        if (defaultValue != null) {
            for (Object key : keys) {
                if (map.get(key) != null) continue;
                map.putIfAbsent(key, defaultValue);
            }
        }
        return map;
    }

    private Map<Object, Object> fetchResolvedMap(Map<Object, Object> map) {
        boolean noFilter;
        List targets;
        if (map.isEmpty() || !this.prop.isAssociation(TargetLevel.OBJECT) || !this.prop.getTargetType().isEntity()) {
            return map;
        }
        LinkedHashSet<Object> targetIds = new LinkedHashSet<Object>();
        if (this.prop.isReferenceList(TargetLevel.OBJECT)) {
            for (Object mapValue : map.values()) {
                for (Object targetId : (Collection)mapValue) {
                    if (targetId == null) continue;
                    targetIds.add(targetId);
                }
            }
        } else {
            for (Object targetId : map.values()) {
                if (targetId == null) continue;
                targetIds.add(targetId);
            }
        }
        if ((targets = (noFilter = this.propFilter == null && this.globalFiler == null) ? this.findTargets(targetIds) : (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOAD, FilterLevel.IGNORE_ALL, (q, target) -> {
            PropExpression pkExpr = target.get(this.targetIdProp.getName());
            q.where(new Predicate[]{pkExpr.in(targetIds)});
            this.applyPropFilter((MutableQuery)q, (Table<?>)target, (Collection<Object>)map.keySet());
            this.applyGlobalFilter((Sortable)q, (Table<?>)target);
            return q.select(target.fetch(this.fetcher));
        }).execute(this.con)).isEmpty()) {
            return new LinkedHashMap<Object, Object>();
        }
        HashMap<Object, ImmutableSpi> targetMap = new HashMap<Object, ImmutableSpi>((targets.size() * 4 + 2) / 3);
        PropId targetIdPropId = this.prop.getTargetType().getIdProp().getId();
        for (Object target2 : targets) {
            targetMap.put(target2.__get(targetIdPropId), (ImmutableSpi)target2);
        }
        LinkedHashMap<Object, Object> fetchedMap = new LinkedHashMap<Object, Object>((map.size() * 4 + 2) / 3);
        if (noFilter && this.prop.isReferenceList(TargetLevel.ENTITY)) {
            for (Map.Entry entry : map.entrySet()) {
                Collection subCollection = (Collection)entry.getValue();
                ArrayList<ImmutableSpi> targetList = new ArrayList<ImmutableSpi>(subCollection.size());
                for (Object targetId : subCollection) {
                    ImmutableSpi target3 = (ImmutableSpi)targetMap.get(targetId);
                    if (target3 == null) continue;
                    targetList.add(target3);
                }
                fetchedMap.put(entry.getKey(), targetList);
            }
        } else if (!noFilter && this.prop.isReferenceList(TargetLevel.ENTITY)) {
            IdentityHashMap<ImmutableSpi, Object> identityMap = new IdentityHashMap<ImmutableSpi, Object>();
            for (Map.Entry<Object, Object> e : map.entrySet()) {
                Collection subCollection = (Collection)e.getValue();
                for (Object targetId : subCollection) {
                    ImmutableSpi target4 = (ImmutableSpi)targetMap.get(targetId);
                    if (target4 == null) continue;
                    identityMap.put(target4, e.getKey());
                }
            }
            for (ImmutableSpi target5 : targets) {
                Object key = identityMap.get(target5);
                if (key == null) continue;
                ArrayList<ImmutableSpi> targetList = (ArrayList<ImmutableSpi>)fetchedMap.get(key);
                if (targetList == null) {
                    Collection ids = (Collection)map.get(key);
                    targetList = new ArrayList<ImmutableSpi>(ids.size());
                    fetchedMap.put(key, targetList);
                }
                targetList.add(target5);
            }
        } else {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                ImmutableSpi target6 = (ImmutableSpi)targetMap.get(entry.getValue());
                if (target6 == null) continue;
                fetchedMap.put(entry.getKey(), target6);
            }
        }
        return fetchedMap;
    }

    private boolean isUnreliableParentId() {
        return !this.remote && (!this.rawValue && (this.globalFiler != null || this.propFilter != null) || !((ColumnDefinition)this.storage).isForeignKey());
    }

    public static Connection transientResolverConnection() {
        Connection con = TRANSIENT_RESOLVER_CON_LOCAL.get();
        if (con == null) {
            throw new IllegalStateException("The current thread is not resolving any transient property");
        }
        return con;
    }

    private static SortedMap<String, Object> standardResolveParameters(SortedMap<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return parameters;
        }
        boolean hasNullValue = false;
        for (Object o : parameters.values()) {
            if (o != null) continue;
            hasNullValue = true;
            break;
        }
        if (!hasNullValue) {
            return parameters;
        }
        TreeMap<String, Object> withoutNullValueMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> e : parameters.entrySet()) {
            Object value = e.getValue();
            if (value == null) continue;
            withoutNullValueMap.put(e.getKey(), value);
        }
        return withoutNullValueMap;
    }
}

