/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.runtime.DbNull;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.jetbrains.annotations.NotNull;

public class DefaultExecutor
implements Executor {
    public static final DefaultExecutor INSTANCE = new DefaultExecutor();
    private static final Map<Class<?>, Integer> SQL_TYPE_MAP;

    DefaultExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R execute(@NotNull Executor.Args<R> args) {
        String sql = args.sql;
        List<Object> variables = args.variables;
        Dialect dialect = args.sqlClient.getDialect();
        try (PreparedStatement stmt = args.statementFactory != null ? args.statementFactory.preparedStatement(args.con, sql) : args.con.prepareStatement(sql);){
            int size = variables.size();
            for (int index = 0; index < size; ++index) {
                Object variable = variables.get(index);
                if (variable instanceof DbNull) {
                    stmt.setNull(index + 1, this.toJdbcType(((DbNull)variable).getType(), dialect));
                    continue;
                }
                stmt.setObject(index + 1, variable);
            }
            Object r = args.block.apply(stmt);
            return r;
        }
        catch (SQLException ex) {
            throw new ExecutionException("Cannot execute SQL statement: " + sql + ", variables: " + variables, ex);
        }
    }

    private int toJdbcType(Class<?> type, Dialect dialect) {
        Integer sqlType = SQL_TYPE_MAP.get(type);
        if (sqlType != null) {
            return sqlType;
        }
        int jdbcType = dialect.resolveUnknownJdbcType(type);
        if (jdbcType != 1111) {
            return jdbcType;
        }
        throw new IllegalArgumentException("Cannot convert the sql type '" + type + "' to java.sql.Types by the current dialect \"" + dialect.getClass().getName() + "\"");
    }

    static {
        HashMap map = new HashMap();
        map.put(String.class, 12);
        map.put(Boolean.TYPE, -6);
        map.put(Boolean.class, -6);
        map.put(Character.TYPE, 1);
        map.put(Character.class, 1);
        map.put(Byte.TYPE, -6);
        map.put(Byte.class, -6);
        map.put(Short.TYPE, 5);
        map.put(Short.class, 5);
        map.put(Integer.TYPE, 4);
        map.put(Integer.class, 4);
        map.put(Long.TYPE, -5);
        map.put(Long.class, -5);
        map.put(Float.TYPE, 6);
        map.put(Float.class, 6);
        map.put(Double.TYPE, 8);
        map.put(Double.class, 8);
        map.put(BigInteger.class, 3);
        map.put(BigDecimal.class, 3);
        map.put(UUID.class, 12);
        map.put(Date.class, 91);
        map.put(Time.class, 92);
        map.put(java.util.Date.class, 93);
        map.put(LocalDate.class, 91);
        map.put(LocalTime.class, 92);
        map.put(LocalDateTime.class, 93);
        map.put(OffsetDateTime.class, 2014);
        map.put(ZonedDateTime.class, 2014);
        map.put(byte[].class, -2);
        SQL_TYPE_MAP = map;
    }
}

