/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.meta;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.impl.util.PropCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.meta.impl.AbstractImmutableTypeImpl;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssociationType
extends AbstractImmutableTypeImpl {
    private static final PropCache<AssociationType> CACHE = new PropCache(AssociationType::new, false);
    private final ImmutableProp baseProp;
    private final ImmutableType sourceType;
    private final ImmutableType targetType;
    private final AssociationProp sourceProp;
    private final AssociationProp targetProp;
    private final Map<String, ImmutableProp> props;

    public static AssociationType of(ImmutableProp prop) {
        return (AssociationType)((Object)CACHE.get(prop));
    }

    public static AssociationType of(TypedProp.Association<?, ?> prop) {
        return (AssociationType)((Object)CACHE.get(prop.unwrap()));
    }

    private AssociationType(ImmutableProp baseProp) {
        this.baseProp = baseProp;
        ImmutableProp mappedBy = baseProp.getMappedBy();
        if (!(mappedBy != null ? mappedBy : baseProp).isMiddleTableDefinition()) {
            throw new IllegalArgumentException("\"" + baseProp + "\" is neither association bases on middle table nor inverse association of that");
        }
        this.sourceType = baseProp.getDeclaringType();
        this.targetType = baseProp.getTargetType();
        this.sourceProp = new AssociationProp.Source(this);
        this.targetProp = new AssociationProp.Target(this);
        LinkedHashMap<String, AssociationProp> map = new LinkedHashMap<String, AssociationProp>();
        map.put(this.sourceProp.getName(), this.sourceProp);
        map.put(this.targetProp.getName(), this.targetProp);
        this.props = Collections.unmodifiableMap(map);
    }

    public ImmutableProp getBaseProp() {
        return this.baseProp;
    }

    public ImmutableType getSourceType() {
        return this.sourceType;
    }

    public ImmutableType getTargetType() {
        return this.targetType;
    }

    public AssociationProp getSourceProp() {
        return this.sourceProp;
    }

    public AssociationProp getTargetProp() {
        return this.targetProp;
    }

    public MiddleTable getMiddleTable(MetadataStrategy strategy) {
        ImmutableProp mappedBy = this.baseProp.getMappedBy();
        if (mappedBy != null) {
            return ((MiddleTable)mappedBy.getStorage(strategy)).getInverse();
        }
        return (MiddleTable)this.baseProp.getStorage(strategy);
    }

    @NotNull
    public Class<?> getJavaClass() {
        return Association.class;
    }

    public boolean isKotlinClass() {
        return false;
    }

    public boolean isEntity() {
        return true;
    }

    public boolean isMappedSuperclass() {
        return false;
    }

    public boolean isEmbeddable() {
        return false;
    }

    @NotNull
    public Annotation getImmutableAnnotation() {
        return null;
    }

    @NotNull
    public Map<String, ImmutableProp> getDeclaredProps() {
        return this.props;
    }

    @NotNull
    public Map<String, ImmutableProp> getProps() {
        return this.props;
    }

    @NotNull
    public Map<String, ImmutableProp> getEntityProps() {
        return this.props;
    }

    public Map<String, ImmutableProp> getSelectableProps() {
        return this.props;
    }

    public Map<String, ImmutableProp> getSelectableScalarProps() {
        return Collections.emptyMap();
    }

    public Map<String, ImmutableProp> getSelectableReferenceProps() {
        return this.props;
    }

    @NotNull
    public ImmutableProp getProp(String name) {
        ImmutableProp prop = this.props.get(name);
        if (prop == null) {
            throw new IllegalArgumentException("There is no property \"" + name + "\" in \"" + (Object)((Object)this) + "\"");
        }
        return prop;
    }

    @NotNull
    public ImmutableProp getProp(PropId id) {
        int index = id.asIndex();
        if (index == -1) {
            return this.getProp(id.asName());
        }
        switch (index) {
            case 0: {
                return this.sourceProp;
            }
            case 1: {
                return this.targetProp;
            }
        }
        throw new IllegalArgumentException("There is no property whose id is " + id + " in \"" + (Object)((Object)this) + "\"");
    }

    @NotNull
    public BiFunction<DraftContext, Object, Draft> getDraftFactory() {
        throw new UnsupportedOperationException("draftFactory is not supported by AssociationType");
    }

    public boolean isAssignableFrom(ImmutableType type) {
        return false;
    }

    @Nullable
    public ImmutableType getPrimarySuperType() {
        return null;
    }

    public Set<ImmutableType> getSuperTypes() {
        return Collections.emptySet();
    }

    public Set<ImmutableType> getAllTypes() {
        return Collections.emptySet();
    }

    public ImmutableProp getIdProp() {
        throw new UnsupportedOperationException("Id property is not supported by association type");
    }

    @Nullable
    public ImmutableProp getVersionProp() {
        return null;
    }

    @Nullable
    public LogicalDeletedInfo getDeclaredLogicalDeletedInfo() {
        return null;
    }

    @Nullable
    public LogicalDeletedInfo getLogicalDeletedInfo() {
        return null;
    }

    @NotNull
    public Set<ImmutableProp> getKeyProps() {
        return Collections.emptySet();
    }

    public String getMicroServiceName() {
        return this.baseProp.getDeclaringType().getMicroServiceName();
    }

    public String getTableName(MetadataStrategy strategy) {
        return this.getMiddleTable(strategy).getTableName();
    }

    public IdGenerator getIdGenerator(SqlContext sqlContext) {
        return null;
    }

    public String toString() {
        return "MiddleTable(" + this.baseProp + ")";
    }
}

