package org.babyfish.jimmer.sql.filter;

import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.event.EntityEvent;

import java.util.SortedMap;

/**
 * Global filter which can work with multi-view cache for java, Kotlin developer should use `KCacheableFilter&lt;E&gt;`
 * @param <P> The EntityProps type generated by apt
 */
public interface CacheableFilter<P extends Props> extends Filter<P> {

    SortedMap<String, Object> getParameters();

    boolean isAffectedBy(EntityEvent<?> e);
}
