/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Collection;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class InCollectionPredicate
extends AbstractPredicate {
    private Expression<?> expression;
    private Collection<?> values;
    private Collection<?> convertedValues;
    private boolean negative;

    public InCollectionPredicate(Expression<?> expression, Collection<?> values, boolean negative) {
        this.expression = expression;
        this.values = values;
        this.negative = negative;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        if (this.values.isEmpty()) {
            builder.sql(this.negative ? "1 = 1" : "1 = 0");
        } else {
            this.renderChild((Ast)((Object)this.expression), builder);
            builder.sql(this.negative ? " not in " : " in ").enter(SqlBuilder.ScopeType.LIST);
            Collection<?> convertedValues = this.convertedValues;
            if (convertedValues == null) {
                convertedValues = Literals.convert(this.values, this.expression, builder.getAstContext().getSqlClient());
                this.convertedValues = convertedValues;
            }
            for (Object value : convertedValues) {
                if (value != null) {
                    builder.separator().variable(value);
                    continue;
                }
                builder.separator().nullVariable(((ExpressionImplementor)this.expression).getType());
            }
            builder.leave();
        }
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Predicate not() {
        return new InCollectionPredicate(this.expression, this.values, !this.negative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InCollectionPredicate)) {
            return false;
        }
        InCollectionPredicate that = (InCollectionPredicate)o;
        return this.negative == that.negative && this.expression.equals(that.expression) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.values, this.negative);
    }
}

