/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RuntimeExceptionTranslator
implements ExceptionTranslator<Exception> {
    private static final Item[] EMPTY_ITEM_ARR = new Item[0];
    private final Item[] items;

    RuntimeExceptionTranslator(Item[] items) {
        this.items = items;
    }

    @Override
    @Nullable
    public Exception translate(@NotNull Exception exception, @NotNull ExceptionTranslator.Args args) {
        HashSet handledTypes = new HashSet();
        Exception translated;
        while ((translated = this.translate(exception, args, handledTypes)) != exception) {
            exception = translated;
        }
        return translated;
    }

    private Exception translate(Exception exception, ExceptionTranslator.Args args, Set<Class<?>> handledTypes) {
        Class<?> type = exception.getClass();
        for (Item item : this.items) {
            Exception translated;
            if (!item.type.isAssignableFrom(type) || !handledTypes.add(type) || (translated = item.translator.translate(exception, args)) == null || translated == exception) continue;
            return translated;
        }
        return exception;
    }

    static ExceptionTranslator<Exception> of(Collection<ExceptionTranslator<?>> translators) {
        if (translators == null) {
            return null;
        }
        ArrayList nonNullTranslators = new ArrayList();
        for (ExceptionTranslator<?> translator : translators) {
            if (translator == null) continue;
            nonNullTranslators.add(translator);
        }
        if (nonNullTranslators.isEmpty()) {
            return null;
        }
        HashSet<Class<? extends Exception>> scatteredExceptionTypes = new HashSet<Class<? extends Exception>>();
        HashMap<Class<? extends Exception>, Item> itemMap = new HashMap<Class<? extends Exception>, Item>();
        for (ExceptionTranslator exceptionTranslator : nonNullTranslators) {
            if (exceptionTranslator instanceof RuntimeExceptionTranslator) {
                Item[] oldItems;
                for (Item oldItem : oldItems = ((RuntimeExceptionTranslator)exceptionTranslator).items) {
                    itemMap.put(oldItem.type, oldItem);
                }
                continue;
            }
            Item item = new Item(RuntimeExceptionTranslator.exceptionType(exceptionTranslator), exceptionTranslator);
            if (!scatteredExceptionTypes.add(item.type)) {
                throw new IllegalArgumentException("Repeat configuration exception translator for exception type \"" + item.type.getName() + "\" in one configuration scope");
            }
            itemMap.put(item.type, item);
        }
        Item[] items = itemMap.values().toArray(EMPTY_ITEM_ARR);
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            for (int ii = i + 1; ii < n; ++ii) {
                if (!items[i].type.isAssignableFrom(items[ii].type)) continue;
                Item item = items[i];
                items[i] = items[ii];
                items[ii] = item;
            }
        }
        return new RuntimeExceptionTranslator(items);
    }

    private static Class<? extends Exception> exceptionType(ExceptionTranslator<?> translator) {
        Map typeMap = TypeUtils.getTypeArguments(translator.getClass(), ExceptionTranslator.class);
        if (typeMap.isEmpty()) {
            throw new IllegalArgumentException("Illegal exception translator type \"" + translator.getClass().getName() + "\", it does not specify the type argument of \"" + ExceptionTranslator.class.getName() + "\"");
        }
        Type type = (Type)typeMap.values().iterator().next();
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("Illegal exception translator type \"" + translator.getClass().getName() + "\", it specifies the type argument of \"" + ExceptionTranslator.class.getName() + "\" but that type is not class type");
        }
        Class exceptionType = (Class)type;
        if (!Exception.class.isAssignableFrom(exceptionType)) {
            throw new IllegalArgumentException("Illegal exception translator type \"" + translator.getClass().getName() + "\", it specifies the type argument of \"" + ExceptionTranslator.class.getName() + "\" as \"" + exceptionType.getName() + "\", but it is not derived type of \"" + RuntimeException.class.getName() + "\"");
        }
        if (exceptionType == Exception.class || exceptionType == RuntimeException.class) {
            throw new IllegalArgumentException("Illegal exception translator type \"" + translator.getClass().getName() + "\", it specifies the type argument of \"" + ExceptionTranslator.class.getName() + "\" as \"" + exceptionType.getName() + "\", that type is too general, please specify a more specific exception type");
        }
        return exceptionType;
    }

    private static class Item {
        final Class<? extends Exception> type;
        final ExceptionTranslator<Exception> translator;

        private Item(Class<? extends Exception> type, ExceptionTranslator<Exception> translator) {
            this.type = type;
            this.translator = translator;
        }
    }
}

