/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import javax.sql.DataSource;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ConnectionManager {
    public static final ConnectionManager EXTERNAL_ONLY = new ConnectionManager(){

        @Override
        public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
            Objects.requireNonNull(con, "External connection cannot be null");
            return block.apply(con);
        }
    };

    public static ConnectionManager singleConnectionManager(final Connection connection) {
        if (connection == null) {
            return EXTERNAL_ONLY;
        }
        return new ConnectionManager(){

            @Override
            public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
                return block.apply(con == null ? connection : con);
            }
        };
    }

    public static ConnectionManager simpleConnectionManager(final DataSource dataSource) {
        return new ConnectionManager(){
            private final ThreadLocal<Connection> local = new ThreadLocal();

            @Override
            public <R> R execute(@Nullable Connection con, Function<Connection, R> block) {
                if (con == null) {
                    return this.execute(block);
                }
                return block.apply(con);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            @Override
            public <R> R execute(Function<Connection, R> block) {
                Connection con = this.local.get();
                if (con != null) {
                    return block.apply(con);
                }
                try {
                    con = dataSource.getConnection();
                    try {
                        R r;
                        this.local.set(con);
                        try {
                            r = block.apply(con);
                            this.local.remove();
                        }
                        catch (Throwable throwable) {
                            this.local.remove();
                            throw throwable;
                        }
                        return r;
                    }
                    finally {
                        con.close();
                    }
                }
                catch (SQLException ex) {
                    throw new ExecutionException("Cannot open connection from datasource", ex);
                }
            }
        };
    }

    public <R> R execute(@Nullable Connection var1, Function<Connection, R> var2);

    default public <R> R execute(Function<Connection, R> block) {
        return this.execute(null, block);
    }
}

